/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.script;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.isc.util.dt.D;
import kd.bos.isc.util.misc.Json;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.common.util.SysUtil;
import kd.bos.openapi.form.plugin.script.util.ScriptCategory;
import kd.bos.openapi.form.plugin.script.util.ShowScriptHelpUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class OpenApiScriptHelperPlugin
extends AbstractListPlugin
implements ClickListener,
ListRowClickListener,
TreeNodeClickListener,
SearchEnterListener,
TreeNodeQueryListener {
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_BILLLIST = "billlistap";
    private static final String KEY_SEARCH = "searchap";
    private static final String BTNNEW = "btnnew";
    private static final String BTNEDIT = "btnedit";
    private static final String BTNDEL = "btndel";
    private static final String REFRESH = "refresh";
    private static final String BOS_OPEN_FORMPLUGIN = "bos-open-formplugin";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(Lang.zh_CN.equals((Object)Lang.get())), new String[]{"flex_tips"});
        this.getView().setVisible(Boolean.valueOf(Lang.zh_CN.equals((Object)Lang.get())), new String[]{"toolbarap", "splitcontainerap"});
        if (Lang.zh_CN != Lang.get()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u8bed\u8a00\u914d\u7f6e\u4e3a\uff1a%s,\u975e\u4e2d\u6587\u73af\u5883\u4e0b\u8be5\u529f\u80fd\u6682\u4e0d\u652f\u6301\u4f7f\u7528\u3002", (String)"OpenApiScriptHelperPlugin_5", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), Lang.get()));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
        this.refreshBillList("0", 1, null);
        if (SysUtil.isProdEnv()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"author"});
        }
    }

    private void initTree() {
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        tree.deleteAllNodes();
        TreeNode rootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"OpenApiScriptHelperPlugin_0", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
        tree.addNode(rootNode);
        tree.focusNode(rootNode);
        FormShowParameter param = this.getView().getFormShowParameter();
        String isfiltervalue = (String)param.getCustomParam("isfiltervalue");
        List<TreeNode> nodes = this.getChildNodes("0", "-");
        tree.addNodes(nodes);
        if ("true".equalsIgnoreCase(isfiltervalue)) {
            tree.expand("OpenScript-4");
            List<TreeNode> childNodes = this.getChildNodes("OpenScript", "-");
            tree.focusNode(childNodes.get(3));
        } else {
            tree.expand("0");
            tree.expand(this.getPageCache().get("scriptNode"));
            this.loadCategories();
            this.loadItems();
        }
    }

    private void loadItems() {
        DynamicObjectCollection items = QueryServiceHelper.query((String)"isc_help_item", (String)"id,group,number,name", (QFilter[])new QFilter[]{ShowScriptHelpUtil.getExcludeItemFilter()}, (String)"number");
        HashMap<String, String> cache = new HashMap<String, String>();
        for (DynamicObject item : items) {
            String parent = item.getString("group");
            String id = String.valueOf(item.get("id"));
            String number = item.getString("number");
            String title = item.getString("name");
            cache.put(id, title + ":" + number + ":" + parent);
        }
        ShowScriptHelpUtil.addAllOpenApiScriptItem(cache);
        this.getPageCache().put("itemCache", Json.toString(cache));
    }

    private void loadCategories() {
        DynamicObjectCollection categories = QueryServiceHelper.query((String)"isc_help_category", (String)"id,parent,name, number", (QFilter[])new QFilter[]{ShowScriptHelpUtil.getExcludeCategoryFilter()});
        HashMap<String, String> cache = new HashMap<String, String>();
        for (DynamicObject category : categories) {
            long parent = category.getLong("parent");
            String id = String.valueOf(category.get("id"));
            String title = category.getString("name");
            String number = category.getString("number");
            title = this.changeCategoryName(parent, title, number);
            cache.put(id, title + ":" + parent);
        }
        ShowScriptHelpUtil.addAllOpenApiScriptCategory(cache);
        this.getPageCache().put("categoriesCache", Json.toString(cache));
    }

    private String changeCategoryName(long parent, String title, String number) {
        if (parent == 0L && "SCRIPT".equals(number)) {
            title = ResManager.loadKDString((String)"\u901a\u7528\u811a\u672c", (String)"OpenApiScriptHelperPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]);
        }
        return title;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        if (KEY_TREEVIEW.equals(source.getKey())) {
            this.refreshBillList(DataUtil.s((Object)evt.getNodeId()), 1, null);
        }
    }

    private void refreshBillList(String nodeId, int i, String keyword) {
        BillList billList = (BillList)this.getControl(KEY_BILLLIST);
        if (ShowScriptHelpUtil.addOpenApiScript(nodeId, i, billList)) {
            return;
        }
        FilterParameter fp = new FilterParameter();
        String group = this.getPageCache().get("group");
        QFilter filter = null;
        if (StringUtil.isEmpty((String)nodeId) || "0".equals(nodeId)) {
            if (i == 2 && !StringUtil.isEmpty((String)group)) {
                List<Long> asList = this.getIDList(group);
                filter = new QFilter("id", "in", asList);
            }
        } else {
            List<Object> nodes = this.findChildrenNodes(DataUtil.l((Object)nodeId));
            filter = new QFilter("group", "in", nodes);
            if (i == 2 && !StringUtil.isEmpty((String)group)) {
                List<Long> asList = this.getIDList(group);
                filter.and(new QFilter("id", "in", asList));
            }
        }
        if (filter == null) {
            filter = ShowScriptHelpUtil.getExcludeItemFilter();
        } else {
            filter.and(ShowScriptHelpUtil.getExcludeItemFilter());
        }
        fp.setFilter(filter);
        billList.setFilterParameter(fp);
        QFilter finalFilter1 = filter;
        billList.addSetFilterListener(event -> event.getQFilters().add(finalFilter1));
        if ((StringUtil.isEmpty((String)nodeId) || "0".equals(nodeId)) && i == 1) {
            ShowScriptHelpUtil.addCreateListDataProviderListener(billList, nodeId, i, keyword);
        }
        billList.refresh();
        billList.clearSelection();
    }

    private List<Long> getIDList(String group) {
        String[] array = group.split(",");
        ArrayList<Long> ids = new ArrayList<Long>(array.length);
        for (String s : array) {
            if (ScriptCategory.isStartsWithOpenRoot(s)) continue;
            ids.add(Long.parseLong(s));
        }
        return ids;
    }

    private List<Object> findChildrenNodes(long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject object = QueryServiceHelper.queryOne((String)"isc_help_category", (String)"longnumber", (QFilter[])new QFilter[]{filter});
        assert (object != null);
        String longnumber = object.getString("longnumber");
        QFilter qFilter = new QFilter("longnumber", "like", (Object)(longnumber + ".%"));
        qFilter.or(new QFilter("longnumber", "=", (Object)longnumber));
        return QueryServiceHelper.queryPrimaryKeys((String)"isc_help_category", (QFilter[])new QFilter[]{qFilter}, null, (int)1000);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList list = (BillList)this.getControl(KEY_BILLLIST);
        list.addListRowClickListener((ListRowClickListener)this);
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{BTNNEW, BTNEDIT, BTNDEL, REFRESH});
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList list = (BillList)this.getView().getControl(KEY_BILLLIST);
        ListSelectedRow info = list.getCurrentSelectedRowInfo();
        if (info != null) {
            String number;
            String scens;
            String content;
            DynamicObject item;
            Object pk = info.getPrimaryKeyValue();
            if (DataUtil.l((Object)pk) > 0L) {
                item = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"isc_help_item", (String)"number,target_scens,help_text, help_content_tag");
                content = item.getString("help_content_tag");
                scens = item.getString("target_scens");
                number = item.getString("number");
            } else {
                item = BusinessDataServiceHelper.newDynamicObject((String)"isc_help_item");
                content = ShowScriptHelpUtil.getScriptContent(info.getNumber());
                scens = ",ALL,";
                number = info.getNumber();
            }
            Markdown mk = (Markdown)this.getView().getControl("markdownap");
            String[] strings = scens.split(",");
            StringBuilder sbuffer = new StringBuilder(strings.length);
            sbuffer.append("\n#### ");
            if (StringUtil.isEmpty((String)content) && StringUtil.isEmpty((String)(content = item.getString("help_text")))) {
                mk.setText(ResManager.loadKDString((String)"\u8be5\u63d2\u4ef6\u6b63\u5728\u5feb\u9a6c\u52a0\u97ad\u7684\u5f00\u53d1\u4e2d......", (String)"OpenApiScriptHelperPlugin_2", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (!content.trim().startsWith("#")) {
                content = "# " + number + "\n" + content;
            }
            int index = content.indexOf(ResManager.loadKDString((String)"\u57fa\u672c\u7528\u6cd5", (String)"OpenApiScriptHelperPlugin_3", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            StringBuilder builder = new StringBuilder();
            if (index != -1) {
                String str = content.substring(0, index);
                builder.append(str).append((CharSequence)sbuffer).append(content.substring(index));
            } else {
                index = content.indexOf(10);
                String str = content.substring(0, index);
                builder.append(str).append("\n#### ").append((CharSequence)sbuffer).append(content.substring(index));
            }
            mk.setText(builder.toString());
        }
    }

    public void search(SearchEnterEvent evt) {
        Map itemCache;
        String s;
        Map categoriesCache;
        Iterator<Map.Entry<String, String>> it;
        boolean found;
        String searchText = evt.getText();
        if (StringUtils.isNotEmpty((CharSequence)searchText) && !(found = this.searchKeywords(searchText, it = this.getEntryIterator(categoriesCache = (Map)Json.toObject((String)(s = this.getPageCache().get("categoriesCache")))), 1)) && !(found = this.searchKeywords(searchText, it = this.getEntryIterator(itemCache = (Map)Json.toObject((String)(s = this.getPageCache().get("itemCache")))), 2))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u5e2e\u52a9\u4fe1\u606f\u3002", (String)"OpenApiScriptHelperPlugin_4", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private Iterator<Map.Entry<String, String>> getEntryIterator(Map<String, String> cache) {
        return cache.entrySet().iterator();
    }

    private boolean searchKeywords(String text, Iterator<Map.Entry<String, String>> it, int i) {
        String nodeId = this.searchAndShowEntry(it, text, i);
        this.refreshBillList(nodeId, i, text);
        return !"".equals(nodeId);
    }

    private String searchAndShowEntry(Iterator<Map.Entry<String, String>> it, String text, int i) {
        String[] keywords = text.split("\\s+");
        int flag = 0;
        String nodeId = "0";
        StringBuilder buf = new StringBuilder();
        this.getPageCache().put("group", "");
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            String value = e.getValue();
            if (!this.containsAll(value, keywords)) continue;
            nodeId = e.getKey();
            if (i != 1) {
                String[] split = value.split(":");
                String group = split[split.length - 1];
                buf.append(nodeId).append(',');
                nodeId = group;
                ++flag;
                continue;
            }
            this.showEntry(nodeId);
            return nodeId;
        }
        if (flag == 0) {
            return "";
        }
        if (flag > 1) {
            nodeId = "0";
        }
        String s = buf.toString();
        String substring = s.substring(0, s.length() - 1);
        this.getPageCache().put("group", substring);
        this.showEntry(nodeId);
        return nodeId;
    }

    private boolean containsAll(String topic, String[] keywords) {
        String lowerCase = topic.toLowerCase();
        for (String key : keywords) {
            if (lowerCase.contains(key.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private void showEntry(String nodeId) {
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        tree.showNode(nodeId);
        tree.focusNode(new TreeNode("", nodeId, ""));
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        String pNodeId = evt.getNodeId().toString();
        if ("root".equals(pNodeId)) {
            this.refreshBillList(pNodeId, 1, null);
        } else {
            List<TreeNode> nodes = this.getChildNodes(pNodeId, "-");
            treeView.addNodes(nodes);
        }
    }

    private List<TreeNode> getChildNodes(String pNodeId, String pLongNumber) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        if (ScriptCategory.isStartsWithOpenRoot(pNodeId)) {
            nodes.addAll(ShowScriptHelpUtil.getOpenApiTreeNode(pNodeId));
        } else {
            DynamicObjectCollection categories = QueryServiceHelper.query((String)"isc_help_category", (String)"id,parent,name, number, longnumber", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)D.l((Object)pNodeId)).and(ShowScriptHelpUtil.getExcludeCategoryFilter())});
            for (DynamicObject category : categories) {
                long pid = category.getLong("parent");
                String id = String.valueOf(category.get("id"));
                String title = category.getString("name");
                String number = category.getString("number");
                title = this.changeCategoryName(pid, title, number);
                TreeNode node = new TreeNode(D.s((Object)pid), id, title);
                if (pid == 0L) {
                    this.getPageCache().put("scriptNode", id);
                }
                if (QueryServiceHelper.exists((String)"isc_help_category", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)D.l((Object)id))})) {
                    node.setChildren(this.getChildNodes(id, category.getString("longnumber")));
                }
                nodes.add(node);
            }
        }
        if ("0".equals(pNodeId)) {
            nodes.addAll(ShowScriptHelpUtil.getOpenApiTreeNode());
        }
        return nodes;
    }
}

