/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.script;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class OpenApiScriptManagePlugin
extends AbstractBasePlugIn {
    private static final Log log = LogFactory.getLog(OpenApiScriptManagePlugin.class);
    private static final String BTN_OK = "btnok";
    public static final String BAR_SAVE = "save";
    public static final String KEY_SCRIPT_CODE = "script_code_tag";
    public static final String IS_PRESET = "is_preset";
    private static final String BOS_OPEN_FORMPLUGIN = "bos-open-formplugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject dynamicObject;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String scriptSortNumber = (String)formShowParameter.getCustomParam("current_node");
        if (!StringUtils.isEmpty((String)scriptSortNumber) && (dynamicObject = QueryServiceHelper.queryOne((String)"openapi_script_sort", (String)"Id,isleaf", (QFilter[])new QFilter("number", "=", (Object)scriptSortNumber).toArray())) != null && dynamicObject.getString("isleaf").equalsIgnoreCase("true")) {
            this.getModel().setValue("script_sort", (Object)dynamicObject.getString("Id"));
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        CodeEdit edit = (CodeEdit)this.getView().getControl("code");
        Object code = this.getModel().getValue(KEY_SCRIPT_CODE);
        this.getView().updateView("code");
        this.getModel().updateCache();
        if (code != null) {
            edit.setText(code.toString());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && BAR_SAVE.equals(operateKey = (operate = (AbstractOperate)args.getSource()).getOperateKey())) {
            Boolean isPreset = (Boolean)this.getModel().getValue(IS_PRESET);
            if (isPreset.booleanValue()) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7684\u4ee3\u7801\u7247\u6bb5\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"OpenApiScriptManagePlugin_0", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            CodeEdit edit = (CodeEdit)this.getView().getControl("code");
            String code = edit.getText();
            if (code != null) {
                this.getModel().setValue(KEY_SCRIPT_CODE, (Object)code);
            }
        }
    }

    public void afterCopyData(EventObject e) {
        this.getModel().setValue(IS_PRESET, (Object)false);
        CodeEdit edit = (CodeEdit)this.getView().getControl("code");
        edit.setText(this.getModel().getValue(KEY_SCRIPT_CODE).toString());
    }
}

