/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.test;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Closeable;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.IOUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.OpenApiTestApiPlugin;
import kd.bos.openapi.form.util.OpenApiTestUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class OpenApiTestCaseListPlugin
extends AbstractTreeListPlugin {
    private static final Log log = LogFactory.getLog(OpenApiTestApiPlugin.class);
    private static final String ID = "id";
    private static final String BTN_DOTEST = "dotest";
    private static final String TBLDEL = "delete";
    private static final String BTN_APIDATA = "apidata";
    private static final Integer TIME_OUT = 60000;
    private static final String HTTPMETHOD = "httpmethod";
    private static final String APISERVICETYPE = "apiServiceType";
    private static final String KEY_TESTRECORD = "testrecord";
    private static final String KEY_BILLLISTAP = "billlistap";
    private static final String KEY_BILLNO = "billno";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_TESTCASE = "testcase";
    private static final String KEY_API = "api";
    private static final String KEY_BD_TYPE = "bd_type";
    private static final String KEY_BD_TEXT_TAG = "bd_text_tag";
    private static final String KEY_URLFORMAT = "urlformat";
    private static final String KEY_TESTRESULT = "testresult";
    private static final String KEY_TESTFAILREASON = "testfailreason";
    private static final String KEY_RESPONSEPARAM = "responseparam";
    private static final String KEY_REQUESTPARAM = "requestparam";
    private static final String KEY_EXECUTIONTIME = "executiontime";
    private static final String KEY_CREATOR = "creator";
    private static final String KEY_CREATETIME = "createtime";
    private static final String KEY_HTTPSTATUS = "httpstatus";
    private static final String KEY_TESTTIME = "testtime";
    private static final String KEY_URLPARAMENTRYENTITY = "urlparamentryentity";
    private static final String KEY_BODYENTRYENTITY = "bodyentryentity";
    private static final String KEY_URLPARAMVALUE = "urlparamvalue";
    private static final String KEY_URLPARAMKEY = "urlparamkey";
    private static final String KEY_PARAMKEY = "paramkey";
    private static final String KEY_PARAMVALUE = "paramvalue";
    private static final String KEY_HTTPCODEENTRYENTITY = "httpcodeentryentity";
    private static final String KEY_HTTPCODE = "httpcode";
    private static final String KEY_ISHTTPCODECHECK = "ishttpcodecheck";
    private static final String KEY_TIMEOUTCHECK = "timeoutcheck";
    private static final String KEY_TIMELIMIT_BASIS = "timelimit_basis";
    private static final String KEY_TIMELIMIT = "timelimit";
    private static final String KEY_RESPONSEBODY = "responsebody";
    private static final String KEY_MUSTCONTAIN = "mustcontain";
    private static final String KEY_RESPKEY = "respkey";
    private static final String KEY_TYPECHECK = "typecheck";
    private static final String KEY_DATATYPE = "datatype";
    private static final String KEY_CONTENTCHECK = "contentcheck";
    private static final String KEY_COMPARETYPE = "comparetype";
    private static final String KEY_EX_RESULTS = "ex_results";
    private static final String MESSAGE = "message";
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String DATA = "data";
    private static final String FORM_OPENAPI_TEST_RECORD = "openapi_test_record";
    private static final String BOS_OPEN_FORMPLUGIN = "bos-open-formplugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String envType = System.getProperty("env.type");
        if ("prod".equals(envType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_DOTEST});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent arg0) {
        super.beforeItemClick(arg0);
        if (BTN_DOTEST.equals(arg0.getItemKey()) || BTN_APIDATA.equals(arg0.getItemKey())) {
            if (this.getSelectedRows().size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u6d4b\u8bd5\u7528\u4f8b\u3002", (String)"OpenApiTestCaseListPlugin_23", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                arg0.setCancel(true);
            } else if (this.getSelectedRows().size() > 20) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e920\u6761\u4ee5\u5185\u7528\u4f8b\u6d4b\u8bd5\u3002", (String)"OpenApiTestCaseListPlugin_20", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                OpenApiTestUtil util;
                if (BTN_APIDATA.equals(arg0.getItemKey()) && this.getSelectedRows().size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u90091\u6761\u6d4b\u8bd5\u7528\u4f8b\u3002", (String)"OpenApiTestCaseListPlugin_21", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                    arg0.setCancel(true);
                }
                if ("no3rdApp".equals((util = new OpenApiTestUtil()).checkIsHasApitest3rdApp())) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("apitest", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"API\u6d4b\u8bd5\u8bf7\u6c42\u521b\u5efa\u7b2c\u4e09\u65b9\u5e94\u7528\uff08openapi_unittest\uff09", (String)"OpenApiFormPlugin_89", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                    arg0.setCancel(true);
                } else if ("hasSelf3rdApp".equals(util.checkIsHasApitest3rdApp())) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\uff08openapi_unittest\uff09\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u7b2c\u4e09\u65b9\u5e94\u7528\u7f16\u7801", (String)"OpenApiFormPlugin_90", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                    arg0.setCancel(true);
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (BTN_DOTEST.equals(evt.getItemKey())) {
            this.dotest();
        } else if (BTN_APIDATA.equals(evt.getItemKey())) {
            DynamicObject[] testCases = this.getAllSelectData();
            ListView view = (ListView)this.getView();
            for (DynamicObject testCase : testCases) {
                DynamicObject kapi = testCase.getDynamicObject(KEY_API);
                BaseShowParameter showParameter = new BaseShowParameter();
                showParameter.setPkId(kapi.get(ID));
                if ("2".equals(kapi.getString(APISERVICETYPE))) {
                    showParameter.setFormId(ApiServiceType.CUSTOM.getEntityName());
                    showParameter.setCaption(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u670d\u52a1", (String)"OpenApiCustomApiFormPlugin_0", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                } else if ("3".equals(kapi.getString(APISERVICETYPE))) {
                    showParameter.setFormId(ApiServiceType.SCRIPT.getEntityName());
                } else {
                    showParameter.setFormId(ApiServiceType.OPERATION.getEntityName());
                    showParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u670d\u52a1", (String)"OpenApiFormPlugin_0", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                }
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                view.showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && TBLDEL.equals(operateKey = (operate = (AbstractOperate)args.getSource()).getOperateKey())) {
            QFilter qFilter = new QFilter("testcase.id", "in", (Object)args.getListSelectedData().getPrimaryKeyValues());
            DeleteServiceHelper.delete((String)FORM_OPENAPI_TEST_RECORD, (QFilter[])qFilter.toArray());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals(KEY_TESTRECORD)) {
            BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
            String number = billList.getCurrentSelectedRowInfo().getNumber();
            DynamicObject record = QueryServiceHelper.queryOne((String)FORM_OPENAPI_TEST_RECORD, (String)ID, (QFilter[])new QFilter(KEY_BILLNO, "=", (Object)(number + "_record")).toArray());
            if (null != record) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId(FORM_OPENAPI_TEST_RECORD);
                showParameter.setPkId(record.get(ID));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6d4b\u8bd5\u7ed3\u679c\u3002", (String)"OpenApiTestCaseListPlugin_2", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals("apitest") && evt.getResult() == MessageBoxResult.Yes) {
            OpenApiTestUtil util = new OpenApiTestUtil();
            util.createUnittestApp();
            this.dotest();
        }
    }

    private DynamicObject[] getAllSelectData() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        ArrayList<Object> pks = new ArrayList<Object>();
        for (ListSelectedRow row : rows) {
            pks.add(row.getPrimaryKeyValue());
        }
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        DynamicObject[] testCases = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)billList.getEntityType());
        return testCases;
    }

    private void dotest() {
        DynamicObject[] testCases = this.getAllSelectData();
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        Arrays.asList(testCases).stream().forEach(testCase -> this.apiTest((DynamicObject)testCase, false));
        billList.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object apiTest(DynamicObject testCase, boolean isForm) {
        CloseableHttpClient httpClient;
        CloseableHttpResponse response;
        block23: {
            Header[] messages;
            Header[] status;
            if (testCase.getDynamicObject(KEY_API).get("status").equals("D")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"API\u5df2\u7981\u7528\u65e0\u6cd5\u8c03\u7528\u3002", (String)"OpenApiTestCaseListPlugin_22", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                return null;
            }
            Object preData = null;
            response = null;
            httpClient = null;
            OpenApiTestUtil util = new OpenApiTestUtil();
            Map<String, Object> map = util.getAccessTokenByAppId();
            if (null == map.get("access_token")) {
                throw new KDBizException(map.get("request").toString());
            }
            httpClient = HttpClientBuilder.create().build();
            boolean isGetMethod = testCase.getDynamicObject(KEY_API).getString(HTTPMETHOD).equals("0");
            preData = isGetMethod ? this.buildPreData(testCase) : (!testCase.get(KEY_BD_TYPE).equals("1") ? testCase.get(KEY_BD_TEXT_TAG) : this.buildPreData(testCase));
            String fullUrl = this.urlFormart(isGetMethod, testCase.getDynamicObject(KEY_API).getString(KEY_URLFORMAT), preData, false);
            Long startTime = System.currentTimeMillis();
            response = this.doApiTestCase(httpClient, fullUrl, preData, isGetMethod, map.get("access_token").toString());
            Long endTime = System.currentTimeMillis();
            if (response == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u53e3\u5f02\u5e38\u3002", (String)"OpenApiTestApiPlugin_0", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
            boolean isSuccess = false;
            for (Header header : status = response.getHeaders("OpenApi-Status")) {
                if (!header.getName().equals("OpenApi-Status")) continue;
                isSuccess = header.getValue().equals("true");
            }
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject jsonObject = null;
            try {
                jsonObject = (JSONObject)JsonUtil.parseJson((String)result);
            }
            catch (Exception ex) {
                log.info(ResManager.loadKDString((String)"\u6d4b\u8bd5API\u65f6\uff0c\u8fd4\u56de\u7ed3\u679c\u4e0d\u662fjson\u5bf9\u8c61 ", (String)"OpenApiTestApiPlugin_3", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]) + ex);
            }
            boolean hasRecord = QueryServiceHelper.exists((String)FORM_OPENAPI_TEST_RECORD, (QFilter[])new QFilter("testcase.id", "=", testCase.get(ID)).toArray());
            if (hasRecord) {
                DeleteServiceHelper.delete((String)FORM_OPENAPI_TEST_RECORD, (QFilter[])new QFilter("testcase.id", "=", testCase.get(ID)).toArray());
            }
            DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)FORM_OPENAPI_TEST_RECORD);
            record.set(KEY_BILLNO, (Object)(testCase.getString(KEY_NUMBER) + "_record"));
            record.set(KEY_TESTCASE, (Object)testCase);
            record.set(KEY_API, (Object)testCase.getDynamicObject(KEY_API));
            record.set(KEY_HTTPSTATUS, (Object)response.getStatusLine().getStatusCode());
            record.set(KEY_TESTRESULT, (Object)(isSuccess ? "0" : "1"));
            Object message = null;
            if (testCase.getDynamicObject(KEY_API).getString(APISERVICETYPE).equals("2")) {
                if (null == jsonObject) {
                    for (Header header : messages = response.getHeaders("OpenApi-Message")) {
                        if (!header.getName().equals("OpenApi-Message")) continue;
                        message = URLDecoder.decode(header.getValue(), "UTF-8");
                    }
                } else {
                    message = jsonObject.get((Object)MESSAGE);
                }
            } else if (jsonObject.containsKey((Object)MESSAGE)) {
                message = jsonObject.get((Object)MESSAGE);
            } else {
                for (Header header : messages = response.getHeaders("OpenApi-Message")) {
                    if (!header.getName().equals("OpenApi-Message")) continue;
                    message = URLDecoder.decode(header.getValue(), "UTF-8");
                }
            }
            record.set(KEY_TESTFAILREASON, (Object)(!isSuccess ? String.format(ResManager.loadKDString((String)"1.\u6b63\u5e38\u8bf7\u6c42\u62a5\u9519 %1$s %2$s %3$s", (String)"OpenApiTestCaseListPlugin_5", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), StringUtil.substring((Object)message, (int)1000), "\\r", "\\n") : String.format(ResManager.loadKDString((String)"1.\u8bf7\u6c42\u901a\u8fc7%1$s", (String)"OpenApiTestCaseListPlugin_9", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), "\\r\\n")));
            testCase.set(KEY_TESTRECORD, (Object)(isSuccess ? "0" : "1"));
            record.set(KEY_EXECUTIONTIME, (Object)(endTime - startTime));
            record.set(KEY_RESPONSEPARAM, (Object)(null != jsonObject ? StringUtil.substring((Object)jsonObject, (int)2000) : result));
            if (testCase.get(KEY_TESTRECORD).equals("0") && null != jsonObject) {
                this.checkAssertionsRules(record, testCase, jsonObject);
                if (testCase.getString(KEY_TESTRECORD).equals("0") || StringUtil.isEmpty((String)record.getString(KEY_TESTFAILREASON))) {
                    record.set(KEY_TESTFAILREASON, (Object)ResManager.loadKDString((String)"\u901a\u8fc7", (String)"OpenApiTestCaseListPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                }
            }
            record.set(KEY_CREATOR, (Object)RequestContext.get().getUserId());
            record.set(KEY_CREATETIME, (Object)new Date());
            record.set(KEY_REQUESTPARAM, isGetMethod ? this.urlFormart(isGetMethod, testCase.getDynamicObject(KEY_API).getString(KEY_URLFORMAT), preData, true) : preData);
            if (null == record.get(KEY_TESTCASE)) break block23;
            Object[] records = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
            if (records.length <= 0) {
                log.info("save record fail");
            }
            testCase.set(KEY_TESTTIME, (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{testCase});
            if (records.length <= 0 || !isForm) break block23;
            Object object = records[0];
            IOUtil.closeQuietly((Closeable)response);
            IOUtil.closeQuietly((Closeable)httpClient);
            return object;
        }
        try {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8c03\u7528\u6210\u529f\u3002", (String)"OpenApiTestApiPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
        }
        catch (Exception e) {
            try {
                log.info(e.getMessage());
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u7528\u5931\u8d25\u3002", (String)"OpenApiTestApiPlugin_2", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(response);
                IOUtil.closeQuietly(httpClient);
                throw throwable;
            }
            IOUtil.closeQuietly(response);
            IOUtil.closeQuietly((Closeable)httpClient);
        }
        IOUtil.closeQuietly((Closeable)response);
        IOUtil.closeQuietly((Closeable)httpClient);
        return null;
    }

    private CloseableHttpResponse doApiTestCase(CloseableHttpClient httpClient, String url, Object data, boolean isGetMethod, String token) throws Exception {
        if (null == RequestContext.get().getApi3rdAppId()) {
            RequestContext.get().setApi3rdAppId(QueryServiceHelper.queryOne((String)"third_app", (String)ID, (QFilter[])new QFilter(KEY_NUMBER, "=", (Object)"unittest").toArray()).getString(ID));
        }
        HashMap<String, String> header = new HashMap<String, String>(2);
        if (isGetMethod) {
            header.put(CONTENT_TYPE, "application/x-www-form-urlencoded");
            String fullUrl = url.replace(' ', '+').replace("\"", "");
            return this.doGet(fullUrl, token);
        }
        String protocolType = "";
        header.put(CONTENT_TYPE, this.getHeaderValue(protocolType));
        header.put(ACCESS_TOKEN, token);
        return this.doPost(httpClient, url, header, data.toString());
    }

    private String getHeaderValue(String protocolType) {
        String header = null;
        header = "application/json";
        return header;
    }

    private RequestConfig getRequestConfig() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(TIME_OUT.intValue()).setRedirectsEnabled(true).build();
        return requestConfig;
    }

    private CloseableHttpResponse doGet(String url, String accessToken) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(url);
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        httpGet.setHeader(CONTENT_TYPE, "application/x-www-form-urlencoded");
        if (null != accessToken && accessToken.length() <= 50) {
            accessToken = RequestContext.get().getYzjAppTicket();
        }
        httpGet.setHeader(ACCESS_TOKEN, accessToken);
        RequestConfig requestConfig = this.getRequestConfig();
        httpGet.setConfig(requestConfig);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        return response;
    }

    private CloseableHttpResponse doPost(CloseableHttpClient httpClient, String url, Map<String, String> header, String reqStr) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        String reqString = reqStr;
        StringEntity entity = new StringEntity(reqString, "UTF-8");
        RequestConfig requestConfig = this.getRequestConfig();
        httpPost.setConfig(requestConfig);
        httpPost.setEntity((HttpEntity)entity);
        Set<Map.Entry<String, String>> entrySet = header.entrySet();
        entrySet.stream().forEach(it -> httpPost.setHeader((String)it.getKey(), (String)it.getValue()));
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        return response;
    }

    private Object buildPreData(DynamicObject testCase) {
        boolean isGetMethod = testCase.getDynamicObject(KEY_API).getString(HTTPMETHOD).equals("0");
        if (isGetMethod) {
            HashMap<Object, String> preMap = new HashMap<Object, String>();
            DynamicObjectCollection urlparm = testCase.getDynamicObjectCollection(KEY_URLPARAMENTRYENTITY);
            for (DynamicObject param : urlparm) {
                preMap.put(param.get(KEY_URLPARAMVALUE), param.getString(KEY_URLPARAMKEY));
            }
            return preMap;
        }
        HashMap<String, Object> preMap = new HashMap<String, Object>();
        DynamicObjectCollection bodys = testCase.getDynamicObjectCollection(KEY_BODYENTRYENTITY);
        for (DynamicObject body : bodys) {
            preMap.put(body.getString(KEY_PARAMKEY), body.get(KEY_PARAMVALUE));
        }
        return preMap;
    }

    public String urlFormart(boolean isGetMethod, String urlFormat, Object preData, boolean isQueryParam) {
        String urlCosmic = UrlService.getDomainContextUrl();
        String preUrl = "/kapi" + urlFormat;
        if (isGetMethod) {
            Map<String, Object> getDataMap = this.getMethodData(preData);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Object> entry : getDataMap.entrySet()) {
                String value;
                if (sb.length() > 0) {
                    sb.append('&');
                }
                if ((value = entry.getKey()) instanceof JSONArray) {
                    JSONArray valArray = (JSONArray)value;
                    for (int i = 0; i < valArray.size(); ++i) {
                        sb.append(i == 0 ? "" : Character.valueOf('&')).append(entry.getValue()).append('=').append(valArray.get(i));
                    }
                    continue;
                }
                sb.append(entry.getValue()).append('=').append((Object)value);
            }
            if (isQueryParam) {
                return sb.toString().trim();
            }
            sb.insert(0, '?');
            sb.insert(0, preUrl);
            sb.insert(0, urlCosmic);
            String json = sb.toString().trim();
            return json;
        }
        String urlvalue = urlCosmic + preUrl;
        return urlvalue;
    }

    private Map<String, Object> getMethodData(Object preData) {
        if (!(preData instanceof Map)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\u3002", (String)"OpenApiTestApiPlugin_5", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
        }
        Map map = (Map)preData;
        HashMap<String, Object> getDataMap = (HashMap<String, Object>)map.get(DATA);
        if (getDataMap == null) {
            getDataMap = new HashMap<String, Object>(map.size());
        }
        for (Map.Entry entry : map.entrySet()) {
            if (DATA.equals(entry.getKey())) continue;
            getDataMap.put((String)entry.getKey(), entry.getValue());
        }
        return getDataMap;
    }

    private void checkAssertionsRules(DynamicObject record, DynamicObject testCase, JSONObject jsonObject) {
        StringBuilder reason = new StringBuilder();
        reason.append(record.getString(KEY_TESTFAILREASON));
        DynamicObjectCollection httpCodesEntry = testCase.getDynamicObjectCollection(KEY_HTTPCODEENTRYENTITY);
        reason.append(ResManager.loadKDString((String)"2.\u65ad\u8a00\u89c4\u5219 - HTTP\u72b6\u6001\u7801\uff1a", (String)"OpenApiTestCaseListPlugin_10", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
        if (CollectionUtil.isNotEmpty((Collection)httpCodesEntry)) {
            Set httpCodes = httpCodesEntry.stream().filter(hc -> hc.getBoolean(KEY_ISHTTPCODECHECK)).map(it -> it.getString(KEY_HTTPCODE)).collect(Collectors.toSet());
            if (httpCodes.size() > 0 && !httpCodes.contains(record.getString(KEY_HTTPSTATUS))) {
                record.set(KEY_TESTRESULT, (Object)"1");
                reason.append(String.format(ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7\uff0c\u5339\u914d\u89c4\u5219\u4e3a: %1$s \uff0c\u5b9e\u9645\u8fd4\u56de: %2$s %3$s %4$s", (String)"OpenApiTestCaseListPlugin_3", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), httpCodes.toString(), record.getString(KEY_HTTPSTATUS), "\\r", "\\n"));
                testCase.set(KEY_TESTRECORD, (Object)"1");
            } else {
                reason.append(ResManager.loadKDString((String)"\u901a\u8fc7", (String)"OpenApiTestCaseListPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                reason.append("\r\n");
            }
        } else {
            reason.append(ResManager.loadKDString((String)"\u901a\u8fc7", (String)"OpenApiTestCaseListPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            reason.append("\r\n");
        }
        DynamicObjectCollection respEntry = testCase.getDynamicObjectCollection(KEY_RESPONSEBODY);
        if (CollectionUtil.isNotEmpty((Collection)respEntry)) {
            HashMap<String, Object> respMap = new HashMap<String, Object>();
            this.respJsonToMap(jsonObject, respMap);
            reason.append(ResManager.loadKDString((String)"3.\u65ad\u8a00\u89c4\u5219 - \u8fd4\u56de\u53c2\u6570\uff1a", (String)"OpenApiTestCaseListPlugin_7", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            reason.append("\r\n\t");
            Set respMust = respEntry.stream().filter(t -> t.getBoolean(KEY_MUSTCONTAIN)).map(it -> it.getString(KEY_RESPKEY)).collect(Collectors.toSet());
            if (respMust.size() > 0) {
                reason.append(ResManager.loadKDString((String)"a. \u5305\u542b\u6821\u9a8c\uff1a  ", (String)"OpenApiTestCaseListPlugin_12", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                int startSize = reason.length();
                for (Object field : respMust) {
                    if (respMap.containsKey(field)) continue;
                    reason.append(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u540d\uff1a%s\u4e0d\u5b58\u5728 ", (String)"OpenApiTestCaseListPlugin_13", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), field));
                    testCase.set(KEY_TESTRECORD, (Object)"1");
                    record.set(KEY_TESTRESULT, (Object)"1");
                }
                if (reason.length() <= startSize) {
                    reason.append(ResManager.loadKDString((String)"\u901a\u8fc7", (String)"OpenApiTestCaseListPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                }
            } else {
                reason.append(ResManager.loadKDString((String)"a. \u5305\u542b\u6821\u9a8c\uff1a  \u901a\u8fc7", (String)"OpenApiTestCaseListPlugin_24", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
            reason.append("\r\n\t");
            Map<String, String> respType = respEntry.stream().filter(t -> t.getBoolean(KEY_TYPECHECK)).collect(Collectors.toMap(it -> it.getString(KEY_RESPKEY), it -> it.getString(KEY_DATATYPE)));
            if (respType.size() > 0) {
                reason.append(ResManager.loadKDString((String)"b. \u683c\u5f0f\u6821\u9a8c\uff1a  ", (String)"OpenApiTestCaseListPlugin_14", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                int startSize = reason.length();
                for (Map.Entry entry : respType.entrySet()) {
                    if (!respMap.containsKey(entry.getKey()) || respMap.get(entry.getKey()).getClass().getName().equals(entry.getValue())) continue;
                    reason.append(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u540d\uff1a%s\u683c\u5f0f\u4e0d\u6b63\u786e ", (String)"OpenApiTestCaseListPlugin_15", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), entry.getKey()));
                    record.set(KEY_TESTRESULT, (Object)"1");
                    testCase.set(KEY_TESTRECORD, (Object)"1");
                }
                if (reason.length() <= startSize) {
                    reason.append(ResManager.loadKDString((String)"\u901a\u8fc7", (String)"OpenApiTestCaseListPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                }
            } else {
                reason.append(ResManager.loadKDString((String)"b. \u683c\u5f0f\u6821\u9a8c\uff1a  \u901a\u8fc7", (String)"OpenApiTestCaseListPlugin_25", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
            reason.append("\r\n\t");
            Map<String, String> respCons = this.contentToMap(respEntry);
            if (respCons.size() > 0) {
                reason.append(ResManager.loadKDString((String)"c. \u5185\u5bb9\u6821\u9a8c\uff1a  ", (String)"OpenApiTestCaseListPlugin_16", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                int startSize = reason.length();
                for (Map.Entry<String, String> respCon : respCons.entrySet()) {
                    String result = jsonObject.toJSONString();
                    boolean isCancel = respCon.getValue().equals("!=") && result.contains(respCon.getKey()) || respCon.getValue().equals("=") && !result.contains(respCon.getKey());
                    if (!isCancel) continue;
                    reason.append(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u5185\u5bb9\uff1a%s\u6821\u9a8c\u4e0d\u901a\u8fc7", (String)"OpenApiTestCaseListPlugin_17", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), respCon.getKey()));
                    testCase.set(KEY_TESTRECORD, (Object)"1");
                    record.set(KEY_TESTRESULT, (Object)"1");
                }
                if (reason.length() <= startSize) {
                    reason.append(ResManager.loadKDString((String)"\u901a\u8fc7", (String)"OpenApiTestCaseListPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
                }
            } else {
                reason.append(ResManager.loadKDString((String)"c. \u5185\u5bb9\u6821\u9a8c\uff1a  \u901a\u8fc7", (String)"OpenApiTestCaseListPlugin_26", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
            reason.append("\r\n");
        }
        reason.append(ResManager.loadKDString((String)"4.\u65ad\u8a00\u89c4\u5219 - \u54cd\u5e94\u65f6\u95f4\uff1a", (String)"OpenApiTestCaseListPlugin_18", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
        if (testCase.getBoolean(KEY_TIMEOUTCHECK) && testCase.getString(KEY_TIMELIMIT_BASIS).equals("1")) {
            if (testCase.getInt(KEY_TIMELIMIT) > 0 && record.getInt(KEY_EXECUTIONTIME) > testCase.getInt(KEY_TIMELIMIT)) {
                record.set(KEY_TESTRESULT, (Object)"1");
                reason.append(String.format(ResManager.loadKDString((String)"\u54cd\u5e94\u65f6\u95f4\u8d85\u65f6\uff0c\u65f6\u95f4\u9650\u5236\u4e3a\uff1a%1$sms\uff0c\u5b9e\u9645\u65f6\u95f4\uff1a%2$sms", (String)"OpenApiTestCaseListPlugin_4", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), testCase.getInt(KEY_TIMELIMIT), record.getInt(KEY_EXECUTIONTIME)));
                testCase.set(KEY_TESTRECORD, (Object)"1");
                record.set(KEY_TESTRESULT, (Object)"1");
            } else {
                reason.append(ResManager.loadKDString((String)"\u901a\u8fc7", (String)"OpenApiTestCaseListPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else {
            reason.append(ResManager.loadKDString((String)"\u901a\u8fc7", (String)"OpenApiTestCaseListPlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]));
        }
        record.set(KEY_TESTFAILREASON, (Object)reason.toString());
    }

    private Map<String, String> contentToMap(DynamicObjectCollection respEntry) {
        List resps = respEntry.stream().filter(t -> t.getBoolean(KEY_CONTENTCHECK)).collect(Collectors.toList());
        HashMap<String, String> kvMap = new HashMap<String, String>(resps.size());
        for (DynamicObject resp : resps) {
            StringBuilder kv = new StringBuilder();
            kv.append("\"");
            kv.append(resp.getString(KEY_RESPKEY));
            kv.append("\"");
            kv.append(":");
            kv.append("\"");
            kv.append(resp.getString(KEY_EX_RESULTS));
            kv.append("\"");
            kvMap.put(kv.toString(), resp.getString(KEY_COMPARETYPE));
        }
        return kvMap;
    }

    private void respJsonToMap(JSONObject jsonObject, Map<String, Object> respMap) {
        for (String key : jsonObject.keySet()) {
            if (!key.equals(DATA) && !key.equals("rows")) {
                respMap.put(key, jsonObject.get((Object)key));
            }
            if (jsonObject.get((Object)key) instanceof JSONArray) {
                for (Object item : (JSONArray)jsonObject.get((Object)key)) {
                    if (item instanceof JSONObject) {
                        this.respJsonToMap((JSONObject)item, respMap);
                        continue;
                    }
                    respMap.put(item.toString(), item);
                }
                continue;
            }
            if (!(jsonObject.get((Object)key) instanceof JSONObject)) continue;
            this.respJsonToMap((JSONObject)jsonObject.get((Object)key), respMap);
        }
    }
}

