/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isc.util.dt.D;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.IpTypeEnum;
import kd.bos.openapi.common.util.IPWhiteListUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.thirdapp.entity.ThirdAppEditDto;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateRouteService;

public class AccessControlStrategyEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
ItemClickListener,
ClickListener {
    private static final Log log = LogFactory.getLog(AccessControlStrategyEditPlugin.class);
    public static final String ACCESS_CONTROL_STRATEGY_EDIT = "acesscl_strategy_edit";
    private static final String BUTTON_NEXT = "btnok";
    private static final String BUTTON_CANCEL = "btncancel";
    public static final String ACCESS_TOKEN = "accesstoken";
    public static final String THIRD_IP_ID = "thirdipid";
    private static final String BUTTON_ADD = "btnadd";
    private static final String BUTTON_DELETE = "btndelete";
    public static final String TB_IPS = "t_open_3rdapps_ips";
    private static final String BUTTON_ADD_SSOIP = "btnaddssoip";
    private static final String BUTTON_DELETE_SSOIP = "btndeletessoip";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_CANCEL, BUTTON_NEXT, BUTTON_ADD, BUTTON_ADD_SSOIP, BUTTON_DELETE_SSOIP});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter billShowParameter = this.getView().getFormShowParameter();
        String strategyCode = (String)billShowParameter.getCustomParam("strategycode");
        this.getModel().setValue("strategycode", (Object)strategyCode);
        this.getModel().setValue("thirdAppModel", billShowParameter.getCustomParam("thirdAppModel"));
        StrategyUpdateRouteService.getStrategyUpdateService(strategyCode).loadData(this.getModel());
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"policytype"});
        this.updateButtonEnable();
    }

    private void updateButtonEnable() {
        if (((Boolean)this.getModel().getValue("allowip")).booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BUTTON_ADD, BUTTON_DELETE});
            this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"startip", "endip", "policytype", "iptype"});
            this.setButtonStyle(BUTTON_ADD, "#999999", null);
            this.setButtonStyle(BUTTON_DELETE, "#999999", null);
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{BUTTON_ADD, BUTTON_DELETE});
            this.getView().setEnable(Boolean.valueOf(true), -1, new String[]{"startip", "endip", "policytype", "iptype"});
            this.setButtonStyle(BUTTON_ADD, "themeColor", null);
            this.setButtonStyle(BUTTON_DELETE, "themeColor", null);
        }
        this.getView().updateView();
    }

    private void setButtonStyle(String btnKey, String foreColor, String backColor) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((String)foreColor)) {
            params.put("fc", foreColor);
        }
        if (StringUtil.isNotEmpty((String)backColor)) {
            params.put("bc", backColor);
        }
        this.getView().updateControlMetadata(btnKey, params);
    }

    public void click(EventObject evt) {
        super.click(evt);
        try {
            if (evt.getSource() instanceof Button) {
                Button textEdit = (Button)evt.getSource();
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entity_ssoip");
                DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
                if (BUTTON_ADD_SSOIP.equalsIgnoreCase(textEdit.getKey())) {
                    DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
                    dynamicObject.set("thirdipid1", (Object)DB.genLongId((String)"t_open_3rdapps_ssoip"));
                    entryEntity.add((Object)dynamicObject);
                    this.getModel().updateEntryCache(entryEntity);
                    this.getView().updateView();
                } else if (BUTTON_DELETE_SSOIP.equalsIgnoreCase(textEdit.getKey())) {
                    EntryGrid entryGrid = (EntryGrid)this.getControl("entity_ssoip");
                    int[] selectRows = entryGrid.getSelectRows();
                    if (selectRows.length == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u884c\u3002", (String)"AccessControlStrategyEditPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.getModel().deleteEntryRows("entity_ssoip", selectRows);
                    this.getModel().updateEntryCache(entryEntity);
                    this.getView().updateView();
                }
            }
        }
        catch (OpenApiException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        try {
            if ("allowip".equals(name)) {
                DynamicObjectCollection iplist = this.getModel().getEntryEntity("entryentity_ip");
                List deleteIndexList = iplist.stream().filter(dy -> StringUtil.isEmpty((String)dy.getString("startip")) && StringUtil.isEmpty((String)dy.getString("endip"))).map(dynamicObject -> dynamicObject.getInt("seq") - 1).collect(Collectors.toList());
                this.getModel().deleteEntryRows("entryentity_ip", deleteIndexList.stream().mapToInt(Integer::intValue).toArray());
                this.updateButtonEnable();
                return;
            }
            if ("startip".equals(name)) {
                String newValue;
                Long id = (Long)this.getModel().getValue(THIRD_IP_ID, rowIndex);
                if (id == 0L) {
                    id = DB.genLongId((String)TB_IPS);
                    this.getModel().setValue(THIRD_IP_ID, (Object)id, rowIndex);
                }
                String ipType = D.s((Object)this.getModel().getValue("iptype", rowIndex));
                if (IpTypeEnum.IPV6.getType().equals(ipType) && StringUtil.isNotEmpty((String)(newValue = e.getChangeSet()[0].getNewValue().toString()))) {
                    String[] ipv6Strings = newValue.split(":");
                    if (ipv6Strings.length != 8) {
                        return;
                    }
                    this.getModel().setValue("startip", (Object)IPWhiteListUtil.getFullIpv6((String)newValue), rowIndex);
                }
            } else if ("endip".equals(name)) {
                String newValue;
                String ipType = D.s((Object)this.getModel().getValue("iptype", rowIndex));
                if (IpTypeEnum.IPV6.getType().equals(ipType) && StringUtil.isNotEmpty((String)(newValue = e.getChangeSet()[0].getNewValue().toString()))) {
                    String[] ipv6Strings = newValue.split(":");
                    if (ipv6Strings.length != 8) {
                        return;
                    }
                    this.getModel().setValue("endip", (Object)IPWhiteListUtil.getFullIpv6((String)newValue), rowIndex);
                }
            }
        }
        catch (OpenApiException ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        try {
            if ("confirm_ext".equals(operate.getOperateKey())) {
                FormShowParameter billShowParameter = this.getView().getFormShowParameter();
                String strategyCode = (String)billShowParameter.getCustomParam("strategycode");
                ThirdAppEditDto thirdAppEditDto = StrategyUpdateRouteService.getStrategyUpdateService(strategyCode).confirm(this.getModel());
                thirdAppEditDto.setTitle(billShowParameter.getCaption());
                this.getView().returnDataToParent((Object)thirdAppEditDto);
                this.getView().close();
            }
        }
        catch (OpenApiException ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        this.getView().close();
    }
}

