/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.form.plugin.thirdapp.entity.ThirdAppEditDto;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateRouteService;
import kd.bos.openapi.form.util.CertUtil;
import kd.bos.openapi.form.util.ExportUtil;
import kd.bos.openapi.form.util.pdf.ExportAndDownloadUtil;
import kd.bos.orm.query.QFilter;

public class EncryptStrategyEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
ItemClickListener,
ClickListener {
    private static final Log log = LogFactory.getLog(EncryptStrategyEditPlugin.class);
    public static final String ENCRYPT_STRATEGY_EDIT = "encrypt_strategy_edit";
    private static final String BUTTON_NEXT = "btnok";
    private static final String BUTTON_CANCEL = "btncancel";
    private static final String BUTTON_ADD = "btnadd";
    private static final String BUTTON_DELETE = "btndelete";
    public static final String ENTRY_ENCRYPT_API_ID = "thirdencryptapiid";
    public static final String DOWNLOADCERT = "downloadcert";
    public static final String OP_DOWNLOADCERT = "downloadcert";
    public static final String OP_REBUILDCERT = "rebuild";
    public static final String REBUILD_CONFIRM = "rebuild_confirm";
    public static final String CERT_FILE_NAME = "cert_%s.txt";
    public static final String TB_ENCRYPTAPI = "t_open_3rdapps_encryptapi";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_CANCEL, BUTTON_NEXT});
        BasedataEdit control = (BasedataEdit)this.getControl("apiservice1");
        control.addBeforeF7SelectListener(o -> {
            ListShowParameter parameter = (ListShowParameter)o.getFormShowParameter();
            ArrayList apiIdList = new ArrayList(16);
            DynamicObjectCollection encryptCollections = this.getModel().getEntryEntity("enstrategyentity");
            encryptCollections.forEach(dynamicObject -> apiIdList.add(dynamicObject.getLong("apiservice1.id")));
            parameter.getListFilterParameter().setFilter(new QFilter("id", "not in", (Object)apiIdList.toArray()).and(new QFilter("enable", "=", (Object)"1")));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter billShowParameter = this.getView().getFormShowParameter();
        String strategyCode = (String)billShowParameter.getCustomParam("strategycode");
        this.getModel().setValue("strategycode", (Object)strategyCode);
        this.getModel().setValue("thirdAppModel", billShowParameter.getCustomParam("thirdAppModel"));
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"apiencryption"});
        StrategyUpdateRouteService.getStrategyUpdateService(strategyCode).loadData(this.getModel());
        this.updateEncryptEntry();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Long id;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if ("encryptallapi".equals(name)) {
            this.updateEncryptEntry();
        } else if ("apiservice1".equals(name) && (id = (Long)this.getModel().getValue(ENTRY_ENCRYPT_API_ID, rowIndex)) == 0L) {
            id = DB.genLongId((String)TB_ENCRYPTAPI);
            this.getModel().setValue(ENTRY_ENCRYPT_API_ID, (Object)id, rowIndex);
        }
    }

    private void updateEncryptEntry() {
        if (((Boolean)this.getModel().getValue("encryptallapi")).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"enstrategyentity"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BUTTON_ADD, BUTTON_DELETE});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"enstrategyentity"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BUTTON_ADD, BUTTON_DELETE});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        try {
            ThirdAppEditDto thirdAppEditDto;
            if ("confirm_ext".equals(operate.getOperateKey())) {
                FormShowParameter billShowParameter = this.getView().getFormShowParameter();
                String strategyCode = (String)billShowParameter.getCustomParam("strategycode");
                ThirdAppEditDto thirdAppEditDto2 = (ThirdAppEditDto)JSON.parseObject((String)((String)this.getModel().getValue("thirdAppModel")), ThirdAppEditDto.class);
                if (("31".equals(strategyCode) || "32".equals(strategyCode)) && (thirdAppEditDto2.getId() == null || thirdAppEditDto2.getId() == 0L)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"OpenApi3rdappsPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                thirdAppEditDto2 = StrategyUpdateRouteService.getStrategyUpdateService(strategyCode).confirm(this.getModel());
                thirdAppEditDto2.setTitle(billShowParameter.getCaption());
                this.getView().returnDataToParent((Object)thirdAppEditDto2);
                this.getView().close();
            } else if (OP_REBUILDCERT.equals(operate.getOperateKey()) && ((thirdAppEditDto = (ThirdAppEditDto)JSON.parseObject((String)((String)this.getModel().getValue("thirdAppModel")), ThirdAppEditDto.class)).getId() == null || thirdAppEditDto.getId() == 0L)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"OpenApi3rdappsPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        catch (OpenApiException ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("downloadcert".equals(operate.getOperateKey())) {
            ThirdAppEditDto thirdAppEditDto = (ThirdAppEditDto)JSON.parseObject((String)((String)this.getModel().getValue("thirdAppModel")), ThirdAppEditDto.class);
            if (thirdAppEditDto.getId() == null || thirdAppEditDto.getId() == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"OpenApi3rdappsPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                String bosOpenCert = CertUtil.createBosOpenCert(thirdAppEditDto.getId());
                if (StringUtils.isNotEmpty((CharSequence)bosOpenCert) && EncrypterFactory.getEncrypter().isEncrypted(bosOpenCert)) {
                    String decode = EncrypterFactory.getEncrypter().decode(bosOpenCert);
                    String fp = ExportUtil.createTxt(decode);
                    String fileName = String.format(CERT_FILE_NAME, System.currentTimeMillis());
                    ExportAndDownloadUtil.download(this.getView(), fp, fileName);
                }
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        } else if (OP_REBUILDCERT.equals(operate.getOperateKey())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u751f\u6210\u8bc1\u4e66\u540e\uff0c\u5c06\u5f71\u54cd\u6240\u6709\u52a0\u5bc6API\u7684\u8bf7\u6c42\u4e1a\u52a1\u5185\u5bb9\u548c\u54cd\u5e94\u5185\u5bb9\u7684\u52a0\u89e3\u5bc6\uff0cOPENAPI\u52a0\u89e3\u5bc6\u5747\u4f1a\u5373\u65f6\u4f7f\u7528\u66f4\u65b0\u7684\u8bc1\u4e66\u3002\u8bf7\u786e\u4fdd\u6240\u6709\u52a0\u5bc6\u63a5\u53e3\u91cd\u65b0\u8c03\u8bd5\u5e76\u80fd\u6b63\u5e38\u4f7f\u7528\u3002", (String)"OpenApi3rdappsPlugin_14", (String)"bos-open-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(REBUILD_CONFIRM));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        this.getView().close();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String eventId = event.getCallBackId();
        if (REBUILD_CONFIRM.equalsIgnoreCase(eventId) && event.getResult() == MessageBoxResult.Yes) {
            ThirdAppEditDto thirdAppEditDto = (ThirdAppEditDto)JSON.parseObject((String)((String)this.getModel().getValue("thirdAppModel")), ThirdAppEditDto.class);
            try {
                boolean newBosOpenCert = CertUtil.createNewBosOpenCert(thirdAppEditDto.getId());
                if (newBosOpenCert) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u8bc1\u4e66\u6210\u529f\u3002", (String)"OpenApi3rdappsPlugin_16", (String)"bos-open-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u8bc1\u4e66\u5931\u8d25\u3002", (String)"OpenApi3rdappsPlugin_17", (String)"bos-open-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u751f\u6210\u8bc1\u4e66\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%1$s\u3002", (String)"OpenApi3rdappsPlugin_15", (String)"bos-open-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
    }
}

