/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.ShaSignUtils;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.service.authorize.model.AuthTypeEnum;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang.RandomStringUtils;

public class OpenApiSignatureDebugPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(OpenApiSignatureDebugPlugin.class);
    public static final String SIGNATUREONCE = "signaturenonce";
    public static final String BAS_THIRDAPP = "thirdapp";
    public static final String AUTHTYPE = "authtype";
    public static final String TIMESTAMP = "timestamp";
    public static final String REQUESTPARAM = "requestparam";
    public static final String REQUESTPARAM_TAG = "requestparam_tag";
    public static final String COMBO_AUTHTYPE = "authtype";
    public static final String BTN_VERIFY_SIGNATURE = "verify_signature";
    public static final String BTN_GENERATE_SIGNATURE = "generate_signature";
    public static final String BTN_RESET = "reset";
    public static final String SIGNATURE = "signature";
    private static final String ENTITYNUMBER_LARGETEXTEDIT = "ide_largertextedit";
    private static final String TEXTFIELD = "textfield";

    public void registerListener(EventObject e) {
        TextEdit signaturenonce = (TextEdit)this.getView().getControl(SIGNATUREONCE);
        signaturenonce.addClickListener((ClickListener)this);
        TextEdit textEdit = (TextEdit)this.getView().getControl(TEXTFIELD);
        textEdit.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(SIGNATUREONCE, (Object)RandomStringUtils.randomAlphanumeric((int)20));
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (SIGNATUREONCE.equals(key)) {
            TextEdit textEdit = (TextEdit)evt.getSource();
            if (SIGNATUREONCE.equals(textEdit.getKey())) {
                this.getModel().setValue(SIGNATUREONCE, (Object)RandomStringUtils.randomAlphanumeric((int)20));
            }
        } else if (TEXTFIELD.equals(key)) {
            this.showLargerTextForm();
        }
    }

    private void showLargerTextForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(ENTITYNUMBER_LARGETEXTEDIT);
        showParameter.setCustomParam("fieldKey", (Object)REQUESTPARAM);
        showParameter.setCustomParam("largeTextValue", this.getModel().getValue(REQUESTPARAM_TAG));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570", (String)"OpenApiSignatureDebugPlugin_4", (String)"bos-open-formplugin", (Object[])new Object[0]));
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, REQUESTPARAM);
        showParameter.setCloseCallBack(callBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (REQUESTPARAM.equals(e.getActionId())) {
            if (e.getReturnData() == null) {
                return;
            }
            this.getModel().setValue(REQUESTPARAM_TAG, returnData);
            this.getModel().setValue(TEXTFIELD, (Object)(StringUtil.isEmpty((String)String.valueOf(returnData)) ? "" : StringUtil.substring((Object)returnData, (int)255).replaceAll("\\s", "").trim()));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (BAS_THIRDAPP.equals(key)) {
            DynamicObject thirdappDy;
            DynamicObject thirdapp;
            ComboEdit authtypeCombo = (ComboEdit)this.getControl("authtype");
            Object object = this.getModel().getValue(BAS_THIRDAPP);
            if (object != null && (thirdapp = BusinessDataServiceHelper.loadSingle((Object)(thirdappDy = (DynamicObject)object).getPkValue(), (String)"third_app", (String)"is_digest")) != null) {
                boolean isDigest = thirdapp.getBoolean("is_digest");
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
                if (isDigest) {
                    comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6458\u8981\u8ba4\u8bc1", (String)"OpenApiSignatureDebugPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0])), AuthTypeEnum.AUTH_DIGEST.getId()));
                }
                authtypeCombo.setComboItems(comboItems);
                this.getModel().setValue("authtype", (Object)((ComboItem)comboItems.get(0)).getValue());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (BTN_VERIFY_SIGNATURE.equals(operateKey)) {
            CodeEdit signature = (CodeEdit)this.getControl(SIGNATURE);
            if (StringUtil.isEmpty((String)signature.getText())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b7e\u540d\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5165\u7b7e\u540d\u518d\u505a\u6821\u9a8c\u3002", (String)"OpenApiSignatureDebugPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (BTN_RESET.equals(operateKey)) {
            CodeEdit signCodeEdit = (CodeEdit)this.getControl(SIGNATURE);
            signCodeEdit.setText("");
            CodeEdit querystringEdit = (CodeEdit)this.getControl("querystring");
            querystringEdit.setText("");
            CodeEdit headerEdit = (CodeEdit)this.getControl("header");
            headerEdit.setText("");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        DynamicObject object = (DynamicObject)this.getModel().getValue(BAS_THIRDAPP);
        if (object == null) {
            return;
        }
        DynamicObject thirdapp = BusinessDataServiceHelper.loadSingle((Object)object.getPkValue(), (String)"third_app", (String)"publickey,signature_key,agencyuser,apiencryption,signature_key,signsecretkeydb");
        String authtype = this.getModel().getValue("authtype").toString();
        String signatureNonce = this.getModel().getValue(SIGNATUREONCE).toString();
        String requestparam = this.getModel().getValue(REQUESTPARAM_TAG).toString().replace("\n", "\r\n");
        String timestamp = DateUtil.convertToStr((String)"yyyy-MM-dd HH:mm:ss", (Date)((Date)this.getModel().getValue(TIMESTAMP)));
        if (BTN_VERIFY_SIGNATURE.equals(operateKey)) {
            if (this.verifySignature(authtype, thirdapp, signatureNonce, requestparam, timestamp)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7b7e\u540d\u9a8c\u8bc1\u901a\u8fc7\u3002", (String)"OpenApiSignatureDebugPlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b7e\u540d\u9a8c\u8bc1\u4e0d\u901a\u8fc7\u3002", (String)"OpenApiSignatureDebugPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
            }
        } else if (BTN_GENERATE_SIGNATURE.equals(operateKey)) {
            String signature = "";
            if (AuthTypeEnum.AUTH_DIGEST.getId().equals(authtype)) {
                signature = this.generateDigestSignature(thirdapp, signatureNonce, requestparam, timestamp);
            }
            CodeEdit signCodeEdit = (CodeEdit)this.getControl(SIGNATURE);
            signCodeEdit.setText(signature);
        }
    }

    private boolean verifySignature(String authtype, DynamicObject thirdapp, String signatureNonce, String requestparam, String timestamp) {
        if (AuthTypeEnum.AUTH_DIGEST.getId().equals(authtype)) {
            return this.verifyDigestSignature(thirdapp, signatureNonce, requestparam, timestamp);
        }
        return false;
    }

    private boolean verifyDigestSignature(DynamicObject thirdapp, String signatureNonce, String requestparam, String timestamp) {
        String signature = this.generateDigestSignature(thirdapp, signatureNonce, requestparam, timestamp);
        CodeEdit signCodeEdit = (CodeEdit)this.getControl(SIGNATURE);
        String curSign = signCodeEdit.getText();
        return curSign.equals(signature);
    }

    private String generateDigestSignature(DynamicObject thirdapp, String signatureNonce, String requestparam, String timestamp) {
        try {
            String publickey = EncryptUtil.decode((String)thirdapp.getString("publickey"));
            String signatureString = this.getSignatureString(requestparam, timestamp, signatureNonce).toString();
            return ShaSignUtils.HMACSHA256StrByKey((String)signatureString, (String)publickey);
        }
        catch (Exception e) {
            this.getView().showErrorNotification("generateSignature error " + e.getMessage());
            return "";
        }
    }

    private StringBuilder getSignatureString(String requestparam, String timestamp, String signatureNonce) {
        StringBuilder sb = new StringBuilder();
        sb.append(requestparam);
        sb.append(timestamp);
        sb.append(signatureNonce);
        return sb;
    }
}

