/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isc.util.dt.D;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.form.plugin.thirdapp.entity.StrategyTypeCodeEnum;
import kd.bos.openapi.form.plugin.thirdapp.entity.StrategyTypeEnum;
import kd.bos.openapi.form.plugin.thirdapp.entity.ThirdAppEditDto;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateRouteService;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyValidateChain;
import kd.bos.openapi.form.util.FormOpener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ThirdAppPlugin
extends AbstractBasePlugIn
implements RowClickEventListener {
    private static final Log log = LogFactory.getLog(ThirdAppPlugin.class);
    public static final String KEY_SYSAUTH = "syspwd";
    public static final String KEY_PUBLICKEY = "publickey";
    private static final String KEY_HISSYSPD = "hisSyspwd";
    public static final String KEY_SHOWSECRETKEY = "showsecretkey";
    public static final String KEY_BASEIC_STATUS = "basicstatus";
    public static final String SECURITYPUBLICKEY = "securitypublickey";
    public static final String KEY_JWT_TYPE = "jwt_type";
    public static final String BASESIGNCODEKEY = "basesigncode";
    public static final String JWTASYMMETIC = "jwtasymmetic";
    public static final String SIGNATURE_KEY = "signature_key";
    private static final String BTN_SAVE = "save";
    public static final String PWGFORMAT = "******";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_ENTRYENTITY_APISERVICE = "apiservice";
    private static final String LAST_ENABLE_TIME = "lastenabletime";
    private static final String LAST_STOP_TIME = "laststoptime";
    public static final String AGENTUSERID = "agentuserid";
    public static final String AGENTUSER_ENTIRY = "entryentity_basicauth";
    public static final String AGENTUSER_SECRETKEY = "basesigncode";
    public static final String AGENTUSER_SECRETKEY_DISP = "secretkeydisp";
    public static final String SYSTAG = "systag";
    public static final String KEY_ISBASICAUTH = "isbasicauth";
    public static final String KEY_ALLOWALLAPI = "allowallapi";
    public static final String KEY_AGENTUSERID = "agentuserid";
    public static final String KEY_ENABLE = "enable";
    private static final String BTN_DISENABLE = "disable";
    private static final String BTN_ENABLE = "enable";
    public static final String IS_SIGNATURE = "is_signature";
    public static final String KEY_SIGN_TYPE = "sign_type";
    public static final String DOWNLOADCERT = "downloadcert";
    private static final String FLEX_ADD_STRATEGY = "flexaddstrategy";
    private static final String CALLBACK_ADD_STRATEGY = "callback_addstrategy";
    public static final String THIRD_ID = "thirdId";
    public static final String THIRD_APP_MODEL = "thirdAppModel";
    public static final String ENTITY_THIRD_APP = "third_app";
    public static final String ENTITY_SUB_STRATEGY = "strategy";
    public static final String CARD_FX_STRATEGY_DESC = "cardfxstrategydesc";
    public static final String STRATEGY_EDIT_CALLBACK = "strategy_edit_callback";
    public static final String MODIFY_STRATEGY = "vtmodify";
    public static final String DELETE_STRATEGY = "vtdelete";
    public static final String DEFAULT_STRATEGY_TAG = "isdefault";
    public static final String ENTITY_SUB_ENCRYPT = "enstrategyentity";
    public static final String ENCRYPT_APIID = "apiservice1";
    public static final String ENTITY_SUB_IPLIST = "entryentity_ip";
    public static final String ALLOW_IP = "allowip";
    public static final String IS_AGENCY_USER = "isagencyuser";
    public static final String AGENCY_USER = "agencyuser";
    public static final String SELECTED_STRATEGY = "selectedStrategy";
    public static final String IS_SHOW_DOWNLOAD_CERT = "isShowDownloadCert";
    public static final String CONFIRM_EXT = "confirm_ext";
    public static final String ACCESS_TOKEN_OLD = "accesstoken_old";
    public static final String KEY_ENCRYPT_ALL_API = "encryptallapi";
    public static final String KEY_ENCRYPTION = "apiencryption";
    public static final String IP_LIST_START = "startip";
    public static final String IP_LIST_END = "endip";
    public static final String POLICY_TYPE = "policytype";
    public static final String IP_TYPE = "iptype";
    public static final String ENABLE_IS_DIGEST = "is_digest";
    public static final String KEY_NUMBER = "number";
    public static final String KEY_BASIC_TYPE = "type";
    public static final String ENTITY_SSOIP = "entity_ssoip";
    public static final String DOMAIN_IP = "domain_ip";
    public static final String KEY_AUTH_PLUGIN_ENABLE = "authpluginenable";
    public static final String KEY_IS_ENHANCE_TOKEN = "isenhancetoken";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Container addStrategy = (Container)this.getView().getControl(FLEX_ADD_STRATEGY);
        addStrategy.addClickListener((ClickListener)this);
        BasedataEdit control = (BasedataEdit)this.getControl(KEY_ENTRYENTITY_APISERVICE);
        control.addBeforeF7SelectListener(o -> {
            ListShowParameter parameter = (ListShowParameter)o.getFormShowParameter();
            DynamicObjectCollection entryentity = this.getView().getModel().getEntryEntity(KEY_ENTRYENTITY);
            ArrayList<Object> pks = new ArrayList<Object>(16);
            for (DynamicObject object : entryentity) {
                Object apiservice = object.get(KEY_ENTRYENTITY_APISERVICE);
                if (apiservice == null) continue;
                pks.add(((DynamicObject)apiservice).getPkValue());
            }
            parameter.getListFilterParameter().setFilter(new QFilter("id", "not in", (Object)pks.toArray()).and(new QFilter("enable", "!=", (Object)"0")));
        });
        this.addItemClickListeners(new String[]{"tbmain"});
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTITY_SUB_STRATEGY);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        Container strategyDesc = (Container)this.getView().getControl(CARD_FX_STRATEGY_DESC);
        strategyDesc.addClickListener((ClickListener)this);
        Vector vtModify = (Vector)this.getView().getControl(MODIFY_STRATEGY);
        vtModify.addClickListener((ClickListener)this);
        Vector vtDelete = (Vector)this.getView().getControl(DELETE_STRATEGY);
        vtDelete.addClickListener((ClickListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (StringUtils.equals((CharSequence)"bar_save", (CharSequence)evt.getItemKey()) && this.isSave() && this.getModel().getValue("enable").equals("1")) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u7b2c\u4e09\u65b9\u5e94\u7528\u4fe1\u606f\u53ef\u80fd\u5f71\u54cd\u5916\u90e8\u7cfb\u7edf\u8c03\u7528\u63a5\u53e3\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4fee\u6539\uff1f", (String)"OpenApi3rdappsPlugin_23", (String)"bos-open-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("saveThirdApp"));
            evt.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObjectCollection strategyList = this.getModel().getEntryEntity(ENTITY_SUB_STRATEGY);
        if (strategyList.isEmpty()) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTITY_SUB_STRATEGY);
            DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
            dynamicObject.set("strategytypeid_id", (Object)StrategyTypeCodeEnum.ACCESS_TOKEN.getId());
            dynamicObject.set("seq", (Object)1);
            DynamicObject strategyType = BusinessDataServiceHelper.loadSingle((Object)StrategyTypeCodeEnum.ACCESS_TOKEN.getId(), (String)"access_strategy_type");
            dynamicObject.set("strategytypeid", (Object)strategyType);
            entryEntity.add((Object)dynamicObject);
            this.getModel().updateEntryCache(entryEntity);
        }
        this.getModel().setValue(KEY_IS_ENHANCE_TOKEN, (Object)true);
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection agencyuser = new DynamicObjectCollection();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_user");
        DynamicObject tempUser = BusinessDataServiceHelper.loadSingle((Object)currUserId, (DynamicObjectType)type);
        agencyuser.add((Object)tempUser);
        this.getModel().setValue(AGENCY_USER, (Object)agencyuser);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.isAllowEdit();
    }

    private void isAllowEdit() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"bar_save", "conentpanel", ENTITY_SUB_STRATEGY, "advstrategy", "cardentrystrategymain", FLEX_ADD_STRATEGY});
        this.getView().setVisible(Boolean.TRUE, new String[]{"cardaddstrategy"});
        Long thirdId = D.l((Object)this.getModel().getValue("id"));
        if (thirdId == 0L) {
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_NUMBER});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_NUMBER});
        }
        if (((Boolean)this.getModel().getValue("is_preset")).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_ALLOWALLAPI, "addrow", "deleterow", KEY_ENTRYENTITY});
        }
        this.getModel().updateCache();
        this.getView().updateView();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long thirdId = D.l((Object)this.getModel().getValue("id"));
        if (thirdId == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_getaccesstoken"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_getaccesstoken"});
        }
        this.updateAgenceUserVisiable();
        DynamicObjectCollection strategyCollections = this.getModel().getEntryEntity(ENTITY_SUB_STRATEGY);
        if (strategyCollections.isEmpty()) {
            Boolean isSignAuthEnable;
            Boolean isBasicAuthEnable;
            this.addStrategy(strategyCollections, StrategyTypeCodeEnum.ACCESS_TOKEN);
            Boolean isDigestAuthEnable = D.x((Object)this.getModel().getValue(ENABLE_IS_DIGEST));
            if (isDigestAuthEnable.booleanValue()) {
                this.addStrategy(strategyCollections, StrategyTypeCodeEnum.DIGEST_AUTH);
            }
            if ((isBasicAuthEnable = Boolean.valueOf(D.x((Object)this.getModel().getValue(KEY_ISBASICAUTH)))).booleanValue()) {
                this.addStrategy(strategyCollections, StrategyTypeCodeEnum.BASIC_AUTH);
            }
            if ((isSignAuthEnable = Boolean.valueOf(D.x((Object)this.getModel().getValue(IS_SIGNATURE)))).booleanValue()) {
                this.addStrategy(strategyCollections, StrategyTypeCodeEnum.SIGN_AUTH);
                Long encryption = D.l((Object)this.getModel().getValue(KEY_ENCRYPTION));
                if (1L == encryption) {
                    this.addStrategy(strategyCollections, StrategyTypeCodeEnum.ENCRYPT_AES);
                } else if (2L == encryption) {
                    this.addStrategy(strategyCollections, StrategyTypeCodeEnum.ENCRYPT_SM4);
                }
            }
            Boolean isAllowAllIp = D.x((Object)this.getModel().getValue(ALLOW_IP));
            DynamicObjectCollection dyc = this.getModel().getEntryEntity(ENTITY_SUB_IPLIST);
            if (isAllowAllIp.booleanValue() || !dyc.isEmpty()) {
                this.addStrategy(strategyCollections, StrategyTypeCodeEnum.IP_POLICY);
            }
            this.getModel().updateEntryCache(strategyCollections);
            this.getView().updateView();
        }
        this.updateDefault();
    }

    private void updateDefault() {
        DynamicObjectCollection strategyCollections = this.getModel().getEntryEntity(ENTITY_SUB_STRATEGY);
        CardEntry entry = (CardEntry)this.getView().getControl(ENTITY_SUB_STRATEGY);
        int total = strategyCollections.size();
        for (int i = 0; i < total; ++i) {
            Long strategyTypeId = ((DynamicObject)strategyCollections.get(i)).getLong("strategytypeid.id");
            if (StrategyTypeCodeEnum.ACCESS_TOKEN.getId().equals(strategyTypeId)) {
                entry.setChildVisible(true, i, new String[]{DEFAULT_STRATEGY_TAG});
                entry.setChildEnable(false, i, new String[]{DELETE_STRATEGY});
                continue;
            }
            entry.setChildVisible(false, i, new String[]{DEFAULT_STRATEGY_TAG});
            entry.setChildEnable(true, i, new String[]{DELETE_STRATEGY});
        }
    }

    private void addStrategy(DynamicObjectCollection strategyCollections, StrategyTypeCodeEnum strategyTypeCodeEnum) {
        DynamicObjectType dynamicObjectType = strategyCollections.getDynamicObjectType();
        DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
        dynamicObject.set("strategytypeid", (Object)BusinessDataServiceHelper.loadSingle((Object)strategyTypeCodeEnum.getId(), (String)"access_strategy_type"));
        strategyCollections.add((Object)dynamicObject);
        if ("1".equalsIgnoreCase(strategyTypeCodeEnum.getType())) {
            this.getModel().setValue(ACCESS_TOKEN_OLD, this.getModel().getValue(KEY_SYSAUTH));
        }
    }

    public void afterCopyData(EventObject e) {
        this.getModel().setValue(KEY_SYSAUTH, (Object)"");
        this.getModel().setValue(KEY_PUBLICKEY, (Object)"");
        this.getModel().setValue(SECURITYPUBLICKEY, (Object)"");
        this.getModel().setValue(SIGNATURE_KEY, (Object)"");
        this.getModel().setValue(IS_SIGNATURE, (Object)"0");
        this.getModel().setValue(KEY_ISBASICAUTH, (Object)"0");
        this.getModel().setValue(ENABLE_IS_DIGEST, (Object)"0");
        this.getModel().setValue(JWTASYMMETIC, (Object)"0");
        this.getModel().setValue(KEY_AUTH_PLUGIN_ENABLE, (Object)"0");
        this.getModel().deleteEntryData(AGENTUSER_ENTIRY);
        DynamicObjectCollection strategyList = this.getModel().getEntryEntity(ENTITY_SUB_STRATEGY);
        if (!strategyList.isEmpty()) {
            List signAuthStrategy = strategyList.stream().filter(dy -> {
                Long strategryId = dy.getLong("strategytypeid.id");
                return StrategyTypeCodeEnum.DIGEST_AUTH.getId().equals(strategryId) || StrategyTypeCodeEnum.API_AUTH_EXT.getId().equals(strategryId) || StrategyTypeCodeEnum.BASIC_AUTH.getId().equals(strategryId) || StrategyTypeCodeEnum.SIGN_AUTH.getId().equals(strategryId) || StrategyTypeCodeEnum.ENCRYPT_SM4.getId().equals(strategryId) || StrategyTypeCodeEnum.ENCRYPT_AES.getId().equals(strategryId);
            }).map(dynamicObject -> dynamicObject.getInt("seq") - 1).collect(Collectors.toList());
            this.getModel().deleteEntryRows(ENTITY_SUB_STRATEGY, signAuthStrategy.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        try {
            if (evt.getSource() instanceof Container) {
                Container opStrategy = (Container)evt.getSource();
                if (FLEX_ADD_STRATEGY.equalsIgnoreCase(opStrategy.getKey())) {
                    this.showStrategyAddPage();
                } else if (CARD_FX_STRATEGY_DESC.equalsIgnoreCase(opStrategy.getKey())) {
                    this.showStrategyEditPage();
                }
            } else if (evt.getSource() instanceof Vector) {
                Vector vector = (Vector)evt.getSource();
                if (MODIFY_STRATEGY.equalsIgnoreCase(vector.getKey())) {
                    this.showStrategyEditPage();
                } else if (DELETE_STRATEGY.equalsIgnoreCase(vector.getKey())) {
                    this.deleteStrategyEditPage();
                }
            }
        }
        catch (OpenApiException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private void showStrategyAddPage() {
        Long thirdId = (Long)this.getModel().getValue("id");
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        if (thirdId != null && thirdId != 0L) {
            params.put(THIRD_ID, thirdId);
        }
        DynamicObjectCollection strategies = this.getModel().getEntryEntity(ENTITY_SUB_STRATEGY);
        HashMap exitsMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)strategies)) {
            strategies.forEach(data -> exitsMap.put(data.getString("strategytypeid.number"), Boolean.TRUE));
        }
        params.put(SELECTED_STRATEGY, exitsMap);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParams(params);
        showParameter.setFormId("select_strategy");
        showParameter.setCaption(ResManager.loadKDString((String)"\u6dfb\u52a0\u7b56\u7565", (String)"ThirdAppPlugin_0", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_ADD_STRATEGY);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showStrategyEditPage() {
        Long thirdId = (Long)this.getModel().getValue("id");
        String type = this.getView().getPageCache().get("strategytypetype");
        String page = "access_strategy";
        if (StrategyTypeEnum.AUTH.getType().equals(type)) {
            page = "access_strategy";
        } else if (StrategyTypeEnum.ENCRYPT.getType().equals(type)) {
            page = "encrypt_strategy_edit";
        } else if (StrategyTypeEnum.ACCESSCONTROL.getType().equals(type)) {
            page = "acesscl_strategy_edit";
        }
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        String strategyCode = this.getView().getPageCache().get("strategycode");
        param.put("strategycode", strategyCode);
        param.put(THIRD_ID, thirdId);
        ThirdAppEditDto thirdAppDto = new ThirdAppEditDto();
        thirdAppDto.setId(thirdId);
        thirdAppDto.setShowDownloadCert("1".equals(this.getPageCache().get(IS_SHOW_DOWNLOAD_CERT)));
        thirdAppDto.setStrategyType(type);
        thirdAppDto.setStrategyCode(strategyCode);
        thirdAppDto.setStrategyId(Long.valueOf(this.getView().getPageCache().get("strategytypeid")));
        thirdAppDto.setIsNew("0");
        StrategyUpdateRouteService.getStrategyUpdateService(strategyCode).init(this.getModel(), thirdAppDto);
        param.put(THIRD_APP_MODEL, JSON.toJSONString((Object)thirdAppDto));
        param.put("strategytypeid", Long.valueOf(this.getView().getPageCache().get("strategytypeid")));
        param.put("isnew", "0");
        FormShowParameter p = FormOpener.getFormShowParameter((AbstractFormPlugin)this, page, this.getView().getPageCache().get("strategyname"), param, STRATEGY_EDIT_CALLBACK);
        p.getOpenStyle().setShowType(ShowType.Modal);
        if ("1".equals(strategyCode) || "4".equals(strategyCode) || "5".equals(strategyCode)) {
            StyleCss css = new StyleCss();
            css.setWidth("554");
            css.setHeight("332");
            p.getOpenStyle().setInlineStyleCss(css);
        }
        this.getView().showForm(p);
    }

    private void deleteStrategyEditPage() {
        String strategyCode = this.getView().getPageCache().get("strategycode");
        StrategyUpdateRouteService.getStrategyUpdateService(strategyCode).delete(this.getModel(), this.getView().getPageCache().get("strategytypeid"));
        this.updateDefault();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        DynamicObjectCollection encryptCollection;
        super.closedCallBack(evt);
        String action = evt.getActionId();
        ThirdAppEditDto returnData = (ThirdAppEditDto)evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("5".equals(returnData.getStrategyCode()) && (encryptCollection = this.getModel().getEntryEntity(ENTITY_SUB_ENCRYPT)).isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7b7e\u540d\u8ba4\u8bc1\u5df2\u589e\u52a0\uff0c\u8bf7\u914d\u7f6e\u52a0\u5bc6\u7b56\u7565\u3002", (String)"ThirdAppPlugin_7", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
        if ("4".equals(returnData.getStrategyCode())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7531\u4e8e\u57fa\u672c\u8ba4\u8bc1\u5b89\u5168\u6027\u8f83\u4f4e\uff0c\u8bf7\u8c28\u614e\u4fdd\u7ba1\u57fa\u672c\u8ba4\u8bc1\u5bc6\u94a5\uff0c\u5e76\u81ea\u884c\u627f\u62c5\u8be5\u8ba4\u8bc1\u65b9\u5f0f\u53ef\u80fd\u5bfc\u81f4\u7684\u6570\u636e\u6cc4\u9732\u98ce\u9669\uff01", (String)"OpenApi3rdappsPlugin_27", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
        StrategyUpdateRouteService.getStrategyUpdateService(returnData.getStrategyCode()).updateModel(this.getModel(), returnData);
        this.getModel().updateCache();
        this.getView().updateView();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        try {
            if ("bar_getaccesstoken".equals(evt.getItemKey())) {
                Boolean isEnhanceToken = D.x((Object)this.getModel().getValue(KEY_IS_ENHANCE_TOKEN));
                Long thirdAppId = D.l((Object)this.getModel().getValue("id"));
                if (thirdAppId == null || thirdAppId == 0L) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"OpenApi3rdappsPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
                }
                String thirdAppNum = D.s((Object)this.getModel().getValue(KEY_NUMBER));
                HashMap<String, Object> params = new HashMap<String, Object>(5);
                params.put("isEnhanceToken", isEnhanceToken);
                params.put("client_id", thirdAppNum);
                String agentUserId = RequestContext.get().getCurrUserId() + "";
                if (this.getModel().getValue(AGENCY_USER) != null && ((MulBasedataDynamicObjectCollection)this.getModel().getValue(AGENCY_USER)).size() > 0) {
                    MulBasedataDynamicObjectCollection agencyUsers = (MulBasedataDynamicObjectCollection)this.getModel().getValue(AGENCY_USER);
                    agentUserId = ((DynamicObject)agencyUsers.get(0)).getLong("fbasedataid_id") + "";
                }
                params.put("userId", agentUserId);
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("getaccesstoken");
                formShowParameter.setCustomParams(params);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                if (isEnhanceToken.booleanValue()) {
                    StyleCss css = new StyleCss();
                    css.setWidth("600");
                    css.setHeight("445");
                    formShowParameter.getOpenStyle().setInlineStyleCss(css);
                }
                this.getView().showForm(formShowParameter);
            }
        }
        catch (OpenApiException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowDoubleClick(evt);
        CardEntry cardEntry = (CardEntry)evt.getSource();
        if (StringUtils.equals((CharSequence)ENTITY_SUB_STRATEGY, (CharSequence)cardEntry.getKey())) {
            int[] selectRows = cardEntry.getSelectRows();
            DynamicObject selectStrategyType = cardEntry.getEntryData().getDataEntitys()[selectRows[0]];
            this.getView().getPageCache().put("strategycode", (String)selectStrategyType.get("strategytypeid.number"));
            this.getView().getPageCache().put("strategytypeid", ((Long)selectStrategyType.get("strategytypeid.id")).toString());
            this.getView().getPageCache().put("strategytypetype", (String)selectStrategyType.get("strategytypeid.type"));
            this.getView().getPageCache().put("strategyname", (String)selectStrategyType.get("strategytypeid.name." + Lang.get().name()));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        try {
            if (BTN_SAVE.equals(operate.getOperateKey())) {
                Date enableTime = (Date)this.getModel().getValue(LAST_ENABLE_TIME);
                Date stopTime = (Date)this.getModel().getValue(LAST_STOP_TIME);
                if (enableTime != null && stopTime != null && enableTime.after(stopTime)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u6700\u540e\u542f\u7528\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7cfb\u7edf\u6700\u540e\u505c\u6b62\u65f6\u95f4\u3002", (String)"OpenApi3rdappsPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getModel().setValue("issave", (Object)"1");
                StrategyValidateChain.getInstance().validate(this.getModel());
            }
        }
        catch (KDBizException | OpenApiException e) {
            args.setCancel(true);
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (AGENCY_USER.equals(name)) {
            this.updateBasicAuthStatus(e);
        } else if (IS_AGENCY_USER.equals(name)) {
            this.updateBasicAuthStatus(e);
            this.updateAgenceUserVisiable();
        }
    }

    private void updateAgenceUserVisiable() {
        Boolean checkAgency = (Boolean)this.getModel().getValue(IS_AGENCY_USER);
        if (checkAgency.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{AGENCY_USER});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{AGENCY_USER});
        }
    }

    private void updateBasicAuthStatus(PropertyChangedArgs e) {
        Boolean checkAgency = (Boolean)this.getModel().getValue(IS_AGENCY_USER);
        AtomicBoolean isChange = new AtomicBoolean(false);
        if (checkAgency.booleanValue()) {
            MulBasedataDynamicObjectCollection dyc = (MulBasedataDynamicObjectCollection)this.getModel().getValue(AGENCY_USER);
            HashMap agencyUserMap = new HashMap();
            if (dyc != null) {
                dyc.forEach(dynamicObject -> agencyUserMap.put(dynamicObject.getLong("fbasedataid.id"), 1));
            }
            DynamicObjectCollection dyEntry = this.getModel().getEntryEntity(AGENTUSER_ENTIRY);
            dyEntry.forEach(dynamicObject -> {
                Integer result = (Integer)agencyUserMap.get(dynamicObject.getLong("agentuserid.id"));
                Boolean oldStatus = D.x((Object)dynamicObject.getString(KEY_BASEIC_STATUS));
                if (result == null || result != 1) {
                    dynamicObject.set(KEY_BASEIC_STATUS, (Object)"0");
                    if (oldStatus.booleanValue()) {
                        isChange.set(true);
                    }
                } else {
                    dynamicObject.set(KEY_BASEIC_STATUS, (Object)"1");
                    if (!oldStatus.booleanValue()) {
                        isChange.set(true);
                    }
                }
            });
        }
        if (isChange.get()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u672c\u8ba4\u8bc1\u7684\u4ee3\u7406\u7528\u6237\u72b6\u6001\u6709\u53d8\u5316\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ThirdAppPlugin_6", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("enable".equals(operate.getOperateKey()) || BTN_DISENABLE.equals(operate.getOperateKey())) {
            if (args.getOperationResult().isSuccess()) {
                this.isAllowEdit();
            }
        } else if (BTN_SAVE.equals(operate.getOperateKey())) {
            this.getPageCache().put(KEY_HISSYSPD, this.getModel().getValue(KEY_SYSAUTH).toString());
            if (args.getOperationResult().isSuccess()) {
                this.isAllowEdit();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (event.getCallBackId().equals("saveThirdApp") && event.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation(BTN_SAVE, OperateOption.create());
        }
    }

    private boolean isSave() {
        String resourceThirdId = ((Long)this.getModel().getValue("id")).toString();
        return !"0".equals(resourceThirdId) && resourceThirdId != null;
    }
}

