/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.form.plugin.thirdapp.entity.StrategyTypeCodeEnum;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateService;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyValidateService;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.AbstractStrategyUpdateService;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.AccessTokenUpdateServiceImpl;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.ApiAuthExtUpdateServiceImpl;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.BasicAuthUpdateServiceImpl;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.DigestAuthUpdateServiceImpl;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.EncryptUpdateServiceImpl;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.IpListUpdateServiceImpl;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.SignAuthUpdateServiceImpl;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.SsoIPServiceImpl;

public class StrategyUpdateRouteService {
    private static final Map<StrategyTypeCodeEnum, StrategyUpdateService> strategyUpdateServiceMap = new ConcurrentHashMap<StrategyTypeCodeEnum, StrategyUpdateService>();

    public static StrategyUpdateService getStrategyUpdateService(String typeCode) {
        return StrategyUpdateRouteService.getStrategyUpdateService(StrategyTypeCodeEnum.getByType((String)typeCode));
    }

    private static StrategyUpdateService getStrategyUpdateService(StrategyTypeCodeEnum type) {
        if (strategyUpdateServiceMap.get(type) == null) {
            throw new OpenApiException(ApiErrorCode.Data_NotFound, String.format("cann't find any strategyUpdateService for %s, please check it.", type), new Object[0]);
        }
        return strategyUpdateServiceMap.get(type);
    }

    public static StrategyValidateService getValidatorByStrategyCode(String strategyCode) {
        AbstractStrategyUpdateService validateService = null;
        switch (strategyCode) {
            case "1": {
                validateService = new AccessTokenUpdateServiceImpl();
                break;
            }
            case "2": {
                validateService = new DigestAuthUpdateServiceImpl();
                break;
            }
            case "3": {
                break;
            }
            case "4": {
                validateService = new BasicAuthUpdateServiceImpl();
                break;
            }
            case "5": {
                validateService = new SignAuthUpdateServiceImpl();
                break;
            }
            case "6": {
                validateService = new ApiAuthExtUpdateServiceImpl();
                break;
            }
            case "31": 
            case "32": {
                validateService = new EncryptUpdateServiceImpl();
                break;
            }
            case "11": {
                validateService = new IpListUpdateServiceImpl();
                break;
            }
            case "12": {
                validateService = new SsoIPServiceImpl();
                break;
            }
            default: {
                throw new OpenApiException(ApiErrorCode.Data_NotFound, String.format("cann't find any strategyUpdateService for %s, please check it.", strategyCode), new Object[0]);
            }
        }
        return validateService;
    }

    static {
        strategyUpdateServiceMap.put(StrategyTypeCodeEnum.ACCESS_TOKEN, new AccessTokenUpdateServiceImpl());
        strategyUpdateServiceMap.put(StrategyTypeCodeEnum.DIGEST_AUTH, new DigestAuthUpdateServiceImpl());
        strategyUpdateServiceMap.put(StrategyTypeCodeEnum.BASIC_AUTH, new BasicAuthUpdateServiceImpl());
        strategyUpdateServiceMap.put(StrategyTypeCodeEnum.SIGN_AUTH, new SignAuthUpdateServiceImpl());
        strategyUpdateServiceMap.put(StrategyTypeCodeEnum.API_AUTH_EXT, new ApiAuthExtUpdateServiceImpl());
        strategyUpdateServiceMap.put(StrategyTypeCodeEnum.ENCRYPT_AES, new EncryptUpdateServiceImpl());
        strategyUpdateServiceMap.put(StrategyTypeCodeEnum.ENCRYPT_SM4, new EncryptUpdateServiceImpl());
        strategyUpdateServiceMap.put(StrategyTypeCodeEnum.IP_POLICY, new IpListUpdateServiceImpl());
        strategyUpdateServiceMap.put(StrategyTypeCodeEnum.SSOIP_POLICY, new SsoIPServiceImpl());
    }
}

