/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp.service.impl;

import com.alibaba.fastjson.JSON;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.thirdapp.entity.ThirdAppEditDto;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateService;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyValidateService;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.AbstractStrategyUpdateService;

public class DigestAuthUpdateServiceImpl
extends AbstractStrategyUpdateService
implements StrategyUpdateService,
StrategyValidateService {
    @Override
    public void init(IDataModel model, ThirdAppEditDto thirdAppEditDto) {
        if (model == null) {
            DynamicObject thirdApp = this.loadThirdApp(thirdAppEditDto.getId());
            if (thirdApp != null) {
                thirdAppEditDto.setDigestSignKey(thirdApp.getString("publickey"));
            }
        } else {
            thirdAppEditDto.setDigestSignKey((String)model.getValue("publickey"));
        }
        thirdAppEditDto.setDigestAuthEnable(true);
        thirdAppEditDto.setDigestSignType(1L);
    }

    @Override
    public void loadData(IDataModel model) {
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        model.setValue("publickey", (Object)thirdAppEditDto.getDigestSignKey());
    }

    @Override
    public void validate(IDataModel model) {
        if (model == null) {
            return;
        }
        String digestSignKey = (String)model.getValue("publickey");
        if (StringUtils.isBlank((CharSequence)digestSignKey)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u5237\u65b0\u8ba4\u8bc1\u5bc6\u94a5\u3002", (String)"AuthStrategyEditPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
    }

    @Override
    public ThirdAppEditDto confirm(IDataModel model) {
        this.validate(model);
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        thirdAppEditDto.setDigestSignKey(this.encode((String)model.getValue("publickey")));
        model.setValue("thirdAppModel", (Object)JSON.toJSONString((Object)thirdAppEditDto));
        return thirdAppEditDto;
    }

    @Override
    public void updateModel(IDataModel model, ThirdAppEditDto thirdAppEditDto) {
        Long strategyTypeId = thirdAppEditDto.getStrategyId();
        model.setValue("publickey", (Object)thirdAppEditDto.getDigestSignKey());
        model.setValue("is_digest", (Object)"1");
        this.save(model, strategyTypeId);
    }

    @Override
    public void delete(IDataModel model, String thirdAppStrategyId) {
        if (StringUtil.isEmpty((String)thirdAppStrategyId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdStrategyId is null.", new Object[0]);
        }
        model.setValue("is_digest", (Object)"0");
        model.setValue("publickey", (Object)"");
        this.updateAndDelete(model, Long.valueOf(thirdAppStrategyId));
    }
}

