/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.thirdapp.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.isc.util.dt.D;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.thirdapp.entity.ThirdAppEditDto;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyUpdateService;
import kd.bos.openapi.form.plugin.thirdapp.service.StrategyValidateService;
import kd.bos.openapi.form.plugin.thirdapp.service.impl.AbstractStrategyUpdateService;

public class SignAuthUpdateServiceImpl
extends AbstractStrategyUpdateService
implements StrategyUpdateService,
StrategyValidateService {
    @Override
    public void init(IDataModel model, ThirdAppEditDto thirdAppEditDto) {
        DynamicObjectCollection dyEntry = null;
        if (model == null) {
            DynamicObject thirdApp = this.loadThirdApp(thirdAppEditDto.getId());
            if (thirdApp != null) {
                thirdAppEditDto.setSignShaKey(thirdApp.getString("signature_key"));
                thirdAppEditDto.setSignType(thirdApp.getLong("sign_type"));
                dyEntry = thirdApp.getDynamicObjectCollection("entryentity_basicauth");
            }
        } else {
            thirdAppEditDto.setSignShaKey((String)model.getValue("signature_key"));
            thirdAppEditDto.setSignType((Long)model.getValue("sign_type"));
            dyEntry = model.getEntryEntity("entryentity_basicauth");
        }
        thirdAppEditDto.setSignAuthEnable(true);
        if (dyEntry != null) {
            dyEntry.forEach(dynamicObject -> {
                if ("1".equals(dynamicObject.getString("type"))) {
                    thirdAppEditDto.setSignAgentUserId(dynamicObject.getLong("agentuserid.id"));
                    thirdAppEditDto.setSignSecretKey(dynamicObject.getString("basesigncode"));
                }
            });
        }
    }

    @Override
    public void loadData(IDataModel model) {
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        model.setValue("signature_key", (Object)thirdAppEditDto.getSignShaKey());
        model.setValue("sign_type", (Object)("1".equals(thirdAppEditDto.getIsNew()) ? "1" : thirdAppEditDto.getSignType() + ""));
        model.setValue("signagentuserid", (Object)thirdAppEditDto.getSignAgentUserId());
        String signSecretKey = EncryptUtil.decode((String)thirdAppEditDto.getSignSecretKey());
        if (StringUtil.isNotEmpty((String)signSecretKey)) {
            model.setValue("signsecretkey", (Object)EncryptUtil.genSignWithAccountId((String)signSecretKey, (String)RequestContext.get().getAccountId()));
            model.setValue("signsecretkeydb", (Object)signSecretKey);
        }
    }

    @Override
    public void validate(IDataModel model) {
        if (model == null) {
            return;
        }
        String signKey = (String)model.getValue("signature_key");
        if (StringUtils.isBlank((CharSequence)signKey)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u5237\u65b0\u8ba4\u8bc1\u5bc6\u94a5\u3002", (String)"AuthStrategyEditPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity_basicauth");
        List agentList = entryEntity.stream().filter(agent -> "1".equals(agent.getString("type"))).collect(Collectors.toList());
        if (model.getValue("signagentuserid") == null && !CollectionUtil.isNotEmpty(agentList)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u9009\u7b7e\u540d\u8ba4\u8bc1-\u4ee3\u7406\u7528\u6237\u3002", (String)"AuthStrategyEditPlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
    }

    @Override
    public ThirdAppEditDto confirm(IDataModel model) {
        this.validate(model);
        ThirdAppEditDto thirdAppEditDto = this.loadThirdApp(model);
        thirdAppEditDto.setSignShaKey(this.encode((String)model.getValue("signature_key")));
        thirdAppEditDto.setSignType(Long.valueOf((String)model.getValue("sign_type")));
        thirdAppEditDto.setSignSecretKey(this.encode(D.s((Object)model.getValue("signsecretkeydb"))));
        thirdAppEditDto.setSignAgentUserId(D.l((Object)((DynamicObject)model.getValue("signagentuserid")).getPkValue()));
        model.setValue("thirdAppModel", (Object)JSON.toJSONString((Object)thirdAppEditDto));
        return thirdAppEditDto;
    }

    @Override
    public void updateModel(IDataModel model, ThirdAppEditDto thirdAppEditDto) {
        Long strategyTypeId = thirdAppEditDto.getStrategyId();
        model.setValue("signature_key", (Object)thirdAppEditDto.getSignShaKey());
        model.setValue("is_signature", (Object)"1");
        model.setValue("sign_type", (Object)thirdAppEditDto.getSignType());
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity_basicauth");
        List agentList = entryEntity.stream().filter(agent -> "1".equals(agent.getString("type"))).collect(Collectors.toList());
        DynamicObject agent2 = null;
        if (CollectionUtil.isNotEmpty(agentList)) {
            agent2 = (DynamicObject)agentList.get(0);
            agent2.set("agentuserid", (Object)thirdAppEditDto.getSignAgentUserId());
            agent2.set("basesigncode", (Object)this.encode(thirdAppEditDto.getSignSecretKey()));
            agent2.set("basicstatus", (Object)"1");
            agent2.set("agentuserid_id", (Object)thirdAppEditDto.getSignAgentUserId());
            agent2.set("type", (Object)"1");
        } else {
            DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
            agent2 = new DynamicObject(dynamicObjectType);
            agent2.set("id", (Object)DB.genLongId((String)"t_open_3rdapps_basicauth"));
            agent2.set("agentuserid", (Object)thirdAppEditDto.getSignAgentUserId());
            agent2.set("basesigncode", (Object)this.encode(thirdAppEditDto.getSignSecretKey()));
            agent2.set("basicstatus", (Object)"1");
            agent2.set("agentuserid_id", (Object)thirdAppEditDto.getSignAgentUserId());
            agent2.set("type", (Object)"1");
            entryEntity.add((Object)agent2);
            model.updateEntryCache(entryEntity);
        }
        this.save(model, strategyTypeId);
    }

    @Override
    public void delete(IDataModel model, String thirdAppStrategyId) {
        if (StringUtil.isEmpty((String)thirdAppStrategyId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "the thirdStrategyId is null.", new Object[0]);
        }
        model.setValue("is_signature", (Object)"0");
        model.setValue("signature_key", (Object)"");
        List deleteIndexList = model.getEntryEntity("entryentity_basicauth").stream().filter(agent -> "1".equals(agent.getString("type"))).map(dy -> dy.getInt("seq") - 1).collect(Collectors.toList());
        model.deleteEntryRows("entryentity_basicauth", deleteIndexList.stream().mapToInt(Integer::intValue).toArray());
        this.updateAndDelete(model, Long.valueOf(thirdAppStrategyId));
    }
}

