/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.baserecordset.exportandimport.BaseDataSetDao;
import kd.bos.dataentity.metadata.database.DbMetadataColumn;
import kd.bos.dataentity.metadata.database.DbMetadataColumnCollection;
import kd.bos.dataentity.metadata.database.DbMetadataTable;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.designer.baserecordset.IDataSetOperater;
import kd.bos.metadata.dao.AlterTableUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.SplitTable;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.GroupField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.Pair;

public class ApiDataSetOperater
implements IDataSetOperater {
    public static final String MAP_TABLE_NAME = "table";
    public static final String PRIVATE_KEY_FIELD = "PrivateKeyField";
    private static final String NUMBER = "number";
    private static final String LINE_SEPARATOR = "line.separator";
    private final String sNumber;
    private DBRoute dbRoute;
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final List<String> tableNames = Arrays.asList("t_open_apiservice", "t_openapi_ext", "t_open_apiservice_l");

    public ApiDataSetOperater(String number) {
        this.sNumber = number;
    }

    public List<Map<String, Object>> getExpDataSetSqlWithIds(List<String> ids) {
        ArrayList<Map<String, Object>> lstMapRet = new ArrayList<Map<String, Object>>(10);
        Map<String, Pair<Map<String, Object>, Map<String, String>>> tableFieldMap = this.getTableInfo(this.getNumber());
        for (String id : ids) {
            HashMap<String, Object> mapRet = new HashMap<String, Object>();
            ArrayList<String> lstQueryIds = new ArrayList<String>();
            lstQueryIds.add(id);
            for (Map.Entry<String, Pair<Map<String, Object>, Map<String, String>>> tableName : tableFieldMap.entrySet()) {
                this.getOneTableSetSqlAndContextWithIds(tableName.getKey(), tableName.getValue(), mapRet, lstQueryIds, id);
            }
            lstMapRet.add(mapRet);
        }
        return lstMapRet;
    }

    private void getOneTableSetSqlAndContextWithIds(String tableName, Pair<Map<String, Object>, Map<String, String>> tableFields, Map<String, Object> mapContext, List<String> ids, String id) {
        Object obSql;
        Object obNumber;
        ArrayList<Object> lstFields = new ArrayList<Object>(10);
        ArrayList<String> lstFileFields = new ArrayList<String>(10);
        String sPKey = "FID";
        HashMap xmlMap = new HashMap();
        for (Map.Entry feildName : ((Map)tableFields.getKey()).entrySet()) {
            if (feildName.getValue().equals(PRIVATE_KEY_FIELD)) {
                sPKey = (String)feildName.getKey();
            }
            lstFields.add(feildName.getKey());
            if (!"LargeTextField".equals(feildName.getValue())) continue;
            lstFields.add((String)feildName.getKey() + "_tag");
            lstFileFields.add((String)feildName.getKey() + "_tag");
        }
        List lstItems = new ArrayList(4);
        if (!lstFields.contains("FID") && !lstFields.contains("fid") && (tableName.endsWith("_L") || tableName.endsWith("_l"))) {
            List entryItems = BaseDataSetDao.getItemsByIds((DBRoute)this.dbRoute, (String)tableName.substring(0, tableName.length() - 2), Collections.singletonList("fentryid"), ids, (String)"FID");
            ArrayList<String> entryIds = new ArrayList<String>(4);
            for (Object obj : entryItems) {
                Object fentryid;
                if (!(obj instanceof Map) || !((fentryid = ((Map)obj).get("fentryid")) instanceof String)) continue;
                String s = (String)fentryid;
                entryIds.add(s);
            }
            for (String entryId : entryIds) {
                List multEntryItems = BaseDataSetDao.getItemsByIds((DBRoute)this.dbRoute, (String)tableName, lstFields, Collections.singletonList(entryId), (String)"fentryid");
                if (!CollectionUtil.isNotEmpty((Collection)multEntryItems)) continue;
                lstItems.addAll(multEntryItems);
            }
        } else {
            lstItems = BaseDataSetDao.getItemsByIds((DBRoute)this.dbRoute, (String)tableName, lstFields, ids, (String)"FID");
        }
        if ((obNumber = mapContext.get(NUMBER)) == null && !lstItems.isEmpty()) {
            Map mapItem = (Map)lstItems.get(0);
            obNumber = mapItem.get(this.getItemNumberField());
        }
        StringBuilder sbSql = new StringBuilder();
        if (!(!lstFields.contains("FID") && !lstFields.contains("fid") || tableName.endsWith("_L") || tableName.endsWith("_l") || lstItems.isEmpty() || tableNames.contains(tableName.toLowerCase()))) {
            sbSql.append(String.format("delete from %s where FID = %s", tableName, Long.parseLong(id))).append(';');
            sbSql.append(System.getProperty(LINE_SEPARATOR));
        }
        if ((obSql = mapContext.get("sql")) != null) {
            sbSql.append(obSql.toString());
        }
        List lstMapExpData = new ArrayList();
        Object obExp = mapContext.get("exp");
        if (obExp != null) {
            lstMapExpData = (List)SerializationUtils.fromJsonString((String)obExp.toString(), List.class);
        }
        for (Object item : lstItems) {
            Map mapItem = (Map)item;
            StringBuilder sqlFields = new StringBuilder();
            StringBuilder sqlFieldValues = new StringBuilder();
            HashMap mapExpData = new HashMap();
            for (int i = 0; i < lstFields.size(); ++i) {
                String lstField = (String)lstFields.get(i);
                if ("fjmxcontext".equalsIgnoreCase(lstField) || "FDATASOURCECONTENT".equalsIgnoreCase(lstField) || "t_bas_unittestdetail_A".equals(tableName) && "fid".equalsIgnoreCase(lstField)) continue;
                String sTempField = lstField;
                Object obItemValue = mapItem.get(sTempField);
                String sTempValue = obItemValue == null ? null : obItemValue.toString();
                if (lstFileFields.contains(sTempField)) {
                    mapExpData.put(sPKey, mapItem.get(sPKey));
                    mapExpData.put(sTempField, mapItem.get(sTempField));
                    mapExpData.put(MAP_TABLE_NAME, tableName);
                    continue;
                }
                sqlFields.append(String.format(" %s,", lstField));
                String fieldType = (String)((Map)tableFields.getValue()).get(lstField.toUpperCase());
                if (sTempValue == null) {
                    sqlFieldValues.append(" NULL,");
                    continue;
                }
                if (sTempValue.isEmpty()) {
                    sqlFieldValues.append(" ' ',");
                    continue;
                }
                Object value = ApiDataSetOperater.convertValue(sTempValue, fieldType);
                if (value instanceof String) {
                    sqlFieldValues.append(String.format(" '%s',", value));
                    continue;
                }
                if (value instanceof Date) {
                    sqlFieldValues.append(String.format("{ts'%s'},", format.format(value)));
                    continue;
                }
                sqlFieldValues.append(" ").append(value).append(",");
            }
            if (!lstFileFields.isEmpty()) {
                lstMapExpData.add(mapExpData);
            }
            sqlFields.deleteCharAt(sqlFields.length() - 1);
            sqlFieldValues.deleteCharAt(sqlFieldValues.length() - 1);
            String sPKeyValue = (String)mapItem.get(sPKey);
            String sPKeyFieldType = (String)((Map)tableFields.getValue()).get(sPKey.toUpperCase());
            Object value = ApiDataSetOperater.convertValue(sPKeyValue, sPKeyFieldType);
            sbSql.append(String.format("delete from %s where %s = ", tableName, sPKey)).append(value instanceof String ? " '" + value + "' " : value).append(';');
            sbSql.append(System.getProperty(LINE_SEPARATOR));
            sbSql.append(String.format("insert into %s (%s) values (%s);", tableName, sqlFields, sqlFieldValues));
            sbSql.append(System.getProperty(LINE_SEPARATOR));
        }
        mapContext.put("sql", sbSql.toString());
        mapContext.put("exp", SerializationUtils.toJsonString(lstMapExpData));
        mapContext.put(NUMBER, obNumber);
        mapContext.put("xml", xmlMap);
    }

    private static Object convertValue(String fieldValue, String fieldType) {
        if (fieldType == null) {
            return fieldValue;
        }
        List<String> longTypes = Arrays.asList("tinyint", "smallint", "mediumint", "integer", "smallserial", "serial", "int", "bigint", "bigserial", "long", "int4", "int8", "int16", NUMBER);
        List<String> doubleTypes = Arrays.asList("float", "double", "real", "double precision");
        List<String> dateTypes = Arrays.asList("timestamp", "date", "datetime");
        String lowerfieldType = fieldType.toLowerCase();
        if (longTypes.contains(lowerfieldType) || lowerfieldType.contains("int(") || lowerfieldType.contains("bigint(") || lowerfieldType.contains("long(") || lowerfieldType.contains("number(")) {
            try {
                return Long.valueOf(fieldValue);
            }
            catch (NumberFormatException e) {
                return fieldValue;
            }
        }
        if (doubleTypes.contains(lowerfieldType)) {
            try {
                return Double.valueOf(fieldValue);
            }
            catch (NumberFormatException e) {
                return fieldValue;
            }
        }
        if (dateTypes.contains(lowerfieldType)) {
            try {
                Date date = format.parse(fieldValue);
                return date;
            }
            catch (ParseException e) {
                return fieldValue;
            }
        }
        return fieldValue;
    }

    private Map<String, Pair<Map<String, Object>, Map<String, String>>> getTableInfo(String number) {
        HashMap<String, Pair<Map<String, Object>, Map<String, String>>> tableFieldMap = new HashMap<String, Pair<Map<String, Object>, Map<String, String>>>();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        String entityid = formMeta.getEntityId();
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityid, (MetaCategory)MetaCategory.Entity);
        if (entityMetadata == null) {
            return tableFieldMap;
        }
        String dbRoueKey = entityMetadata.getRootEntity().buildDataEntityType().getDBRouteKey();
        this.dbRoute = new DBRoute(dbRoueKey);
        if (!(entityMetadata.getRootEntity() instanceof BillEntity)) {
            return tableFieldMap;
        }
        List entityList = entityMetadata.getEntitys();
        for (Entity entity : entityList) {
            this.toGetEntityTables(entityMetadata, entity, tableFieldMap);
            if (!(entity instanceof MainEntity)) continue;
            for (EntityItem item : entity.getItems()) {
                if (!(item instanceof GroupField)) continue;
                this.toGetGroupTables(item, tableFieldMap);
            }
        }
        return tableFieldMap;
    }

    private void toGetGroupTables(EntityItem<?> item, Map<String, Pair<Map<String, Object>, Map<String, String>>> mapTables) {
        String sFieldName;
        DbMetadataColumnCollection cols;
        HashMap<String, String> mapFields;
        String tableName = ((GroupField)item).getGroupTableName();
        DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)this.dbRoute.getRouteKey(), (String)tableName);
        if (tableSchema != null) {
            mapFields = new HashMap<String, String>();
            mapTables.put(tableName, (Pair<Map<String, Object>, Map<String, String>>)new Pair(mapFields, this.getMapFields(tableName)));
            cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                sFieldName = dbMetadataColumn.getName();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if ("FID".equalsIgnoreCase(sFieldName)) {
                    mapFields.put(sFieldName, PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName, "");
            }
        }
        tableName = tableName + "_L";
        tableSchema = AlterTableUtil.getTableSchema((String)this.dbRoute.getRouteKey(), (String)tableName);
        if (tableSchema != null) {
            mapFields = new HashMap();
            mapTables.put(tableName, (Pair<Map<String, Object>, Map<String, String>>)new Pair(mapFields, this.getMapFields(tableName)));
            cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                sFieldName = dbMetadataColumn.getName();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if ("FID".equalsIgnoreCase(sFieldName)) {
                    mapFields.put(sFieldName, PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName, "");
            }
        }
    }

    private void toGetEntityTables(EntityMetadata entityMetadata, Entity<?, ?> entity, Map<String, Pair<Map<String, Object>, Map<String, String>>> mapTables) {
        List splitTables = entity.getSplitTables();
        if (splitTables == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)entity.getTableName())) {
            return;
        }
        String pkFieldName = "FID";
        if (entity instanceof BillEntity) {
            pkFieldName = ((BillEntity)entity).getPkFieldName();
        } else if (entity instanceof SubEntryEntity) {
            EntryEntity parentEntry = entityMetadata.getEntryById(((SubEntryEntity)entity).getParentId());
            pkFieldName = parentEntry.getEntryPkFieldName();
        }
        if (!(entity instanceof MainEntity) && !StringUtils.isEmpty((CharSequence)((EntryEntity)entity).getEntryPkFieldName())) {
            pkFieldName = ((EntryEntity)entity).getEntryPkFieldName();
        }
        ArrayList<String> suffixList = new ArrayList<String>();
        String suffix = null;
        for (SplitTable s : splitTables) {
            suffix = s.getSuffix();
            if (suffix == null || !StringUtils.isNotEmpty((CharSequence)suffix)) continue;
            suffixList.add(suffix);
        }
        ArrayList<String> tableNameSuffix = new ArrayList<String>();
        tableNameSuffix.add("");
        tableNameSuffix.addAll(suffixList);
        for (String t_suffix : tableNameSuffix) {
            DbMetadataTable tableSchema;
            String tableName = entity.getTableName();
            if (StringUtils.isNotBlank((CharSequence)t_suffix)) {
                tableName = String.format("%s_%s", tableName, t_suffix);
            }
            if ((tableSchema = AlterTableUtil.getTableSchema((String)this.dbRoute.getRouteKey(), (String)tableName)) == null) break;
            HashMap<String, String> mapFields = new HashMap<String, String>();
            mapTables.put(tableName, (Pair<Map<String, Object>, Map<String, String>>)new Pair(mapFields, this.getMapFields(tableName)));
            DbMetadataColumnCollection cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                String sFieldName = dbMetadataColumn.getName();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if (sFieldName.equalsIgnoreCase(pkFieldName)) {
                    mapFields.put(sFieldName.toUpperCase(), PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName.toUpperCase(), "");
            }
            ArrayList<MuliLangTextField> mulLangFields = new ArrayList<MuliLangTextField>();
            ArrayList<MulBasedataField> mulBDFields = new ArrayList<MulBasedataField>();
            List entityItem = entity.getItems();
            for (EntityItem item : entityItem) {
                String sFieldName;
                if (!(item instanceof Field)) continue;
                if (item instanceof MuliLangTextField) {
                    mulLangFields.add((MuliLangTextField)(item instanceof MuliLangTextField ? item : null));
                    continue;
                }
                if (item instanceof MulBasedataField) {
                    mulBDFields.add((MulBasedataField)(item instanceof MulBasedataField ? item : null));
                    continue;
                }
                Field itemField = (Field)item;
                if (!itemField.getTableName(entity).equalsIgnoreCase(tableName) || !StringUtils.isNotBlank((CharSequence)(sFieldName = itemField.getFieldName()))) continue;
                mapFields.put(itemField.getFieldName().toUpperCase(), item.getClass().getSimpleName());
            }
            if (!mulLangFields.isEmpty() && tableName.equalsIgnoreCase(entity.getTableName())) {
                this.toGetMulLangTable(entity, mapTables);
            }
            if (mulBDFields.isEmpty() || !tableName.equalsIgnoreCase(entity.getTableName())) continue;
            this.toGetMulBaseDateTable(entity, mulBDFields, mapTables);
        }
    }

    public Map<String, String> getMapFields(String tableName) {
        List fieldInfoList = DB.getFieldInfo((DBRoute)DBRoute.base, (String)tableName);
        List newList = fieldInfoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FieldInfo>(Comparator.comparing(FieldInfo::getFieldName))), ArrayList::new));
        return newList.stream().collect(Collectors.toMap(it -> it.getFieldName().toUpperCase(), FieldInfo::getDataType));
    }

    private void toGetMulLangTable(Entity<?, ?> entity, Map<String, Pair<Map<String, Object>, Map<String, String>>> mapTables) {
        String pkFieldName = "FPKID";
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        String tableName = entity.getTableName() + "_L";
        DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)this.dbRoute.getRouteKey(), (String)tableName);
        if (null != tableSchema) {
            HashMap<String, String> mapFields = new HashMap<String, String>();
            mapTables.put(tableName, (Pair<Map<String, Object>, Map<String, String>>)new Pair(mapFields, this.getMapFields(tableName)));
            DbMetadataColumnCollection cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                String sFieldName = dbMetadataColumn.getName();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if (sFieldName.equalsIgnoreCase(pkFieldName)) {
                    mapFields.put(sFieldName, PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName, "");
            }
        }
    }

    private void toGetMulBaseDateTable(Entity<?, ?> entity, List<MulBasedataField> mulBasedataFields, Map<String, Pair<Map<String, Object>, Map<String, String>>> mapTables) {
        String pkFieldName = "FPKID";
        if (StringUtils.isEmpty((CharSequence)entity.getTableName())) {
            return;
        }
        for (MulBasedataField mulBsdfield : mulBasedataFields) {
            String tableName = mulBsdfield.getTableName();
            DbMetadataTable tableSchema = AlterTableUtil.getTableSchema((String)this.dbRoute.getRouteKey(), (String)tableName);
            if (null == tableSchema) continue;
            HashMap<String, String> mapFields = new HashMap<String, String>();
            mapTables.put(tableName, (Pair<Map<String, Object>, Map<String, String>>)new Pair(mapFields, this.getMapFields(tableName)));
            DbMetadataColumnCollection cols = tableSchema.getColumns();
            for (DbMetadataColumn dbMetadataColumn : cols) {
                String sFieldName = dbMetadataColumn.getName();
                if (!StringUtils.isNotBlank((CharSequence)sFieldName)) continue;
                if (sFieldName.equalsIgnoreCase(pkFieldName)) {
                    mapFields.put(sFieldName, PRIVATE_KEY_FIELD);
                    continue;
                }
                mapFields.put(sFieldName, "");
            }
        }
    }

    public String getNumber() {
        return this.sNumber;
    }

    protected String getItemNumberField() {
        return "FNUMBER";
    }

    public JSONObject expBaseData(String path) {
        return null;
    }

    public JSONObject impBaseData(String number, String path) {
        return null;
    }

    public JSONObject commitBaseDataToSvn() {
        return null;
    }

    public JSONObject expBaseDataWithIds(String path, JSONArray ids) {
        return null;
    }

    public JSONObject commitBaseDataToSvnWithIds(JSONArray ids) {
        return null;
    }

    public JSONObject deleteBaseDataFromSvnWithIds() {
        return null;
    }
}

