/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.attachment.DisposableUrlParam;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.isc.util.misc.Hash;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.openapi.base.dts.DtsUtil;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ExportUtil {
    private static final Log LOG = LogFactory.getLog(ExportUtil.class);
    private static final String DTS_SUFFIX = ".dts";
    private static final Pattern ILLEGAL_CHAR_PATTERN = Pattern.compile("[\\s\\\\/:*?\"<>|@#$%^!&`']");
    public static final int COMPRESS_SECOND = 300;

    public static void export(IFormView view, ListSelectedRowCollection selectRows, boolean isZip) {
        ExportUtil.export(view, selectRows, isZip, "");
    }

    /*
     * Exception decompiling
     */
    public static String exportDts(IFormView view, List<DynamicObject> list, boolean isZip) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void exportDts(List<DynamicObject> list, Writer writer) throws IOException {
        DtsUtil.INSTANCE.doExport(list, writer);
    }

    public static String generateFileName(List<DynamicObject> list) {
        return ExportUtil.generateFileName(list, "");
    }

    public static String generateFileName(List<DynamicObject> list, String appName) {
        String fileName;
        String displayName = list.get(0).getDynamicObjectType().getDisplayName().getLocaleValue();
        String entityName = list.get(0).getDynamicObjectType().getName().trim();
        String sessionId = Hash.mur16((Object[])new Object[]{RequestContext.get().getGlobalSessionId()});
        if (list.size() > 1) {
            StringBuilder sb = new StringBuilder();
            fileName = StringUtil.isEmpty((String)appName) ? sb.append(displayName).append("(").append(entityName).append(")_").append(sessionId).toString() : sb.append(displayName).append("(").append(entityName).append(")_").append(appName).append("_").append(sessionId).toString();
        } else {
            fileName = ExportUtil.generateSingleObjectFileName(list.get(0), displayName, entityName, sessionId, appName);
        }
        return ExportUtil.removeIllegalChar(fileName);
    }

    private static String generateSingleObjectFileName(DynamicObject dObject, String displayName, String entityName, String sessionId) {
        return ExportUtil.generateSingleObjectFileName(dObject, displayName, entityName, sessionId, "");
    }

    private static String generateSingleObjectFileName(DynamicObject dObject, String displayName, String entityName, String sessionId, String appName) {
        String id = dObject.getString("id");
        String number = dObject.getString("number");
        String name = dObject.getString("name");
        StringBuilder sb = new StringBuilder();
        String fileName = StringUtil.isEmpty((String)name) || StringUtil.isEmpty((String)number) ? (StringUtil.isEmpty((String)appName) ? sb.append(displayName).append("_").append(id).append("_").append(sessionId).toString() : sb.append(displayName).append("_").append(id).append("_").append(appName).append("_").append(sessionId).toString()) : (StringUtil.isEmpty((String)appName) ? sb.append(displayName).append("_").append(name).append("(").append(number).append(")_").append(sessionId).toString() : sb.append(displayName).append("_").append(name).append("(").append(number).append(")_").append(appName).append("_").append(sessionId).toString());
        return fileName;
    }

    public static String removeIllegalChar(String fileName) {
        Matcher matcher = ILLEGAL_CHAR_PATTERN.matcher(fileName);
        return matcher.replaceAll("");
    }

    public static String createTxt(String txt) {
        String fp = "." + File.separator + System.currentTimeMillis() + ".txt";
        File file = new File(fp);
        try (FileWriter fw = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fw);){
            if (!file.exists() && !file.createNewFile()) {
                throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "create File fail", new Object[0]);
            }
            bufferedWriter.write(txt);
            bufferedWriter.write("\n");
        }
        catch (IOException e) {
            LOG.error("export log error", (Throwable)e);
        }
        return fp;
    }

    public static void export(IFormView view, ListSelectedRowCollection selectRows, boolean isZip, String appName) {
        if (CollectionUtil.isEmpty((Collection)selectRows)) {
            throw new OpenApiException(ApiErrorCode.Data_NotFound, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ExportUtil_3", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]), new Object[0]);
        }
        String entityName = ((ListView)view).getEntityTypeId();
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)"id, apiservicetype", (QFilter[])QFilterUtil.builder((String)"id", (String)"in", (Object)selectRows.getPrimaryKeyValues()).buildArray());
        if (CollectionUtil.isEmpty((Collection)query)) {
            throw new OpenApiException(ApiErrorCode.Data_NotFound, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ExportUtil_4", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]), new Object[0]);
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if ("openapi_apilist".equals(entityName)) {
            Map.Entry entry;
            MainEntityType mainEntityType;
            Map map = query.stream().collect(Collectors.groupingBy(it -> it.getInt("apiservicetype"), Collectors.mapping(it -> it.get("id"), Collectors.toSet())));
            Iterator<Map.Entry<Integer, Set<Object>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext() && null != (mainEntityType = EntityMetadataCache.getDataEntityType((String)ApiServiceType.get((int)(entry = iterator.next()).getKey()).getEntityName()))) {
                DynamicObject[] load = BusinessDataServiceHelper.load((Object[])entry.getValue().toArray(), (DynamicObjectType)mainEntityType);
                ExportUtil.exportExportFields(mainEntityType, load);
                list.addAll(Arrays.asList(load));
            }
        } else {
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])query.stream().map(it -> it.get("id")).distinct().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
            list.addAll(Arrays.asList(load));
        }
        if (isZip) {
            HashSet<String> urls = new HashSet<String>(list.size());
            for (DynamicObject object : list) {
                String url = ExportUtil.exportDts(view, Collections.singletonList(object), true);
                urls.add(url);
            }
            StringBuilder zipName = new StringBuilder(ExportUtil.generateFileName(list, appName)).append(".zip");
            String zipUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().compress(zipName.toString(), urls.toArray(new String[0]), 300);
            String oneTimeUrl = ExportUtil.genCustomAttachUrl(zipUrl, true);
            view.openUrl(oneTimeUrl);
        } else {
            ExportUtil.exportDts(view, list, false);
        }
    }

    private static void exportExportFields(MainEntityType mainEntityType, DynamicObject[] load) {
        Set<String> customRemoveFields = ExportUtil.getCustomRemoveFields();
        if (CollectionUtil.isNotEmpty(customRemoveFields)) {
            Set mainEntityNames = mainEntityType.getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
            HashSet<String> intersection = new HashSet<String>(customRemoveFields);
            intersection.retainAll(mainEntityNames);
            if (CollectionUtil.isNotEmpty(intersection)) {
                for (String removeField : intersection) {
                    for (DynamicObject dynamicObject : load) {
                        dynamicObject.set(removeField, null);
                    }
                }
            }
        }
    }

    public static Set<String> getCustomRemoveFields() {
        String customExportRemoveFields = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("custom_export_apidts", null);
        HashSet<String> removeFields = new HashSet<String>();
        if (StringUtil.isNotEmpty((String)customExportRemoveFields)) {
            String[] split = customExportRemoveFields.split(",");
            removeFields.addAll(Arrays.asList(split));
        }
        return removeFields;
    }

    public static String genCustomAttachUrl(String url, boolean isBindPriorityItem) {
        DisposableUrlParam param = new DisposableUrlParam();
        param.setPkId((Object)0);
        param.setPath(RequestContext.get().getClientFullContextPath() + url);
        param.setEntityNum("openapi_apilist");
        if (isBindPriorityItem) {
            param.setPermItem("4730fc9f000004ae");
        }
        return AttachmentServiceHelper.genCustomAttachUrl((DisposableUrlParam)param);
    }
}

