/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.entity.param.AppParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isc.util.misc.StringUtil;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.openapi.common.constant.ConfigConstant;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class FormOpener {
    private static final Log LOG = LogFactory.getLog(FormOpener.class);
    private static final String APP_MIAN_TAB = "appmiantab";
    private static final String CTRL_SUBMAINTAB = "_submaintab_";
    private static final String BOS_LIST = "bos_list";

    public static void showForm(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback) {
        FormShowParameter p = FormOpener.getFormShowParameter(form, entity, caption, params, callback);
        p.getOpenStyle().setShowType(ShowType.Modal);
        form.getView().showForm(p);
    }

    public static void showApiTestForm(AbstractFormPlugin form, String caption, Map<String, Object> params, String callback) {
        String entity = "openapi_testapi";
        if (FormOpener.apitestShowType() == 1) {
            form.getView().setVisible(Boolean.valueOf(true), new String[]{"flex_test"});
            entity = "openapi_testapi_l";
            callback = "openapi_testapi_l";
        }
        FormShowParameter p = FormOpener.getFormShowParameter(form, entity, caption, params, callback);
        if (FormOpener.apitestShowType() == 1) {
            p.getOpenStyle().setShowType(ShowType.InContainer);
            p.getOpenStyle().setTargetKey("flex_test");
        } else {
            p.getOpenStyle().setShowType(ShowType.Modal);
        }
        form.getView().showForm(p);
    }

    public static int apitestShowType() {
        AppParam appParam = new AppParam("W3NF+MX967M", "15", Long.valueOf(ParameterOrgUtils.getParamRootOrgId()), ConfigConstant.OPEN_SYS_PARAMS_ACT_BOOK_ID);
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        if (null != paramMap.get("api_test_type") && paramMap.get("api_test_type").equals("1")) {
            return 1;
        }
        return 0;
    }

    public static FormShowParameter getFormShowParameter(AbstractFormPlugin form, String entity, String caption, Map<String, Object> params, String callback) {
        FormShowParameter p = new FormShowParameter();
        p.setFormId(entity);
        p.setCustomParams(params);
        p.setCaption(caption);
        if (callback != null) {
            p.setCloseCallBack(new CloseCallBack((IFormPlugin)form, callback));
        }
        return p;
    }

    public static void showErrorMessage(IFormView view, Throwable e) {
        FormOpener.showErrorMessage(view, DataUtil.getMessage((Throwable)e), DataUtil.toString((Throwable)e));
    }

    public static void showErrorMessage(IFormView view, String title, Throwable e) {
        FormOpener.showErrorMessage(view, title, DataUtil.toString((Throwable)e));
    }

    public static void showErrorMessage(IFormView view, String title, String detail) {
        view.showMessage(title, detail, MessageTypes.Default);
    }

    private static boolean openTabIfExist(AbstractFormPlugin form, String entity, Map<String, Object> params) {
        try {
            IFormView appView;
            Control control;
            IFormView view = form.getView();
            IFormView mainView = view.getMainView();
            return mainView != null && !mainView.getPageId().equals(view.getPageId()) && (control = (appView = SessionManager.getCurrent().getViewNoPlugin(view.getFormShowParameter().getAppId() + mainView.getPageId())).getControl(CTRL_SUBMAINTAB)) instanceof Tab && FormOpener.existTabPage(entity, view, appView, (Tab)control, params);
        }
        catch (Exception e) {
            LOG.warn("\u5224\u65ad\u662f\u5426\u5b58\u5728\u65b0\u9875\u7b7e\u65f6\u5931\u8d25,\u539f\u56e0\u662f\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
            return false;
        }
    }

    private static boolean existTabPage(String entity, IFormView view, IFormView appView, Tab control, Map<String, Object> params) {
        for (Object c : control.getItems()) {
            FormShowParameter formShowParameter;
            String formId;
            TabPage tabPage = (TabPage)c;
            String tabPageKey = tabPage.getKey();
            IFormView lv = appView.getViewNoPlugin(tabPageKey);
            if (lv == null || APP_MIAN_TAB.equals(tabPageKey) || !entity.equals(formId = (formShowParameter = lv.getFormShowParameter()) instanceof ListShowParameter ? ((ListShowParameter)formShowParameter).getBillFormId() : formShowParameter.getFormId())) continue;
            boolean flag = true;
            if (params != null && !params.isEmpty()) {
                Map customParams = formShowParameter.getCustomParams();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    String key = entry.getKey();
                    if (Objects.equals(entry.getValue(), customParams.get(key))) continue;
                    flag = false;
                    break;
                }
            }
            if (!flag) continue;
            control.activeTab(tabPageKey);
            view.sendFormAction(appView);
            return true;
        }
        return false;
    }

    public static void openBillList(AbstractFormPlugin form, String entity, List<QFilter> filters, String caption) {
        FormOpener.openBillListWithParam(form, entity, filters, caption, null);
    }

    public static void openBillListWithParam(AbstractFormPlugin form, String entity, List<QFilter> filters, String caption, Map<String, Object> params) {
        if (FormOpener.openTabIfExist(form, entity, filters)) {
            return;
        }
        ListShowParameter param = FormOpener.getListShowParameter(entity, filters, params);
        param.setCaption(caption);
        form.getView().showForm((FormShowParameter)param);
    }

    private static boolean openTabIfExist(AbstractFormPlugin form, String entity, List<QFilter> filters) {
        IFormView view = form.getView();
        IFormView mainView = view.getMainView();
        if (mainView != null && !mainView.getPageId().equals(view.getPageId())) {
            IFormView appView = SessionManager.getCurrent().getViewNoPlugin(view.getFormShowParameter().getAppId() + mainView.getPageId());
            if (appView == null) {
                return false;
            }
            Control control = appView.getControl(CTRL_SUBMAINTAB);
            return control instanceof Tab && FormOpener.existTabPage(entity, view, appView, (Tab)control, filters);
        }
        return false;
    }

    private static boolean existTabPage(String entity, IFormView view, IFormView appView, Tab control, List<QFilter> filters) {
        for (Object c : control.getItems()) {
            FormShowParameter formShowParameter;
            TabPage tabPage = (TabPage)c;
            String tabPageKey = tabPage.getKey();
            IFormView lv = appView.getViewNoPlugin(tabPageKey);
            if (lv == null || APP_MIAN_TAB.equals(tabPageKey) || !((formShowParameter = lv.getFormShowParameter()) instanceof ListShowParameter)) continue;
            ListShowParameter parameter = (ListShowParameter)formShowParameter;
            String formId = parameter.getBillFormId();
            if (filters == null || !entity.equals(formId)) continue;
            boolean flag = true;
            boolean flush = false;
            ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
            if (listFilterParameter == null) continue;
            List qFilters = listFilterParameter.getQFilters();
            if (filters.size() != qFilters.size()) continue;
            block1: for (int i = 0; i < qFilters.size(); ++i) {
                QFilter qFilter = (QFilter)qFilters.get(i);
                QFilter filter = filters.get(i);
                boolean property = qFilter.getProperty().equals(filter.getProperty());
                boolean cp = qFilter.getCP().equals(filter.getCP());
                if (property && cp) {
                    Object value = qFilter.getValue();
                    Object value1 = filter.getValue();
                    if (value instanceof List && value1 instanceof List) {
                        List val = (List)value;
                        List val1 = (List)value1;
                        for (int i1 = 0; i1 < val.size(); ++i1) {
                            if (val1.size() > 0 && val.get(i1).equals(val1.get(i1))) continue;
                            flag = false;
                            continue block1;
                        }
                        continue;
                    }
                    if (value instanceof Long && value1 instanceof Long) {
                        if (value.equals(value1)) continue;
                        flag = false;
                        break;
                    }
                    if (value instanceof String && value1 instanceof String) {
                        if (value.equals(value1)) continue;
                        flag = false;
                        break;
                    }
                    if (value instanceof Integer && value1 instanceof Integer) {
                        if (value.equals(value1)) continue;
                        flag = false;
                        break;
                    }
                    flag = false;
                    break;
                }
                flag = false;
                break;
            }
            if (!flag) continue;
            control.activeTab(tabPageKey);
            if (flush) {
                lv.invokeOperation("refresh");
            }
            view.sendFormAction(appView);
            return true;
        }
        return false;
    }

    private static ListShowParameter getListShowParameter(String entity, List<QFilter> filters, Map<String, Object> params) {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId(entity);
        param.setFormId(BOS_LIST);
        param.getListFilterParameter().setQFilters(filters);
        if (!CollectionUtil.isEmpty(params)) {
            param.setCustomParams(params);
        }
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return param;
    }
}

