/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.mservice.catalog.ServiceCatalogCenter;
import kd.bos.mservice.catalog.ServiceCatalogFactory;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;

public class MserviceUtil {
    public static Set<String> getMethodNamesByClassName(String className) {
        List<MServiceDefineMeta.MethodDefine> methodDefines = MserviceUtil.getMethodInfosByClassName(className);
        Set<String> methods = methodDefines.stream().map(MServiceDefineMeta.MethodDefine::getServiceMethodName).collect(Collectors.toSet());
        return methods;
    }

    public static List<MServiceDefineMeta.MethodDefine> getMethodInfosByClassName(String className) {
        if (StringUtil.isEmpty((String)className)) {
            return Collections.emptyList();
        }
        ServiceCatalogCenter catalogCenter = ServiceCatalogFactory.getCatalogCenter();
        Map serviceFromCatalogCenter = catalogCenter.getServiceFromCatalogCenter();
        MServiceDefineMeta mServiceDefineMeta = (MServiceDefineMeta)serviceFromCatalogCenter.get(className);
        if (mServiceDefineMeta == null) {
            return Collections.emptyList();
        }
        return mServiceDefineMeta.getMethods();
    }

    public static Boolean isHadRegistMservice(String className) {
        if (StringUtil.isEmpty((String)className)) {
            return false;
        }
        return CollectionUtil.isNotEmpty(MserviceUtil.getMethodInfosByClassName(className));
    }
}

