/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.util.enums.ParamTypeEnum;
import kd.bos.util.StringUtils;

public class OpenApiDataToJsonFormatUtils {
    private static final String PARAMNAME = "paramname";
    private static final String BODYENTRYENTITY = "bodyentryentity";
    private static final String RESPENTRYENTITY = "respentryentity";
    public static final String RESPPARAMNAME = "respparamname";

    public static String getJsonFormatData(DynamicObjectCollection collection, String typeKey, String nameKey, String valueKey) {
        Iterator iterator = collection.iterator();
        ArrayList<DynamicObject> tops = new ArrayList<DynamicObject>(10);
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            if (0L != dynamicObject.getLong("pid")) continue;
            tops.add(dynamicObject);
            iterator.remove();
        }
        Map<String, Object> resultMap = OpenApiDataToJsonFormatUtils.packageJsonFormat(collection, tops, typeKey, nameKey, valueKey);
        return JSON.toJSONString(resultMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
    }

    private static Map<String, Object> packageJsonFormat(DynamicObjectCollection dynamicObjects, List<DynamicObject> tops, String typeKey, String nameKey, String valueKey) {
        LinkedHashMap<String, Object> responseMap = new LinkedHashMap<String, Object>(16);
        for (DynamicObject top : tops) {
            String key = top.getString(nameKey).trim();
            String type = top.getString(typeKey).trim();
            ParamTypeEnum typeEnum = ParamTypeEnum.getParamTypeByInputFlag(type);
            if (typeEnum != ParamTypeEnum.ENTRIES && typeEnum != ParamTypeEnum.ARRAY && typeEnum != ParamTypeEnum.OBJECT) {
                String value = top.getString(valueKey);
                if (DataType.FLEX.type().equals(type) && (StringUtil.isEmpty((String)value) || "-".equals(value) || "{}".equals(value))) {
                    responseMap.put(key, JSON.parse((String)DataType.FLEX.defaultStringValue()));
                    continue;
                }
                responseMap.put(key, typeEnum.getFinalValue(typeEnum, value));
                continue;
            }
            if (typeEnum == ParamTypeEnum.ARRAY || typeEnum == ParamTypeEnum.ENTRIES) {
                responseMap.put(key, OpenApiDataToJsonFormatUtils.getArrayFormatData(dynamicObjects, typeKey, nameKey, valueKey, top));
                continue;
            }
            responseMap.put(key, OpenApiDataToJsonFormatUtils.packageJsonFormat(dynamicObjects, top, typeKey, nameKey, valueKey));
        }
        return responseMap;
    }

    private static List<Object> getArrayFormatData(DynamicObjectCollection dynamicObjects, String typeKey, String nameKey, String valueKey, DynamicObject parent) {
        ArrayList<Object> list = new ArrayList<Object>(1);
        int filedCount = 0;
        int subFiledCount = 0;
        for (DynamicObject response : dynamicObjects) {
            String type = response.getString(typeKey);
            String key = response.getString(nameKey);
            String value = response.getString(valueKey);
            ParamTypeEnum typeEnum = ParamTypeEnum.getParamTypeByInputFlag(type);
            if (!parent.getPkValue().toString().equals(response.getString("pid"))) continue;
            ++subFiledCount;
            if (!StringUtils.isBlank((String)key)) continue;
            ++filedCount;
            if (typeEnum != ParamTypeEnum.ENTRIES && typeEnum != ParamTypeEnum.ARRAY && typeEnum != ParamTypeEnum.OBJECT) {
                list.add(typeEnum.getFinalValue(typeEnum, value));
                continue;
            }
            if (typeEnum == ParamTypeEnum.OBJECT) {
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
                data.putAll(OpenApiDataToJsonFormatUtils.packageJsonFormat(dynamicObjects, response, typeKey, nameKey, valueKey));
                list.add(data);
                continue;
            }
            list.add(OpenApiDataToJsonFormatUtils.getArrayFormatData(dynamicObjects, typeKey, nameKey, valueKey, response));
        }
        if (filedCount == subFiledCount) {
            return list;
        }
        list.clear();
        list.add(OpenApiDataToJsonFormatUtils.packageJsonFormat(dynamicObjects, parent, typeKey, nameKey, valueKey));
        return list;
    }

    private static Map<String, Object> packageJsonFormat(DynamicObjectCollection dynamicObjects, DynamicObject object, String typeKey, String nameKey, String valueKey) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(16);
        for (DynamicObject response : dynamicObjects) {
            String type = response.getString(typeKey);
            String key = response.getString(nameKey);
            String value = response.getString(valueKey);
            ParamTypeEnum typeEnum = ParamTypeEnum.getParamTypeByInputFlag(type);
            if (!object.getPkValue().toString().equals(response.getString("pid"))) continue;
            if (typeEnum != ParamTypeEnum.ENTRIES && typeEnum != ParamTypeEnum.ARRAY && typeEnum != ParamTypeEnum.OBJECT) {
                if (DataType.FLEX.type().equals(type) && (StringUtil.isEmpty((String)value) || "-".equals(value) || "{}".equals(value))) {
                    result.put(key, JSON.parse((String)DataType.FLEX.defaultStringValue()));
                    continue;
                }
                result.put(key, typeEnum.getFinalValue(typeEnum, value));
                continue;
            }
            if (typeEnum == ParamTypeEnum.OBJECT) {
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
                data.putAll(OpenApiDataToJsonFormatUtils.packageJsonFormat(dynamicObjects, response, typeKey, nameKey, valueKey));
                result.put(key, data);
                continue;
            }
            result.put(key, OpenApiDataToJsonFormatUtils.getArrayFormatData(dynamicObjects, typeKey, nameKey, valueKey, response));
        }
        return result;
    }

    public static Map<String, Object> getResultData(DynamicObjectCollection collection, String typeKey, String nameKey, String valueKey) {
        Iterator iterator = collection.iterator();
        ArrayList<DynamicObject> tops = new ArrayList<DynamicObject>(10);
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            if (0L != dynamicObject.getLong("pid")) continue;
            tops.add(dynamicObject);
            iterator.remove();
        }
        Map<String, Object> resultMap = OpenApiDataToJsonFormatUtils.packageJsonFormat(collection, tops, typeKey, nameKey, valueKey);
        return resultMap;
    }

    public static Map<String, Object> transferToMap(DynamicObjectCollection collection, String entryType) {
        Map<String, Object> resultMap = new LinkedHashMap<String, Object>(16);
        DynamicObjectCollection temp = (DynamicObjectCollection)collection.clone();
        Iterator iterator = temp.iterator();
        ArrayList<DynamicObject> tops = new ArrayList<DynamicObject>(10);
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            if (0L != dynamicObject.getLong("pid")) continue;
            tops.add(dynamicObject);
            iterator.remove();
        }
        resultMap = OpenApiDataToJsonFormatUtils.packageCustomApiJsonFormat(temp, tops, entryType, resultMap);
        return resultMap;
    }

    private static Map<String, Object> packageCustomApiJsonFormat(DynamicObjectCollection dynamicObjects, List<DynamicObject> tops, String entryType, Map<String, Object> resultMap) {
        boolean isBodyColl = BODYENTRYENTITY.equals(entryType);
        Set<String> pidSet = OpenApiDataToJsonFormatUtils.getPIdSet(dynamicObjects);
        for (DynamicObject top : tops) {
            String example;
            String name = isBodyColl ? top.getString(PARAMNAME) : top.getString(RESPPARAMNAME);
            Boolean isMulValue = isBodyColl ? top.getBoolean("is_req_mul_value") : top.getBoolean("is_resp_mul_value");
            String string = example = isBodyColl ? (String)top.getLocaleString("example").getDefaultItem() : (String)top.getLocaleString("respexample").getDefaultItem();
            if (example == null) {
                example = "";
            }
            if (pidSet.contains(top.getPkValue().toString())) {
                LinkedHashMap<String, Object> childMap = new LinkedHashMap<String, Object>();
                OpenApiDataToJsonFormatUtils.getChildMap(dynamicObjects, top, entryType, pidSet, childMap);
                if (isMulValue.booleanValue() || example.startsWith("[")) {
                    resultMap.put(name, Collections.singletonList(childMap));
                    continue;
                }
                resultMap.put(name, childMap);
                continue;
            }
            Object key = "-".equalsIgnoreCase(example) ? "-" : JSON.parse((String)example);
            resultMap.put(name, key);
        }
        return resultMap;
    }

    private static void getChildMap(DynamicObjectCollection dynamicObjects, DynamicObject parent, String entryType, Set<String> pidSet, Map<String, Object> resultMap) {
        boolean isBodyColl = BODYENTRYENTITY.equals(entryType);
        for (DynamicObject dy : dynamicObjects) {
            String keyStr;
            String example;
            String pid = dy.getString("pid");
            Boolean isMulValue = isBodyColl ? dy.getBoolean("is_req_mul_value") : dy.getBoolean("is_resp_mul_value");
            String string = example = isBodyColl ? (String)dy.getLocaleString("example").getDefaultItem() : (String)dy.getLocaleString("respexample").getDefaultItem();
            if (example == null) {
                example = "";
            }
            if (!pid.equals(parent.getPkValue().toString())) continue;
            if (pidSet.contains(dy.getPkValue().toString())) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(16);
                String name = isBodyColl ? dy.getString(PARAMNAME) : dy.getString(RESPPARAMNAME);
                OpenApiDataToJsonFormatUtils.getChildMap(dynamicObjects, dy, entryType, pidSet, map);
                if (isMulValue.booleanValue() || example.startsWith("[")) {
                    resultMap.put(name, Collections.singletonList(map));
                    continue;
                }
                resultMap.put(name, map);
                continue;
            }
            String name = isBodyColl ? dy.getString(PARAMNAME) : dy.getString(RESPPARAMNAME);
            String string2 = keyStr = isBodyColl ? (String)dy.getLocaleString("example").getDefaultItem() : (String)dy.getLocaleString("respexample").getDefaultItem();
            if (isMulValue.booleanValue()) {
                keyStr = keyStr.contains("[") && keyStr.contains("]") ? keyStr.replace("\"[", "[").replace("]\"", "]") : String.format("[%1s%2s", keyStr, "]");
            }
            Object key = "-".equalsIgnoreCase(example) ? "-" : JSON.parse((String)keyStr);
            resultMap.put(name, key);
        }
    }

    private static Set<String> getPIdSet(DynamicObjectCollection dynamicObjects) {
        HashSet<String> set = new HashSet<String>();
        for (DynamicObject dy : dynamicObjects) {
            set.add(dy.getString("pid"));
        }
        return set;
    }
}

