/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.PathVariableUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PathvariablePluginUtil {
    public static void handlePvUrlformat(IDataModel model, IFormView view, String entityName) {
        String urlformat = (String)model.getValue("urlformat");
        if (PathVariableUtil.isPathVariableUri((String)urlformat)) {
            DynamicObjectCollection bodyEntity = model.getEntryEntity("bodyentryentity");
            for (DynamicObject obj : bodyEntity) {
                String paramtype = obj.getString("paramtype");
                List<String> types = Arrays.asList(DataType.STRING.type(), DataType.INTEGER.type(), DataType.LONG.type(), "int");
                if (!obj.getBoolean("ispathvariable") || types.contains(paramtype)) continue;
                throw new OpenApiException(ApiErrorCode.ERROR, ResManager.loadKDString((String)"\u53c2\u4e0e\u8def\u5f84\u53d8\u91cf\u7684\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u53ea\u80fd\u4e3aString\u3001Long\u3001Integer\u3002", (String)"PathvariablePluginUtil_3", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
            }
            String pvurlformat = PathVariableUtil.getPathVariableFormat((String)urlformat);
            String isNew = view.getPageCache().get("isNew");
            if ("true".equals(isNew)) {
                boolean pvurlformatExists = QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{new QFilter("extentity.ext_value", "=", (Object)pvurlformat)});
                if (pvurlformatExists) {
                    throw new OpenApiException(ApiErrorCode.ERROR, ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u683c\u5f0f\u542b\u8def\u5f84\u53d8\u91cf\u7684\u8bf7\u6c42\u5730\u5740\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PathvariablePluginUtil_0", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
                }
            } else {
                Object pkValue = model.getDataEntity().getPkValue();
                List pvurlformatKeys = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])new QFilter[]{new QFilter("extentity.ext_value", "=", (Object)pvurlformat)}, null, (int)Integer.MAX_VALUE);
                if (CollectionUtil.isNotEmpty((Collection)pvurlformatKeys) && !pvurlformatKeys.contains(pkValue)) {
                    throw new OpenApiException(ApiErrorCode.ERROR, ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u683c\u5f0f\u542b\u8def\u5f84\u53d8\u91cf\u7684\u8bf7\u6c42\u5730\u5740\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PathvariablePluginUtil_0", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
                }
            }
            model.setValue("pvurlformat", (Object)pvurlformat);
        } else {
            model.setValue("pvurlformat", (Object)"");
        }
    }

    public static void checkPvButInvalid(IDataModel model) {
        String number = (String)model.getValue("number");
        if (StringUtil.isEmpty((String)number)) {
            model.setValue("ispathvariable", (Object)false);
            throw new OpenApiException(ApiErrorCode.ERROR, ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7f16\u7801\u3002", (String)"PathvariablePluginUtil_1", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        String paramname = (String)model.getValue("paramname");
        if (StringUtil.isEmpty((String)paramname)) {
            model.setValue("ispathvariable", (Object)false);
            throw new OpenApiException(ApiErrorCode.ERROR, ResManager.loadKDString((String)"\u53c2\u4e0e\u8def\u5f84\u53d8\u91cf\u7684\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PathvariablePluginUtil_2", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        String paramtype = (String)model.getValue("paramtype");
        List<String> types = Arrays.asList(DataType.STRING.type(), DataType.INTEGER.type(), DataType.LONG.type());
        if (!types.contains(paramtype)) {
            model.setValue("ispathvariable", (Object)false);
            throw new OpenApiException(ApiErrorCode.ERROR, ResManager.loadKDString((String)"\u53c2\u4e0e\u8def\u5f84\u53d8\u91cf\u7684\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u53ea\u80fd\u4e3aString\u3001Long\u3001Integer\u3002", (String)"PathvariablePluginUtil_3", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        String bodyLevel = (String)model.getValue("body_level");
        if (!"1".equals(bodyLevel)) {
            model.setValue("ispathvariable", (Object)false);
            throw new OpenApiException(ApiErrorCode.ERROR, ResManager.loadKDString((String)"\u53c2\u4e0e\u8def\u5f84\u53d8\u91cf\u7684\u8bf7\u6c42\u53c2\u6570\u5c42\u7ea7\u53ea\u80fd\u4e3a1\u3002", (String)"PathvariablePluginUtil_4", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
        boolean is_req_mul_value = (Boolean)model.getValue("is_req_mul_value");
        if (is_req_mul_value) {
            model.setValue("ispathvariable", (Object)false);
            throw new OpenApiException(ApiErrorCode.ERROR, ResManager.loadKDString((String)"\u53c2\u4e0e\u8def\u5f84\u53d8\u91cf\u7684\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u591a\u503c\u3002", (String)"PathvariablePluginUtil_5", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
    }

    public static String replaceUrlPathVariableToExample(IDataModel model, String urlformat) {
        DynamicObjectCollection bodyEntity = model.getEntryEntity("bodyentryentity");
        if (!PathVariableUtil.isPathVariableUri((String)urlformat)) {
            return urlformat;
        }
        for (DynamicObject obj : bodyEntity) {
            String paramname = obj.getString("paramname");
            String example = ((String)obj.getLocaleString("example").getDefaultItem()).replace("\"", "");
            String pathvariable = "{" + paramname + "}";
            if (!urlformat.contains(pathvariable)) continue;
            urlformat = urlformat.replace(pathvariable, example);
        }
        return urlformat;
    }

    public static String splicePathVariable(String urlFormat, IDataModel model) {
        StringBuilder builder = new StringBuilder(urlFormat);
        DynamicObjectCollection entryEntity = model.getDataEntity(true).getDynamicObjectCollection("bodyentryentity");
        if (CollectionUtil.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject object : entryEntity) {
                if (!((Boolean)object.get("ispathvariable")).booleanValue()) continue;
                builder.append("/").append("{").append(object.get("paramname")).append("}");
            }
        }
        return builder.toString();
    }
}

