/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.HttpClientOpenUtils;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.StringUtil;

public class WsdlExportUtil {
    private static Log log = LogFactory.getLog(WsdlExportUtil.class);

    public static void checkWebserviceInfo(String nameSpace, String wsInputParam, String wsOutputParam) {
        String message = "";
        if (StringUtil.isEmpty((String)nameSpace)) {
            message = message + ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u547d\u540d\u7a7a\u95f4\u3002", (String)"OpenApiFormPlugin_95", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]);
        }
        if (StringUtil.isEmpty((String)wsInputParam)) {
            message = message + ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u8f93\u5165\u53c2\u6570\u3002", (String)"OpenApiFormPlugin_96", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]);
        }
        if (StringUtil.isEmpty((String)wsOutputParam)) {
            message = message + ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u8f93\u51fa\u53c2\u6570\u3002", (String)"OpenApiFormPlugin_97", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]);
        }
        if (StringUtil.isNotEmpty((String)message)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, message, new Object[0]);
        }
    }

    public static void exportWsdl(IFormView view, String url, String accessToken, String apiNumber) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("access_token", accessToken);
        String result = HttpClientOpenUtils.get((String)url, header, null);
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter(output);){
            writer.write(result);
            ((Writer)writer).flush();
            byte[] bytes = output.toByteArray();
            try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);){
                String fileName = apiNumber + "_" + DateUtil.convertToStr((String)"yyyyMMddHHmmss", (Date)new Date()) + ".xml";
                String fileUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)input, 1800);
                view.openUrl(fileUrl);
            }
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.ERROR, ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"ExportUtil_1", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[]{e.getMessage()}), new Object[0]);
        }
    }
}

