/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util.pdf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.lowagie.text.Chapter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.result.ApiServiceResult;
import kd.bos.openapi.api.util.ApiService;
import kd.bos.openapi.base.custom.CustomApiUtil;
import kd.bos.openapi.common.constant.ApiOperationType;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.constant.HttpMethod;
import kd.bos.openapi.common.constant.Version;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.form.util.ApiPluginUtil;
import kd.bos.openapi.form.util.OpenApiDataPreviewUtil;
import kd.bos.openapi.form.util.OpenApiDataToJsonFormatUtils;
import kd.bos.openapi.form.util.pdf.PdfFontUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.xdb.util.Pair;

public class CreatePdfText {
    private static Log log = LogFactory.getLog(CreatePdfText.class);
    private static final float[] COLUMN_WIDTHS = new float[]{50.0f, 200.0f, 200.0f, 400.0f};
    private static final float[] QUERYCOLUMN_WIDTHS = new float[]{50.0f, 330.0f, 100.0f, 50.0f, 190.0f, 80.0f, 190.0f};
    private static final float[] RESPONSECOLUMN_WIDTHS = new float[]{50.0f, 350.0f, 100.0f, 200.0f, 200.0f};
    private static final float[] ERRORCODECOLUMN_WIDTHS = new float[]{50.0f, 350.0f};
    private static final float[] QUERYCOLUMN_WIDTHS_CUS = new float[]{50.0f, 330.0f, 100.0f, 50.0f, 50.0f, 190.0f, 80.0f, 190.0f};
    private static final float[] RESPONSECOLUMN_WIDTHS_CUS = new float[]{50.0f, 350.0f, 100.0f, 50.0f, 200.0f, 200.0f};
    private static final float FONT_SIZE = 8.0f;
    private static final float HEADER_FONT_SIZE = 10.0f;
    private static final String VERSION = "version";

    public static Document createPdf(String outpath, FileOutputStream fileOutputStream) throws DocumentException {
        Rectangle rect = new Rectangle(PageSize.A4);
        File saveDir = new File(outpath);
        File dir = saveDir.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Document doc = new Document(rect);
        PdfWriter.getInstance((Document)doc, (OutputStream)fileOutputStream);
        doc.setMargins(30.0f, 30.0f, 20.0f, 20.0f);
        doc.open();
        return doc;
    }

    public static void createFile(Document doc, String httpmethod, DynamicObjectCollection headEntity, DynamicObjectCollection getEntity, DynamicObjectCollection postEntity, DynamicObjectCollection responseEntity, DynamicObject api) throws DocumentException {
        int querytableSize;
        getEntity = null != getEntity ? getEntity : postEntity;
        OrmLocaleValue nameMap = (OrmLocaleValue)api.get("name");
        Chapter chapter = PdfFontUtils.setChapter(nameMap == null ? "" : nameMap.get((Object)"zh_CN"), Float.valueOf(25.0f), 1, 1, Float.valueOf(10.0f), Float.valueOf(10.0f));
        doc.add((Element)chapter);
        doc.add((Element)PdfFontUtils.setSectionChapter(chapter, ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"createPdf_0", (String)"bos-open-formplugin", (Object[])new Object[0]), Float.valueOf(20.0f), 1, 3, Float.valueOf(10.0f), Float.valueOf(10.0f)));
        OrmLocaleValue discriptionMap = (OrmLocaleValue)api.get("discription");
        doc.add((Element)PdfFontUtils.getFont(String.format(ResManager.loadKDString((String)"\u7528\u9014\u8bf4\u660e\uff1a%s", (String)"createPdf_1", (String)"bos-open-formplugin", (Object[])new Object[0]), discriptionMap == null ? "" : discriptionMap.getLocaleValue()), Float.valueOf(11.0f), 0, 0, Float.valueOf(5.0f), Float.valueOf(5.0f)));
        StringBuilder httpmethodSB = new StringBuilder(ResManager.loadKDString((String)"\u8bf7\u6c42\u65b9\u5f0f\uff1a", (String)"createPdf_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
        HttpMethod method = HttpMethod.fromCode((String)httpmethod);
        httpmethodSB.append(method != null ? method.getName() : "");
        String urlformat = api.getString("urlformat");
        String finalUrl = RequestContext.get().getClientFullContextPath() + "kapi" + urlformat;
        doc.add((Element)PdfFontUtils.getFont(httpmethodSB.toString(), Float.valueOf(11.0f), 0, 3, Float.valueOf(5.0f), Float.valueOf(5.0f)));
        doc.add((Element)PdfFontUtils.getFont(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u5730\u5740\uff1a%s", (String)"createPdf_3", (String)"bos-open-formplugin", (Object[])new Object[0]), finalUrl), Float.valueOf(11.0f), 0, 0, Float.valueOf(5.0f), Float.valueOf(5.0f)));
        doc.add((Element)PdfFontUtils.setSectionChapter(chapter, ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u90e8", (String)"createPdf_4", (String)"bos-open-formplugin", (Object[])new Object[0]), Float.valueOf(20.0f), 1, 3, Float.valueOf(30.0f), Float.valueOf(10.0f)));
        PdfPTable table = new PdfPTable(4);
        table.getDefaultCell().setBorder(2);
        table.setWidths(COLUMN_WIDTHS);
        table.setWidthPercentage(90.0f);
        table.setHorizontalAlignment(0);
        CreatePdfText.addCellHeader(table, ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"createPdf_5", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        CreatePdfText.addCellHeader(table, ResManager.loadKDString((String)"\u53c2\u6570\u540d\u79f0", (String)"createPdf_6", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        CreatePdfText.addCellHeader(table, ResManager.loadKDString((String)"\u53c2\u6570\u503c", (String)"createPdf_7", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        CreatePdfText.addCellHeader(table, ResManager.loadKDString((String)"\u8bf4\u660e", (String)"createPdf_8", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        boolean isVersionTwoApi = Version.TWO.getVer().equals(api.getString(VERSION));
        if (!isVersionTwoApi || headEntity.size() <= 0) {
            CreatePdfText.addCell(table, String.valueOf(1), 8.0f, false, 1, 1);
            CreatePdfText.addCell(table, "Content-Type", 8.0f);
            CreatePdfText.addCell(table, "application/json", 8.0f);
            CreatePdfText.addCell(table, ResManager.loadKDString((String)"\u5185\u5bb9\u683c\u5f0f", (String)"createPdf_9", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            CreatePdfText.addCell(table, String.valueOf(2), 8.0f, false, 1, 1);
            CreatePdfText.addCell(table, "accesstoken", 8.0f);
            CreatePdfText.addCell(table, ResManager.loadKDString((String)"\u83b7\u53d6\u7684accesstoken\u503c", (String)"createPdf_10", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            CreatePdfText.addCell(table, ResManager.loadKDString((String)"\u8bf7\u6c42\u4ee4\u724c", (String)"createPdf_11", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            if (isVersionTwoApi) {
                CreatePdfText.addCell(table, String.valueOf(3), 8.0f, false, 1, 1);
                CreatePdfText.addCell(table, "Idempotency-Key", 8.0f);
                CreatePdfText.addCell(table, ResManager.loadKDString((String)"\u552f\u4e00\u7684requestId", (String)"createPdf_38", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
                CreatePdfText.addCell(table, ResManager.loadKDString((String)"\u975e\u5fc5\u4f20\u53c2\u6570\uff0c\u9632\u6b62\u63a5\u53e3\u88ab\u91cd\u590d\u8c03\u7528", (String)"createPdf_39", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            }
        } else {
            for (int i = 0; i < headEntity.size(); ++i) {
                CreatePdfText.addCell(table, String.valueOf(i + 1), 8.0f, false, 1, 1);
                CreatePdfText.addCell(table, ((DynamicObject)headEntity.get(i)).getString("headername"), 8.0f);
                CreatePdfText.addCell(table, ((DynamicObject)headEntity.get(i)).getString("headervalue"), 8.0f);
                CreatePdfText.addCell(table, ((DynamicObject)headEntity.get(i)).getString("headerdes"), 8.0f);
            }
        }
        doc.add((Element)table);
        doc.add((Element)PdfFontUtils.getFont(ResManager.loadKDString((String)"\u83b7\u53d6token\u8be6\u89c1:", (String)"createPdf_12", (String)"bos-open-formplugin", (Object[])new Object[0]), Float.valueOf(14.0f), 0, 3, Float.valueOf(10.0f), Float.valueOf(10.0f)));
        doc.add((Element)PdfFontUtils.getFont("https://vip.kingdee.com/article/213309216688450304", Float.valueOf(10.0f), 0, 3, Float.valueOf(10.0f), Float.valueOf(10.0f)));
        doc.add((Element)PdfFontUtils.setSectionChapter(chapter, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u8bf4\u660e", (String)"createPdf_13", (String)"bos-open-formplugin", (Object[])new Object[0]), Float.valueOf(20.0f), 1, 3, Float.valueOf(30.0f), Float.valueOf(10.0f)));
        int apiservicetype = api.getInt("apiservicetype");
        int n = querytableSize = ApiServiceType.CUSTOM.ordinal() == apiservicetype || ApiServiceType.SCRIPT.ordinal() == apiservicetype ? 8 : 7;
        if (!isVersionTwoApi) {
            querytableSize = 8;
        }
        PdfPTable querytable = new PdfPTable(querytableSize);
        querytable.getDefaultCell().setBorder(2);
        querytable.setWidths(querytableSize == 7 ? QUERYCOLUMN_WIDTHS : QUERYCOLUMN_WIDTHS_CUS);
        querytable.setWidthPercentage(90.0f);
        querytable.setHorizontalAlignment(0);
        CreatePdfText.addCellHeader(querytable, ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"createPdf_5", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        CreatePdfText.addCellHeader(querytable, ResManager.loadKDString((String)"\u53c2\u6570\u540d\u79f0", (String)"createPdf_6", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        CreatePdfText.addCellHeader(querytable, ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b", (String)"createPdf_14", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        if (!isVersionTwoApi || ApiServiceType.CUSTOM.ordinal() == apiservicetype || ApiServiceType.SCRIPT.ordinal() == apiservicetype) {
            CreatePdfText.addCellHeader(querytable, ResManager.loadKDString((String)"\u591a\u503c", (String)"createPdf_35", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        }
        CreatePdfText.addCellHeader(querytable, ResManager.loadKDString((String)"\u5fc5\u586b", (String)"createPdf_15", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        CreatePdfText.addCellHeader(querytable, ResManager.loadKDString((String)"\u8bf4\u660e", (String)"createPdf_8", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        CreatePdfText.addCellHeader(querytable, ResManager.loadKDString((String)"\u5019\u9009\u952e", (String)"createPdf_16", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        CreatePdfText.addCellHeader(querytable, ResManager.loadKDString((String)"\u793a\u4f8b", (String)"createPdf_17", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        if (!isVersionTwoApi) {
            if ("0".equals(httpmethod)) {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"open_apiservice_new", (QFilter[])new QFilter[]{new QFilter("id", "=", api.getPkValue())});
                getEntity = object.getDynamicObjectCollection("urlparamentryentity");
            } else {
                DynamicObjectCollection finalPostEntity = postEntity = api.getDynamicObjectCollection("bodyentryentity");
                postEntity.forEach(it -> it.set("body_level", (Object)CreatePdfText.getLevel(finalPostEntity, it.getLong("id"))));
            }
        }
        if (!getEntity.isEmpty()) {
            if (isVersionTwoApi || "1".equals(httpmethod)) {
                Map<String, List<DynamicObject>> pidMap = getEntity.stream().collect(Collectors.groupingBy(it -> it.getString("pid")));
                CreatePdfText.setPdfParamRow(querytable, 1, "0", pidMap, "bodyentryentity", ApiServiceType.OPERATION.ordinal() == api.getInt("apiservicetype") && ApiOperationType.QUERY.getOp().equalsIgnoreCase(api.getString("operation")), isVersionTwoApi);
            } else {
                ArrayList<DynamicObject> bodyList = new ArrayList<DynamicObject>((Collection<DynamicObject>)getEntity);
                CreatePdfText.setPdfParamRow(querytable, bodyList);
            }
            doc.add((Element)querytable);
            if ("1".equals(httpmethod)) {
                String jsonData;
                doc.add((Element)PdfFontUtils.setSectionChapter(chapter, ResManager.loadKDString((String)"\u8bf7\u6c42\u7ed3\u6784\u793a\u4f8b", (String)"createPdf_18", (String)"bos-open-formplugin", (Object[])new Object[0]), Float.valueOf(20.0f), 1, 3, Float.valueOf(30.0f), Float.valueOf(10.0f)));
                if (ApiServiceType.OPERATION.ordinal() == api.getInt("apiservicetype") || !isVersionTwoApi && ApiServiceType.CUSTOM.ordinal() == api.getInt("apiservicetype")) {
                    Map<String, Object> resultData = OpenApiDataToJsonFormatUtils.getResultData(postEntity, "paramtype", "paramname", "example");
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("data", resultData);
                    if (isVersionTwoApi && ApiOperationType.QUERY.getOp().equalsIgnoreCase(api.getString("operation"))) {
                        map.put("pageSize", 10);
                        map.put("pageNo", 1);
                    }
                    if (isVersionTwoApi && ApiOperationType.SAVE.getOp().equalsIgnoreCase(api.getString("operation"))) {
                        map.put("data", Collections.singletonList(resultData));
                    }
                    jsonData = JSON.toJSONString(isVersionTwoApi ? map : resultData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.DisableCircularReferenceDetect}).replaceAll("\t", "    ");
                } else if (ApiServiceType.CUSTOM.ordinal() == api.getInt("apiservicetype")) {
                    Map<String, Object> map = OpenApiDataToJsonFormatUtils.transferToMap(postEntity, "bodyentryentity");
                    jsonData = JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}).replaceAll("\t", "    ");
                } else {
                    DynamicObjectCollection bodyentryentity = api.getDynamicObjectCollection("bodyentryentity");
                    Object resultObj = CustomApiUtil.getCustomParams((String)"bodyentryentity", (DynamicObjectCollection)bodyentryentity);
                    jsonData = JSON.toJSONString((Object)resultObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}).replaceAll("\t", "    ");
                }
                doc.add((Element)PdfFontUtils.getFont(jsonData, Float.valueOf(10.0f), 0, 3, Float.valueOf(5.0f), Float.valueOf(10.0f)));
            }
        }
        doc.add((Element)PdfFontUtils.setSectionChapter(chapter, ResManager.loadKDString((String)"\u8fd4\u56de\u53c2\u6570\u8bf4\u660e", (String)"createPdf_19", (String)"bos-open-formplugin", (Object[])new Object[0]), Float.valueOf(20.0f), 1, 3, Float.valueOf(30.0f), Float.valueOf(10.0f)));
        int responsetableSize = ApiServiceType.CUSTOM.ordinal() == apiservicetype || ApiServiceType.SCRIPT.ordinal() == apiservicetype ? 6 : 5;
        PdfPTable responsetable = new PdfPTable(responsetableSize);
        responsetable.getDefaultCell().setBorder(2);
        responsetable.setWidths(responsetableSize == 5 ? RESPONSECOLUMN_WIDTHS : RESPONSECOLUMN_WIDTHS_CUS);
        responsetable.setWidthPercentage(90.0f);
        responsetable.setHorizontalAlignment(0);
        CreatePdfText.addCellHeader(responsetable, ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"createPdf_5", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        CreatePdfText.addCellHeader(responsetable, ResManager.loadKDString((String)"\u53c2\u6570\u540d\u79f0", (String)"createPdf_6", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        CreatePdfText.addCellHeader(responsetable, ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b", (String)"createPdf_14", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        if (ApiServiceType.CUSTOM.ordinal() == apiservicetype || ApiServiceType.SCRIPT.ordinal() == apiservicetype) {
            CreatePdfText.addCellHeader(responsetable, ResManager.loadKDString((String)"\u591a\u503c", (String)"createPdf_35", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        }
        CreatePdfText.addCellHeader(responsetable, ResManager.loadKDString((String)"\u8bf4\u660e", (String)"createPdf_8", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        CreatePdfText.addCellHeader(responsetable, ResManager.loadKDString((String)"\u793a\u4f8b", (String)"createPdf_17", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
        if (!responseEntity.isEmpty()) {
            Map<String, List<DynamicObject>> pidMap;
            if (!isVersionTwoApi) {
                responseEntity.forEach(it -> it.set("resp_level", (Object)CreatePdfText.getLevel(responseEntity, it.getLong("id"))));
                pidMap = responseEntity.stream().collect(Collectors.groupingBy(it -> it.getString("pid")));
            } else if (ApiServiceType.OPERATION.ordinal() == api.getInt("apiservicetype") && !ApiOperationType.QUERY.getOp().equalsIgnoreCase(api.getString("operation"))) {
                DynamicObjectCollection respentry = ApiPluginUtil.buildQueryEntryData("query", responseEntity);
                pidMap = respentry.stream().collect(Collectors.groupingBy(it -> it.getString("pid")));
            } else {
                pidMap = responseEntity.stream().collect(Collectors.groupingBy(it -> it.getString("pid")));
            }
            CreatePdfText.setPdfParamRow(responsetable, 1, "0", pidMap, "respentryentity", false, true);
        }
        if (ApiServiceType.OPERATION.ordinal() == api.getInt("apiservicetype") && Version.TWO.getVer().equals(api.getString(VERSION)) && !ApiOperationType.QUERY.getOp().equalsIgnoreCase(api.getString("operation"))) {
            int num = 1;
            CreatePdfText.addCell(responsetable, String.valueOf(num++), 8.0f);
            CreatePdfText.addCell(responsetable, "status", 8.0f);
            CreatePdfText.addCell(responsetable, "Boolean", 8.0f);
            CreatePdfText.addCell(responsetable, ResManager.loadKDString((String)"\u63a5\u53e3\u8bbf\u95ee\u662f\u5426\u6210\u529f", (String)"createPdf_20", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            CreatePdfText.addCell(responsetable, "true/false", 8.0f);
            CreatePdfText.addCell(responsetable, String.valueOf(num++), 8.0f);
            CreatePdfText.addCell(responsetable, "errorCode", 8.0f);
            CreatePdfText.addCell(responsetable, "String", 8.0f);
            CreatePdfText.addCell(responsetable, ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"createPdf_21", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            CreatePdfText.addCell(responsetable, ResManager.loadKDString((String)"\u6210\u529f\u65f6\u4e3a0\uff0c\u5931\u8d25\u65f6\u8fd4\u56de\u9519\u8bef\u7801\u5982400", (String)"createPdf_22", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            CreatePdfText.addCell(responsetable, String.valueOf(num++), 8.0f);
            CreatePdfText.addCell(responsetable, "message", 8.0f);
            CreatePdfText.addCell(responsetable, "String", 8.0f);
            CreatePdfText.addCell(responsetable, ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u9519\u8bef\u4fe1\u606f", (String)"createPdf_23", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            CreatePdfText.addCell(responsetable, ResManager.loadKDString((String)"\u6210\u529f\u65f6\u4e3a\u7a7a\uff0c\u5931\u8d25\u65f6\u8fd4\u56de\u9519\u8bef\u4fe1\u606f", (String)"createPdf_24", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            CreatePdfText.addCell(responsetable, String.valueOf(num++), 8.0f);
            CreatePdfText.addCell(responsetable, "data", 8.0f);
            CreatePdfText.addCell(responsetable, "Object", 8.0f);
            CreatePdfText.addCell(responsetable, ResManager.loadKDString((String)"\u7ed3\u679c\u6570\u636e", (String)"createPdf_25", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            CreatePdfText.addCell(responsetable, "", 8.0f);
            if (!ApiOperationType.SAVE.getOp().equalsIgnoreCase(api.getString("operation"))) {
                CreatePdfText.addCell(responsetable, String.valueOf(num++), 8.0f);
                CreatePdfText.addCell(responsetable, "  \u251cfilter", 8.0f);
                CreatePdfText.addCell(responsetable, "String", 8.0f);
                CreatePdfText.addCell(responsetable, ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6", (String)"createPdf_26", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
                CreatePdfText.addCell(responsetable, ResManager.loadKDString((String)"\u64cd\u4f5c\u6267\u884c\u7684\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5982\uff1abillno in ('CGSQ-220228-000258','CGSQ-220228-000259')", (String)"createPdf_27", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
                CreatePdfText.addCell(responsetable, String.valueOf(num++), 8.0f);
                CreatePdfText.addCell(responsetable, "  \u251ctotalCount", 8.0f);
                CreatePdfText.addCell(responsetable, "int", 8.0f);
                CreatePdfText.addCell(responsetable, ResManager.loadKDString((String)"\u603b\u6570", (String)"createPdf_28", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
                CreatePdfText.addCell(responsetable, "2", 8.0f);
            }
            CreatePdfText.addCell(responsetable, String.valueOf(num++), 8.0f);
            CreatePdfText.addCell(responsetable, "  \u251csuccessCount", 8.0f);
            CreatePdfText.addCell(responsetable, "int", 8.0f);
            CreatePdfText.addCell(responsetable, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u6570\u91cf", (String)"createPdf_29", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            CreatePdfText.addCell(responsetable, "2", 8.0f);
            CreatePdfText.addCell(responsetable, String.valueOf(num++), 8.0f);
            CreatePdfText.addCell(responsetable, "  \u251cfailCount", 8.0f);
            CreatePdfText.addCell(responsetable, "int", 8.0f);
            CreatePdfText.addCell(responsetable, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u6570\u91cf", (String)"createPdf_30", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            CreatePdfText.addCell(responsetable, "2", 8.0f);
            CreatePdfText.addCell(responsetable, String.valueOf(num++), 8.0f);
            CreatePdfText.addCell(responsetable, "  \u2514result", 8.0f);
            CreatePdfText.addCell(responsetable, "Array", 8.0f);
            CreatePdfText.addCell(responsetable, ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c", (String)"createPdf_31", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            CreatePdfText.addCell(responsetable, "[]", 8.0f);
        }
        doc.add((Element)responsetable);
        doc.add((Element)PdfFontUtils.setSectionChapter(chapter, ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u6784\u793a\u4f8b", (String)"createPdf_32", (String)"bos-open-formplugin", (Object[])new Object[0]), Float.valueOf(20.0f), 1, 3, Float.valueOf(30.0f), Float.valueOf(10.0f)));
        if (!isVersionTwoApi) {
            Map<String, Object> resultData = OpenApiDataToJsonFormatUtils.getResultData(responseEntity, "respparamtype", "respparamname", "respexample");
            String json = JSON.toJSONString(resultData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}).replaceAll("\t", "    ");
            doc.add((Element)PdfFontUtils.getFont(json, Float.valueOf(10.0f), 0, 3, Float.valueOf(5.0f), Float.valueOf(10.0f)));
        } else if (ApiServiceType.OPERATION.ordinal() == api.getInt("apiservicetype")) {
            String json;
            if (!"query".equals(api.getString("operation"))) {
                ApiServiceResult data = ApiService.getTypeByOp((String)api.getString("operation")).getResultType();
                OpenApiResult openApiResult = OpenApiResult.builder().success((Object)data);
                json = JSON.toJSONString((Object)openApiResult, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}).replaceAll("\t", "    ");
            } else {
                Pair<Map<String, Object>, Boolean> result = OpenApiDataPreviewUtil.getDataPair("", "respentryentity", responseEntity, api.getString("operation"), api.getInt("httpmethod"));
                json = JSON.toJSONString((Object)result.getKey(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}).replaceAll("\t", "    ");
            }
            doc.add((Element)PdfFontUtils.getFont(json, Float.valueOf(10.0f), 0, 3, Float.valueOf(5.0f), Float.valueOf(10.0f)));
        } else if (ApiServiceType.CUSTOM.ordinal() == api.getInt("apiservicetype")) {
            Map<String, Object> responseMap = OpenApiDataToJsonFormatUtils.transferToMap(responseEntity, "respentryentity");
            String responseJson = JSON.toJSONString(responseMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}).replaceAll("\t", "    ");
            doc.add((Element)PdfFontUtils.getFont(responseJson, Float.valueOf(10.0f), 0, 3, Float.valueOf(5.0f), Float.valueOf(10.0f)));
        } else {
            DynamicObjectCollection respentryentity = api.getDynamicObjectCollection("respentryentity");
            Object resultObj = CustomApiUtil.getCustomParams((String)"respentryentity", (DynamicObjectCollection)respentryentity);
            OpenApiResult result = new OpenApiResult();
            result.setData(resultObj);
            result.setErrorCode("0");
            result.setMessage("");
            String responseJson = JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}).replaceAll("\t", "    ");
            doc.add((Element)PdfFontUtils.getFont(responseJson, Float.valueOf(10.0f), 0, 3, Float.valueOf(5.0f), Float.valueOf(10.0f)));
        }
        if (Version.TWO.getVer().equals(api.getString(VERSION))) {
            doc.add((Element)PdfFontUtils.setSectionChapter(chapter, ResManager.loadKDString((String)"\u9519\u8bef\u7801\u89e3\u91ca", (String)"createPdf_33", (String)"bos-open-formplugin", (Object[])new Object[0]), Float.valueOf(20.0f), 1, 3, Float.valueOf(30.0f), Float.valueOf(10.0f)));
            PdfPTable errorCodeTable = new PdfPTable(2);
            errorCodeTable.getDefaultCell().setBorder(2);
            errorCodeTable.setWidths(ERRORCODECOLUMN_WIDTHS);
            errorCodeTable.setWidthPercentage(90.0f);
            errorCodeTable.setHorizontalAlignment(0);
            CreatePdfText.addCellHeader(errorCodeTable, ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"createPdf_21", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
            CreatePdfText.addCellHeader(errorCodeTable, ResManager.loadKDString((String)"\u9519\u8bef\u6d88\u606f", (String)"createPdf_34", (String)"bos-open-formplugin", (Object[])new Object[0]), 10.0f);
            if (CollectionUtil.isNotEmpty((Collection)api.getDynamicObjectCollection("errorcodeentity"))) {
                api.getDynamicObjectCollection("errorcodeentity").stream().forEach(it -> {
                    CreatePdfText.addCell(errorCodeTable, it.getString("errorcode"), 8.0f, false, 1, 1);
                    CreatePdfText.addCell(errorCodeTable, it.getString("errorcodedesc"), 8.0f, false, 1, 1);
                });
                doc.add((Element)errorCodeTable);
            }
        }
    }

    private static void addCellHeader(PdfPTable table, String text, float size) {
        CreatePdfText.addCell(table, text, size, true, 1, 1);
    }

    private static void addCell(PdfPTable table, String text, float size) {
        CreatePdfText.addCell(table, text, size, false, 0, 1);
    }

    private static void addCell(PdfPTable table, String text, float size, boolean bgColor, int horizontalAlignment, int verticalAlignment) {
        PdfPCell cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(text, Float.valueOf(size), 0, 3, Float.valueOf(5.0f), Float.valueOf(5.0f))));
        cell.setColspan(1);
        cell.setHorizontalAlignment(horizontalAlignment);
        cell.setVerticalAlignment(verticalAlignment);
        if (bgColor) {
            cell.setBackgroundColor(new Color(211, 211, 211));
        }
        table.addCell(cell);
    }

    private static int setPdfParamRow(PdfPTable querytable, int preLevel, String pid, Map<String, List<DynamicObject>> pidMap, String entryKey, boolean isOpQueryApi, boolean isVersionTwoApi) {
        List<DynamicObject> list = pidMap.get(pid);
        if (CollectionUtil.isEmpty(list)) {
            return preLevel;
        }
        for (int i = 0; i < list.size(); ++i) {
            CreatePdfText.addCell(querytable, String.valueOf(preLevel++), 8.0f, false, 1, 1);
            DynamicObject entry = list.get(i);
            String levelName = "bodyentryentity".equals(entryKey) ? "body_level" : "resp_level";
            int level = entry.getInt(levelName);
            String prefix = CreatePdfText.getPrefix(level, list.size() == i + 1);
            String paramName = "bodyentryentity".equals(entryKey) ? "paramname" : "respparamname";
            String paramValue = prefix + (entry.get(paramName) == null ? "" : (String)entry.get(paramName));
            CreatePdfText.addCell(querytable, paramValue, 8.0f);
            String paramTypeName = "bodyentryentity".equals(entryKey) ? "paramtype" : "respparamtype";
            String paramType = (String)entry.get(paramTypeName);
            CreatePdfText.addCell(querytable, paramType, 8.0f);
            if ("bodyentryentity".equals(entryKey) && querytable.getNumberOfColumns() == 8 || !"bodyentryentity".equals(entryKey) && querytable.getNumberOfColumns() == 6) {
                String is_mul_value = "bodyentryentity".equals(entryKey) ? "is_req_mul_value" : "is_resp_mul_value";
                String mulValue = entry.getBoolean(is_mul_value) ? "Y" : "";
                CreatePdfText.addCell(querytable, mulValue, 8.0f);
            }
            if ("bodyentryentity".equals(entryKey)) {
                String mustFill = "1".equals(entry.get("must")) ? "Y" : "";
                CreatePdfText.addCell(querytable, mustFill, 8.0f, false, 1, 1);
            }
            String desc = "bodyentryentity".equals(entryKey) ? "bodyparamdes" : "respdes";
            CreatePdfText.addCell(querytable, entry.getString(desc), 8.0f);
            if ("bodyentryentity".equals(entryKey)) {
                String is_unique_key = entry.getBoolean("is_unique_key") ? "Y" : "";
                CreatePdfText.addCell(querytable, is_unique_key, 8.0f, false, 1, 1);
            }
            String example = "bodyentryentity".equals(entryKey) ? "example" : "respexample";
            CreatePdfText.addCell(querytable, entry.getString(example), 8.0f);
            if (!pidMap.containsKey(entry.getString("id"))) continue;
            preLevel = CreatePdfText.setPdfParamRow(querytable, preLevel, entry.getString("id"), pidMap, entryKey, false, isVersionTwoApi);
        }
        if (isVersionTwoApi && "bodyentryentity".equals(entryKey) && isOpQueryApi) {
            CreatePdfText.addPageParamCell(querytable, entryKey, preLevel);
        }
        return preLevel;
    }

    private static void setPdfParamRow(PdfPTable querytable, List<DynamicObject> bodyList) {
        if (CollectionUtil.isEmpty(bodyList)) {
            return;
        }
        int preLevel = 1;
        for (int i = 0; i < bodyList.size(); ++i) {
            CreatePdfText.addCell(querytable, String.valueOf(preLevel++), 8.0f, false, 1, 1);
            DynamicObject entry = bodyList.get(i);
            int level = 1;
            String prefix = CreatePdfText.getPrefix(level, bodyList.size() == i + 1);
            String paramName = "urlparamname";
            String paramValue = prefix + (entry.get(paramName) == null ? "" : (String)entry.get(paramName));
            CreatePdfText.addCell(querytable, paramValue, 8.0f);
            String paramTypeName = "urlparamtype";
            String paramType = (String)entry.get(paramTypeName);
            CreatePdfText.addCell(querytable, paramType, 8.0f);
            CreatePdfText.addCell(querytable, "", 8.0f, false, 1, 1);
            String mustFill = "1".equals(entry.get("urlparammust")) ? "Y" : "";
            CreatePdfText.addCell(querytable, mustFill, 8.0f, false, 1, 1);
            String desc = "urlparamdes";
            CreatePdfText.addCell(querytable, entry.getString(desc), 8.0f);
            CreatePdfText.addCell(querytable, "", 8.0f, false, 1, 1);
            String example = "urlparamdes";
            CreatePdfText.addCell(querytable, entry.getString(example), 8.0f);
        }
    }

    private static String getPrefix(int currLevel, boolean isLast) {
        if (currLevel == 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < currLevel - 1; ++i) {
            sb.append("   ");
        }
        if (isLast) {
            sb.append('\u2514');
        } else {
            sb.append('\u251c');
        }
        sb.append(' ');
        return sb.toString();
    }

    private static int getLevel(DynamicObjectCollection responseEntity, Long id) {
        int level = 1;
        HashMap map = new HashMap();
        responseEntity.stream().forEach(it -> map.put(it.getLong("id"), it.getLong("pid")));
        Long temp = id;
        while ((Long)map.get(temp) != 0L) {
            ++level;
            temp = (Long)map.get(temp);
        }
        return level;
    }

    private static void addPageParamCell(PdfPTable querytable, String entryKey, int preLevel) {
        if ("bodyentryentity".equals(entryKey)) {
            CreatePdfText.addCell(querytable, String.valueOf(preLevel++), 8.0f, false, 1, 1);
            CreatePdfText.addCell(querytable, "pageSize", 8.0f);
            CreatePdfText.addCell(querytable, DataType.INTEGER.type(), 8.0f);
            CreatePdfText.addCell(querytable, "Y", 8.0f, false, 1, 1);
            CreatePdfText.addCell(querytable, ResManager.loadKDString((String)"\u5206\u9875\u53c2\u6570\uff0c\u5206\u9875\u6570\u91cf", (String)"createPdf_36", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            CreatePdfText.addCell(querytable, "", 8.0f, false, 1, 1);
            CreatePdfText.addCell(querytable, "10", 8.0f);
            CreatePdfText.addCell(querytable, String.valueOf(preLevel), 8.0f, false, 1, 1);
            CreatePdfText.addCell(querytable, "pageNo", 8.0f);
            CreatePdfText.addCell(querytable, DataType.INTEGER.type(), 8.0f);
            CreatePdfText.addCell(querytable, "", 8.0f, false, 1, 1);
            CreatePdfText.addCell(querytable, ResManager.loadKDString((String)"\u5206\u9875\u53c2\u6570\uff0c\u67e5\u8be2\u9875\u7801", (String)"createPdf_37", (String)"bos-open-formplugin", (Object[])new Object[0]), 8.0f);
            CreatePdfText.addCell(querytable, "", 8.0f, false, 1, 1);
            CreatePdfText.addCell(querytable, "1", 8.0f);
        }
    }
}

