/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.util.pdf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.form.util.ExportUtil;

public class ExportAndDownloadUtil {
    private static Log logger = LogFactory.getLog(ExportAndDownloadUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void download(IFormView view, String fp, String fileName, boolean isBindPriorityItem) throws Exception {
        boolean var11;
        block11: {
            FileInputStream in = null;
            var11 = false;
            try {
                in = new FileInputStream(fp);
                String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 1800);
                String oneTimeUrl = ExportUtil.genCustomAttachUrl(urls, isBindPriorityItem);
                view.openUrl(oneTimeUrl);
                var11 = true;
                if (in == null) break block11;
            }
            catch (IOException ioe) {
                try {
                    throw new Exception(String.format(ResManager.loadKDString((String)"\u4ece%1$s\u5730\u5740\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff01", (String)"ExportAndDownloadUtil_0", (String)"bos-open-formplugin", (Object[])new Object[0]), ioe), ioe);
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException var12) {
                            logger.debug("export failed", (Object)var12);
                        }
                    }
                    if (!var11) throw throwable;
                    boolean deleted2 = ExportAndDownloadUtil.delete(fp);
                    if (deleted2) {
                        logger.debug(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664\u7f13\u5b58\u6587\u4ef6%1$s,\u5f53\u524d\u65f6\u95f4\uff1a%2$s", (String)"ExportAndDownloadUtil_1", (String)"bos-open-formplugin", (Object[])new Object[0]), fp, LocalDate.now()));
                        throw throwable;
                    }
                    logger.debug(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u5220\u9664\u7f13\u5b58\u6587\u4ef6%1$s,\u5f53\u524d\u65f6\u95f4\uff1a%2$s", (String)"ExportAndDownloadUtil_2", (String)"bos-open-formplugin", (Object[])new Object[0]), fp, LocalDate.now()));
                    throw throwable;
                }
            }
            try {
                in.close();
            }
            catch (IOException var12) {
                logger.debug("export failed", (Object)var12);
            }
        }
        if (!var11) return;
        boolean deleted = ExportAndDownloadUtil.delete(fp);
        if (deleted) {
            logger.debug(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664\u7f13\u5b58\u6587\u4ef6%1$s,\u5f53\u524d\u65f6\u95f4\uff1a%2$s", (String)"ExportAndDownloadUtil_1", (String)"bos-open-formplugin", (Object[])new Object[0]), fp, LocalDate.now()));
            return;
        }
        logger.debug(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u5220\u9664\u7f13\u5b58\u6587\u4ef6%1$s,\u5f53\u524d\u65f6\u95f4\uff1a%2$s", (String)"ExportAndDownloadUtil_2", (String)"bos-open-formplugin", (Object[])new Object[0]), fp, LocalDate.now()));
    }

    public static void download(IFormView view, String fp, String fileName) throws Exception {
        ExportAndDownloadUtil.download(view, fp, fileName, false);
    }

    public static synchronized boolean delete(String fp) {
        if (fp == null) {
            return false;
        }
        File file = new File(fp);
        boolean result = false;
        if (file.listFiles() == null) {
            result = file.delete();
        }
        if (!result) {
            logger.debug("delete " + fp + "failed!");
        }
        return result;
    }
}

