/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.auth.filter.impl;

import java.util.Base64;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.auth.filter.AuthFilter;
import kd.bos.auth.filter.HandleResult;
import kd.bos.auth.filter.impl.AbstractCommonFilter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.ApiDataUtil;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiAuthContext;
import kd.bos.openapi.kcf.result.ResultProcessUtil;
import kd.bos.openapi.kcf.spi.OpenApiServiceManager;
import kd.bos.openapi.kcf.utils.ApiAuthLogUtil;
import kd.bos.openapi.kcf.utils.OpenApiExceptionUtil;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;
import kd.bos.service.authorize.model.JwtInfo;

public class OAuth2Filter
extends AbstractCommonFilter
implements AuthFilter {
    private static final Log log = LogFactory.getLog(OAuth2Filter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleResult<ApiCommonResult> doFilter(HttpServletRequest request, HttpServletResponse response) {
        long timeST = System.currentTimeMillis();
        String authUrl = ApiDataUtil.getApiUrl((HttpServletRequest)request);
        try {
            AuthResult authResult;
            Map<String, String> tokenInfo = OpenApiAuthContext.getContext().getTokenInfo();
            String authType = OpenApiAuthContext.getContext().getAuthType();
            if (!"1".equals(authType) && !"3".equals(authType)) {
                HandleResult<ApiCommonResult> result = HandleResult.getHandleResult(null);
                result.setHandled(false);
                HandleResult<ApiCommonResult> handleResult = result;
                return handleResult;
            }
            AuthInfo authInfo = new AuthInfo();
            String jwt = tokenInfo.get("jwt");
            String token = tokenInfo.get("access_token");
            authInfo.setAccessToken(token);
            String accountId = OpenApiAuthContext.getContext().getCurrentCenter().getAccountId();
            authInfo.setAccountId(accountId);
            authInfo.setAuthType(authType);
            boolean isNewAuth = "1".equals(tokenInfo.get("isNewTokenAuth"));
            log.info("OAuth2Filter isNewAuth:" + isNewAuth);
            if (!isNewAuth) {
                HandleResult<ApiCommonResult> handleResult = HandleResult.getHandleResult(ApiCommonResult.getFailResult((String)"905", (String)ResManager.loadKDString((String)"\u65e7\u8ba4\u8bc1\u3002", (String)"OAuth2Filter_1", (String)ResSystemType.KCF.getType(), (Object[])new Object[0])));
                return handleResult;
            }
            String clientId = OpenApiAuthContext.getContext().getHeaders().get("client_id");
            authInfo.setThirdAppNumber(clientId);
            if ("3".equals(authType)) {
                JwtInfo jwtInfo = new JwtInfo();
                String realJwtToken = "";
                try {
                    String oldTokenBase = jwt.substring("OPENAPIAUTH_".length());
                    realJwtToken = new String(Base64.getUrlDecoder().decode(oldTokenBase));
                }
                catch (Exception e) {
                    throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, ResManager.loadKDString((String)"AccessToken\u8ba4\u8bc1\u672a\u901a\u8fc7\u3002", (String)"OAuth2Filter_2", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
                }
                jwtInfo.setJwt(realJwtToken);
                jwtInfo.setAccountId(accountId);
                jwtInfo.setThirdAppNumber(clientId);
                authInfo.setJwtInfo(jwtInfo);
            }
            if (!(authResult = OpenApiServiceManager.getOpenApiAuthService().auth(authInfo)).isStatus()) {
                String message = StringUtil.isEmpty((String)authResult.getMessage()) ? ResManager.loadKDString((String)"AccessToken\u8ba4\u8bc1\u672a\u901a\u8fc7\u3002", (String)"OAuth2Filter_2", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]) : authResult.getMessage();
                throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, message, new Object[0]);
            }
            ApiCommonResult resultApiCommonResult = ApiCommonResult.getSuccessResult((String)"0", (String)ResManager.loadKDString((String)"AccessToken\u8ba4\u8bc1\u901a\u8fc7\u3002", (String)"OAuth2Filter_3", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]));
            resultApiCommonResult.setData((Object)authResult);
            ((AuthResult)resultApiCommonResult.getData()).setAccountId(OpenApiAuthContext.getContext().getCurrentCenter().getAccountId());
            if (McConfigUtil.isSecurityLogOpen((String)RequestContext.get().getTenantId())) {
                log.info("OAuth2 pass.");
            }
            HandleResult<ApiCommonResult> handleResult = HandleResult.getHandleResult(resultApiCommonResult);
            return handleResult;
        }
        catch (Throwable e) {
            String msg = "----OAuth2 OpenApi Auth Failed. error:" + e.getMessage();
            log.error(msg, e);
            ApiCommonResult result = ApiCommonResult.getFailResult((String)ApiErrorCode.HTTP_BAD_REQUEST.getStatusCode(), (String)msg);
            OpenApiExceptionUtil.handleAuthException(e, response, result);
            ResultProcessUtil.processAuthResult(request, response, result);
            HandleResult<ApiCommonResult> handleResult = HandleResult.getHandleResult(result);
            return handleResult;
        }
        finally {
            int timeCost = (int)(System.currentTimeMillis() - timeST);
            if (OpenApiAuthContext.getContext().isParamErrorCode()) {
                ApiAuthLogUtil.writeAuthApiLog(authUrl, timeCost);
            }
        }
    }
}

