/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.auth.filter.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.auth.filter.AuthFilter;
import kd.bos.auth.filter.HandleResult;
import kd.bos.auth.filter.impl.AbstractCommonFilter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.model.OpenApiResponse;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.AuthExtendException;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.ApiDataUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiAuthContext;
import kd.bos.openapi.kcf.result.ResultProcessUtil;
import kd.bos.openapi.kcf.spi.OpenApiServiceManager;
import kd.bos.openapi.kcf.utils.ApiAuthLogUtil;
import kd.bos.openapi.kcf.utils.ApiPluginRpcHelper;
import kd.bos.openapi.kcf.utils.OpenApiExceptionUtil;
import kd.bos.openapi.kcf.utils.OpenApiPluginUtil;
import kd.bos.openapi.security.model.ApiIpInfoDto;
import kd.bos.openapi.security.model.Open3rdappsDto;
import kd.bos.service.authorize.http.KDSignHttpServletRequestWrapper;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.authorize.model.AuthInfo;
import kd.bos.service.authorize.model.AuthResult;

public class OpenAuthExtendFilter
extends AbstractCommonFilter
implements AuthFilter {
    private static final Log log = LogFactory.getLog(OpenAuthExtendFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleResult<ApiCommonResult> doFilter(HttpServletRequest request, HttpServletResponse response) {
        long timeST = System.currentTimeMillis();
        String authUrl = ApiDataUtil.getApiUrl((HttpServletRequest)request);
        try {
            String authType = OpenApiAuthContext.getContext().getAuthType();
            if (!"6".equals(authType)) {
                HandleResult<ApiCommonResult> result = HandleResult.getHandleResult(null);
                result.setHandled(false);
                HandleResult<ApiCommonResult> handleResult = result;
                return handleResult;
            }
            String accountId = OpenApiAuthContext.getContext().getCurrentCenter().getAccountId();
            String clientId = this.getParamsFromHeaderAndQuery("client_id");
            if (StringUtil.isEmpty((String)clientId)) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: %1$s\u4e3a\u7a7a\u3002", (String)"OauthTokenUtil_1", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), "clientId"), new Object[0]);
            }
            String userName = this.getParamsFromHeaderAndQuery("username");
            if (StringUtil.isEmpty((String)userName)) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff1ausername\u4e3a\u7a7a\u3002", (String)"ApiTokenServiceImpl_15", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
            }
            Map userInfo = OpenApiServiceManager.getOpenApiAuthService().getUserInfoByUserName(userName);
            if (userInfo == null || userInfo.get("fid") == null) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef\uff1ausername\uff1a\u7528\u6237\u65e0\u6548\u6216\u4e0d\u53ef\u7528\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"ApiTokenServiceImpl_16", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), userName), new Object[0]);
            }
            Long agentUserId = Long.parseLong((String)userInfo.get("fid"));
            Open3rdappsDto open3rdappsDto = OpenApiServiceManager.getOpenApiAuthService().getThirdAppDtoByNum(clientId, accountId);
            if (open3rdappsDto == null || open3rdappsDto.getFid() == null || open3rdappsDto.getFid() == 0L) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: \u7b2c\u4e09\u65b9\u5e94\u7528clientId\uff1a %1$s\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\u3002", (String)"OauthTokenUtil_3", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), clientId), new Object[0]);
            }
            if (open3rdappsDto.isEnableAgency() && (CollectionUtil.isEmpty((Collection)open3rdappsDto.getAgentUserIdList()) || !open3rdappsDto.getAgentUserIdList().contains(agentUserId))) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u5e94\u7528\uff08client_id\uff09\u7684\u4ee3\u7406\u7528\u6237\u4e3a\u7a7a\u6216userName\u4e0d\u5728\u4ee3\u7406\u7528\u6237\u4e2d\u3002", (String)"ApiTokenServiceImpl_17", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
            }
            ApiIpInfoDto apiIpInfoDto = new ApiIpInfoDto();
            apiIpInfoDto.setIp(OpenApiAuthContext.getContext().getIp());
            apiIpInfoDto.setThirdId(open3rdappsDto.getFid());
            apiIpInfoDto.setAccountId(OpenApiAuthContext.getContext().getCurrentCenter().getAccountId());
            OpenApiServiceManager.getApiGateService().checkIP(apiIpInfoDto);
            AuthInfo authInfo = new AuthInfo();
            authInfo.setAuthType("6");
            authInfo.setThirdAppNumber(clientId);
            HandleResult<ApiCommonResult> result = HandleResult.getHandleResult(null);
            Map<String, String> pluginMap = OpenApiPluginUtil.getAuthPluginClass("api_global_authplugin", OpenApiAuthContext.getContext().getCurrentCenter().getAccountId());
            String plugin = pluginMap.get("api_global_authplugin");
            String appId = pluginMap.get("api_global_pluginappid");
            if (StringUtil.isEmpty((String)plugin) || StringUtil.isEmpty((String)appId)) {
                result.setHandled(false);
                HandleResult<ApiCommonResult> handleResult = result;
                return handleResult;
            }
            ApiCommonResult apiCommonResult = null;
            OpenApiResponse openApiResponse = null;
            try {
                openApiResponse = (OpenApiResponse)ApiPluginRpcHelper.invokePlugin(appId, plugin, "unSignAndDecrypt", OpenApiAuthContext.getContext().createCustomRequestDto());
                apiCommonResult = (ApiCommonResult)openApiResponse.getData();
                if (!apiCommonResult.getStatus().booleanValue()) {
                    if (apiCommonResult.getData() != null && ((AuthResult)apiCommonResult.getData()).getParams() != null) {
                        AuthResult authResult = (AuthResult)apiCommonResult.getData();
                        Object responseData = authResult.getParams().get("responseData");
                        boolean isCustomOut = false;
                        if (openApiResponse.getResponseHeaders() != null && openApiResponse.getResponseHeaders().size() > 0) {
                            isCustomOut = true;
                        }
                        if (openApiResponse.getHttpStatus() > 0) {
                            isCustomOut = true;
                        }
                        if (responseData != null) {
                            isCustomOut = true;
                        }
                        if (isCustomOut) {
                            HashMap<String, Object> extParam = new HashMap<String, Object>();
                            extParam.put("responseHeader", openApiResponse.getResponseHeaders());
                            extParam.put("httpStatus", openApiResponse.getHttpStatus());
                            extParam.put("responseData", authResult.getParams().get("responseData"));
                            throw new AuthExtendException(extParam, ApiErrorCode.HTTP_UNAUTHORIZED, ResManager.loadKDString((String)"API\u8ba4\u8bc1\u63d2\u4ef6\u8ba4\u8bc1\u672a\u901a\u8fc7\u3002", (String)"OpenAuthExtendFilter_3", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
                        }
                    }
                    throw new OpenApiException(ApiErrorCode.HTTP_UNAUTHORIZED, String.format(ResManager.loadKDString((String)"API\u8ba4\u8bc1\u63d2\u4ef6\u8ba4\u8bc1\u672a\u901a\u8fc7\u3002message: %1$s", (String)"OpenAuthExtendFilter_0", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), apiCommonResult == null ? "" : apiCommonResult.getMessage()), new Object[0]);
                }
                if (apiCommonResult.getData() != null && StringUtil.isNotEmpty((String)((AuthResult)apiCommonResult.getData()).getData())) {
                    KDSignHttpServletRequestWrapper requestWrapper = (KDSignHttpServletRequestWrapper)request;
                    requestWrapper.setBody(((AuthResult)apiCommonResult.getData()).getData().getBytes("UTF-8"));
                }
                AuthResult authResult = new AuthResult();
                authResult.setThirdId(open3rdappsDto.getFid());
                authResult.setAgentUserId(agentUserId);
                authResult.setThirdAppNumber(clientId);
                authResult.setAccountId(accountId);
                authResult.setAuthType("6");
                apiCommonResult.setData((Object)authResult);
                result.setData(apiCommonResult);
                if (McConfigUtil.isSecurityLogOpen((String)RequestContext.get().getTenantId())) {
                    log.info("OpenAuthExtend pass.");
                }
            }
            catch (Exception e) {
                OpenApiException apiException;
                if (e instanceof OpenApiException && "401".equals((apiException = (OpenApiException)((Object)e)).getCode())) {
                    throw apiException;
                }
                String msg = String.format(ResManager.loadKDString((String)"\u8ba4\u8bc1\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c error:%1$s\u3002", (String)"OpenAuthExtendFilter_1", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), e.getMessage());
                throw new OpenApiException(ApiErrorCode.PLUGIN_ERROR, msg, new Object[]{e});
            }
            HandleResult<ApiCommonResult> handleResult = result;
            return handleResult;
        }
        catch (Throwable e) {
            String msg = "----OpenAuthExtend OpenApi Auth Failed. error:" + e.getMessage();
            log.error(msg, e);
            ApiCommonResult result = ApiCommonResult.getFailResult((String)ApiErrorCode.HTTP_BAD_REQUEST.getStatusCode(), (String)msg);
            OpenApiExceptionUtil.handleAuthException(e, response, result);
            ResultProcessUtil.processAuthResult(request, response, result, e);
            HandleResult<ApiCommonResult> handleResult = HandleResult.getHandleResult(result);
            return handleResult;
        }
        finally {
            int timeCost = (int)(System.currentTimeMillis() - timeST);
            if (OpenApiAuthContext.getContext().isParamErrorCode()) {
                ApiAuthLogUtil.writeAuthApiLog(authUrl, timeCost);
            }
        }
    }
}

