/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kcf;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.govern.GovernConfigs;
import kd.bos.kcf.KCFConfig;
import kd.bos.kcf.KCFException;
import kd.bos.kcf.OpenApiThreadMgr;
import kd.bos.kcf.ServiceContext;
import kd.bos.kcf.ServiceRuntime;
import kd.bos.kcf.WebApiLog;
import kd.bos.kcf.message.HttpMethod;
import kd.bos.kcf.router.KCFRouter;
import kd.bos.limiter.GatewayLimiter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.circuitbreaker.CircuitbreakerFactory;
import kd.bos.mservice.spi.circuitbreaker.Circuitbreaker;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.HttpStatus;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.spi.OpenApiDataService;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.ApiDataUtil;
import kd.bos.openapi.common.util.IOUtil;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.core.OpenApiServlet;
import kd.bos.openapi.kcf.result.ResultProcessUtil;
import kd.bos.openapi.kcf.utils.ApiUtil;
import kd.bos.openapi.kcf.utils.OauthTokenUtil;
import kd.bos.openapi.kcf.utils.OpenApiExceptionUtil;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.reporter.apicall.APICallTagInject;
import kd.bos.trace.reporter.topology.TopologyTagInject;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.resource.Resources;
import org.apache.commons.lang3.math.NumberUtils;

public class KCFServlet
extends HttpServlet {
    private static final long serialVersionUID = 183748932942092L;
    private static final String ROUTE_PATH = "route_path";
    private static final String ACCESS_CONTROL_ALLOW_METHOD = "POST, GET, OPTIONS";
    private static final Log log = LogFactory.getLog(KCFServlet.class);
    private final String localIp = NetAddressUtils.getLocalIpAddress();
    private KCFConfig config;

    public void init(ServletConfig cfg) throws ServletException {
        super.init(cfg);
        this.initRoutePath(cfg);
    }

    void initRoutePath(ServletConfig config) {
        String[] kvSet;
        String route_path = config.getInitParameter(ROUTE_PATH);
        for (String kv : kvSet = route_path.split(";")) {
            String[] router = kv.split(":");
            try {
                KCFRouter.register(router[0], Class.forName(router[1]));
            }
            catch (ClassNotFoundException e) {
                throw KCFException.InternalEx(Resources.getString((String)"\u7c7b", (String)"KCFServlet_0", (String)"bos-dispatcher", (Object[])new Object[0]) + router[1] + Resources.getString((String)"\u672a\u627e\u5230", (String)"KCFServlet_1", (String)"bos-dispatcher", (Object[])new Object[0]), e);
            }
        }
    }

    public boolean isOpenApiV2(String url, String contentPath) {
        return url != null && contentPath != null && url.startsWith(contentPath + "/kapi/v2");
    }

    private boolean isAuthApi(String apiUrl) {
        boolean isAuthApi = apiUrl.startsWith("/oauth2/");
        return isAuthApi;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doActionWithThreadLimit(req, resp, HttpMethod.Get);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doActionWithThreadLimit(req, resp, HttpMethod.Post);
    }

    private String validateHeader(String header) {
        return StringUtil.replaceInvalidString((String)header.trim());
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String headers = req.getHeader("Access-Control-Request-Headers");
        resp.setHeader("Access-Control-Allow-Origin", "*");
        resp.setHeader("Access-Control-Allow-Headers", this.validateHeader(headers));
        resp.setHeader("Access-Control-Allow-Credentials", "true");
        resp.setHeader("Access-Control-Allow-Method", ACCESS_CONTROL_ALLOW_METHOD);
    }

    private void injectTrace(HttpServletRequest req, TraceSpan traceSpan) {
        RequestContext current = RequestContext.get();
        if (current != null) {
            current.setClient("api");
            String destAppId = req.getHeader("cqappid");
            TopologyTagInject.setWebTag((InnerSpan)traceSpan.getInnerSpan(), (String)TopologyTagInject.getClient((String)current.getClient()), (String)destAppId);
            APICallTagInject.setHttpTag((InnerSpan)traceSpan.getInnerSpan(), (String)req.getRemoteAddr(), (String)this.localIp, (String)"http", (String)req.getRequestURI(), (String)destAppId);
        }
    }

    private void doActionWithThreadLimit(final HttpServletRequest req, final HttpServletResponse resp, final HttpMethod method) {
        String url = req.getRequestURI();
        final String apiUrl = ApiDataUtil.getApiUrl((HttpServletRequest)req);
        final boolean isOpenApiV2 = this.isOpenApiV2(url, req.getContextPath());
        boolean isAuthApi = this.isAuthApi(apiUrl);
        final ServiceContext ctxApi1 = !isOpenApiV2 && !isAuthApi ? ServiceContext.create(req, resp, this.config, method) : null;
        try (TraceSpan traceSpan = Tracer.create((String)"api", (String)req.getRequestURI());){
            this.injectTrace(req, traceSpan);
            if (!OpenApiThreadMgr.getThreadBalanceEnable() || isAuthApi) {
                this.doAction(req, resp, method, isOpenApiV2, ctxApi1, apiUrl);
            } else {
                Callable<Void> callable = new Callable<Void>(){

                    @Override
                    public Void call() {
                        KCFServlet.this.doAction(req, resp, method, isOpenApiV2, ctxApi1, apiUrl);
                        return null;
                    }
                };
                OpenApiThreadMgr.call(callable);
            }
        }
        catch (Throwable ex) {
            try {
                if (isOpenApiV2 || isAuthApi) {
                    this.handleKCFException(ex, null, false);
                    OpenApiResult result = OpenApiExceptionUtil.handleException(ex, resp);
                    ResultProcessUtil.processResultHandler(req.getContentType(), result, resp);
                } else {
                    this.handleKCFException(ex, ctxApi1, false);
                }
            }
            catch (Exception ex2) {
                log.error("OpenAPI-KCFServlet-Exception(errorLog-2):" + ex2.getMessage(), (Throwable)ex2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAction(HttpServletRequest req, HttpServletResponse resp, HttpMethod method, boolean isOpenApiV2, ServiceContext ctxApi1, String apiUrl) {
        boolean limitFlow;
        Circuitbreaker breakerThird;
        Circuitbreaker breakerApi;
        OpenApiData openApiData;
        block21: {
            if (this.isAuthApi(apiUrl)) {
                OauthTokenUtil.accessTokenService(req, resp, method, apiUrl);
                return;
            }
            OpenApiDataService openApiDataService = OpenApiDataServiceFactory.getOpenApiDataService();
            openApiData = null;
            breakerApi = null;
            breakerThird = null;
            Circuitbreaker breakerTenantAccountId = null;
            boolean isConfigTenantLimit = false;
            limitFlow = this.isLimitFlow(openApiDataService);
            try {
                if (openApiDataService == null) {
                    throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the OpenApiDataService.", new Object[0]);
                }
                OpenApiDataServiceFactory.getOpenApiBillService().checkAppBillLicense();
                if (this.isLimitFlowByMc() && !GatewayLimiter.isAllowed()) {
                    throw new OpenApiException(ApiErrorCode.HTTP_TOO_MANY_REQUEST, HttpStatus.TOO_MANY_REQUESTS_429.getStatusCode(), "Too many request, Flow Limit is exceed.", new Object[0]);
                }
                isConfigTenantLimit = this.isConfigTenantLimit();
                if (isConfigTenantLimit) {
                    String flowLimitTenantResId = ApiDataUtil.getTenantResLimitResId((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId());
                    breakerTenantAccountId = CircuitbreakerFactory.get((String)"WebRequest", (String)"OpenApi").withName(flowLimitTenantResId).begin();
                }
                if (limitFlow) {
                    if (isOpenApiV2) {
                        openApiData = openApiDataService.getOpenApiData(apiUrl);
                    } else {
                        Map<String, String> apiOneParams = KCFRouter.getParams(apiUrl);
                        if (apiOneParams != null && ApiServiceType.AI.name().equalsIgnoreCase(apiOneParams.get("apiservicetype"))) {
                            limitFlow = false;
                            openApiData = null;
                        } else {
                            openApiData = openApiDataService.getOpenApiOldData(apiOneParams);
                            if (openApiData != null) {
                                ctxApi1.getEnvVars().put("desensitize", openApiData.isDesensitize() + "");
                            }
                        }
                    }
                    if (openApiData != null) {
                        String flowLimitResId = ApiDataUtil.getThirdResLimitResId((String)RequestContext.get().getAccountId(), (String)ApiUtil.getThirdAppId());
                        breakerThird = CircuitbreakerFactory.get((String)"WebRequest", (String)"OpenApi").withName(flowLimitResId).begin();
                        String flowLimitApiResId = ApiDataUtil.getApiResLimitResId((String)RequestContext.get().getAccountId(), (String)String.valueOf(openApiData.getApiId()));
                        breakerApi = CircuitbreakerFactory.get((String)"WebRequest", (String)"OpenApi").withName(flowLimitApiResId).begin();
                    }
                }
                if (isOpenApiV2) {
                    OpenApiServlet openApiServlet = new OpenApiServlet();
                    openApiServlet.doAction(req, resp);
                } else {
                    if (ctxApi1 != null) {
                        ctxApi1.setOpenApiData(openApiData);
                        ServiceRuntime.execute(ctxApi1);
                    }
                    WebApiLog.writeLogInfo();
                }
                if (!isConfigTenantLimit || breakerTenantAccountId == null) break block21;
            }
            catch (Throwable throwable) {
                if (isConfigTenantLimit && breakerTenantAccountId != null) {
                    IOUtil.closeQuietly(breakerTenantAccountId);
                }
                if (limitFlow && openApiData != null && breakerThird != null) {
                    IOUtil.closeQuietly(breakerThird);
                }
                if (limitFlow && openApiData != null && breakerApi != null) {
                    IOUtil.closeQuietly(breakerApi);
                }
                throw throwable;
            }
            IOUtil.closeQuietly((AutoCloseable)breakerTenantAccountId);
        }
        if (limitFlow && openApiData != null && breakerThird != null) {
            IOUtil.closeQuietly(breakerThird);
        }
        if (limitFlow && openApiData != null && breakerApi != null) {
            IOUtil.closeQuietly(breakerApi);
        }
    }

    private boolean isConfigTenantLimit() {
        String limitCount = McConfigUtil.getPropertyByTenantWithDefault((String)RequestContext.get().getTenantId(), (String)"OpenApi.LimitQtyByTenant", (String)"-1");
        return NumberUtils.isDigits((String)limitCount) && Integer.parseInt(limitCount) > 0;
    }

    private void handleKCFException(Throwable ex, ServiceContext ctxApi1, boolean isLogError) {
        boolean isArmoEx;
        String errMsg = OpenApiExceptionUtil.getExceptionMessage(ex);
        String errorCode = String.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode());
        if (ex instanceof OpenApiException) {
            errorCode = ((OpenApiException)ex).getCode();
        }
        boolean bl = isArmoEx = ex.getClass() != null && ex.getClass().getCanonicalName() != null && ex.getClass().getCanonicalName().contains("ArmorException");
        if (isArmoEx) {
            errorCode = String.valueOf(HttpStatus.TOO_MANY_REQUESTS_429.getStatusCode());
            errMsg = "Too many request, Flow Limit is exceed.";
        }
        if (isLogError) {
            log.error("OpenAPI-Exception(errorLog-1):" + errMsg, ex);
        }
        if (ctxApi1 != null && ctxApi1.getResponse() != null) {
            ctxApi1.getResponse().fail(errMsg, errorCode);
            ctxApi1.getResponse().end();
        }
    }

    private boolean isLimitFlow(OpenApiDataService openApiDataService) {
        if (openApiDataService == null) {
            return false;
        }
        return GovernConfigs.getBreakerEnable();
    }

    private boolean isLimitFlowByMc() {
        String tenantLimitCount = McConfigUtil.getPropertyByTenantWithDefault((String)RequestContext.get().getTenantId(), (String)"limiter.apiGateway.maxCount", (String)"-1");
        Integer limitCount = -1;
        if (NumberUtils.isDigits((String)tenantLimitCount)) {
            limitCount = Integer.parseInt(tenantLimitCount);
        }
        return limitCount > 0;
    }

    void notSupport() {
        throw new UnsupportedOperationException();
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doDelete(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doHead(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPut(req, resp);
    }

    protected void doTrace(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        super.doTrace(arg0, arg1);
    }

    protected long getLastModified(HttpServletRequest req) {
        return super.getLastModified(req);
    }
}

