/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kcf;

import com.google.common.util.concurrent.SimpleTimeLimiter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.HttpStatus;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.resource.balancer.Configs;
import kd.bos.resource.balancer.KDThreadPoolFactory;
import kd.bos.resource.balancer.allocator.threadpool.KDThreadPoolEnum;
import kd.bos.resource.balancer.allocator.threadpool.KDThreadPoolExecutor;

public class OpenApiThreadMgr {
    private static String KEY_OPENAPI_THREAD_BALANCE_ENABLE = "openapi.resource.balance.enable";
    private static String KEY_OPENAPI_TIMEOUT = "OpenApi.ThreadBalance.Timeout";
    private static int OPENAPI_TIMEOUT = 600;
    private static String KEY_OPENAPI_CORE_THREAD = "OpenApi.ThreadBalance.CoreThread";
    private static int OPENAPI_CORE_THREAD = 8;
    private static String KEY_OPENAPI_MAX_THREAD = "OpenApi.ThreadBalance.MaxThread";
    private static int OPENAPI_MAX_THREAD = 128;
    private static int mCurrentOpenApiTimeout = OPENAPI_TIMEOUT;
    private static boolean mThreadBalanceEnabled = false;
    private static final Log log = LogFactory.getLog(OpenApiThreadMgr.class);
    private static KDThreadPoolExecutor OPENAPI_EXECUTOR_SERVICE;
    private static SimpleTimeLimiter OPENAPI_SIMPLE_TIME_LIMITER;

    private OpenApiThreadMgr() {
        throw new UnsupportedOperationException();
    }

    public static <T> T call(Callable<T> callable) {
        return OpenApiThreadMgr.call(OPENAPI_SIMPLE_TIME_LIMITER, callable, mCurrentOpenApiTimeout, TimeUnit.SECONDS);
    }

    private static <T> T call(SimpleTimeLimiter timeLimiter, Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) {
        try {
            return (T)timeLimiter.callWithTimeout(callable, timeoutDuration, timeoutUnit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            String errMsg = String.format("Request Timeout, The OpenAPI limit is %1s %2s.", new Object[]{timeoutDuration, timeoutUnit});
            log.error(errMsg + e.getMessage(), (Throwable)e);
            throw new OpenApiException(ApiErrorCode.HTTP_REQUEST_TIMEOUT, HttpStatus.REQUEST_TIMEOUT.getStatusCode(), errMsg, new Object[0]);
        }
        catch (KDException e) {
            String errMsg = "Too Many Requests,Please try again later. The OpenAPI thread pool is full.";
            log.error(errMsg + e.getMessage(), (Throwable)e);
            throw new OpenApiException(ApiErrorCode.HTTP_TOO_MANY_REQUEST, HttpStatus.TOO_MANY_REQUESTS_429.getStatusCode(), errMsg, new Object[0]);
        }
        catch (Exception e) {
            String errMsg = "An error occurred during OpenAPI execution:" + e.getMessage();
            log.error(errMsg, (Throwable)e);
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, HttpStatus.BAD_REQUEST.getStatusCode(), errMsg, new Object[0]);
        }
    }

    public static int getOpenApiTimeoutSeconds() {
        return mCurrentOpenApiTimeout;
    }

    public static boolean getThreadBalanceEnable() {
        return mThreadBalanceEnabled;
    }

    static {
        try {
            int coreThread = (Integer)McConfigUtil.getPropertyGlobal((String)KEY_OPENAPI_CORE_THREAD, Integer.class, (Object)OPENAPI_CORE_THREAD);
            int maxThread = (Integer)McConfigUtil.getPropertyGlobal((String)KEY_OPENAPI_MAX_THREAD, Integer.class, (Object)OPENAPI_MAX_THREAD);
            mCurrentOpenApiTimeout = (Integer)McConfigUtil.getPropertyGlobal((String)KEY_OPENAPI_TIMEOUT, Integer.class, (Object)OPENAPI_TIMEOUT);
            mThreadBalanceEnabled = Configs.isOpenapiResourceBalanceEnable();
            OPENAPI_EXECUTOR_SERVICE = KDThreadPoolFactory.create((String)KDThreadPoolEnum.OPEN_API.getResourceName(), (int)coreThread, (int)maxThread);
            OPENAPI_SIMPLE_TIME_LIMITER = SimpleTimeLimiter.create((ExecutorService)OPENAPI_EXECUTOR_SERVICE);
        }
        catch (Exception ex) {
            log.error("An error occurred during OpenAPI OpenApiThreadMgr initialization: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

