/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kcf;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.kcf.WebApiLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.common.util.ParamCaseInsensitiveUtil;

public class WebApiLog {
    private static Log log = LogFactory.getLog(WebApiLog.class);
    private static final String LOGINFO_TAG = "WebApi_log202112";
    private static final ThreadLocal<StringBuilder> LogInfo = ThreadLocal.withInitial(() -> {
        RequestContext rc = RequestContext.get();
        String logHead = String.format(" RequestContext info AccountId:%s Lang:%s Api3rdAppId:%s", rc.getAccountId(), rc.getLang(), rc.getApi3rdAppId());
        return new StringBuilder(LOGINFO_TAG.concat(logHead));
    });
    private static final ThreadLocal<WebApiLogInfo> ApiLogInfo = ThreadLocal.withInitial(WebApiLogInfo::new);

    private static boolean needWriteLogDetail() {
        return McConfigUtil.needWriteLogDetail();
    }

    public static void reqHeadersWriteLog(HttpServletRequest req) {
        if (RequestContext.get() != null && LogInfo.get() != null) {
            StringBuilder request = new StringBuilder();
            request.append("\r\n");
            request.append(req.getMethod());
            request.append(" ");
            request.append(req.getRequestURI());
            if (req.getQueryString() != null) {
                request.append("?");
                StringBuilder queryString = new StringBuilder();
                Map params = req.getParameterMap();
                for (Map.Entry entry : params.entrySet()) {
                    queryString.append((String)entry.getKey());
                    queryString.append("=");
                    queryString.append(!ParamCaseInsensitiveUtil.headerhashcode.contains(((String)entry.getKey()).toLowerCase()) ? ((String[])entry.getValue())[0] : Integer.valueOf(((String[])entry.getValue())[0].hashCode()));
                    queryString.append("&");
                }
                if (queryString.length() > 1) {
                    request.append(queryString.toString(), 0, queryString.toString().length() - 1);
                }
            }
            Enumeration headernames = req.getHeaderNames();
            request.append("\r\nRequest Headers");
            while (headernames.hasMoreElements()) {
                Object obj = headernames.nextElement();
                String header = obj.toString();
                request.append("\r\n");
                request.append(header);
                request.append(":");
                request.append(ParamCaseInsensitiveUtil.headerhashcode.contains(header.toLowerCase()) ? Integer.valueOf(req.getHeader(header).hashCode()) : req.getHeader(header));
            }
            LogInfo.get().append((CharSequence)request);
            ApiLogInfo.get().setReqheader(request.toString());
        }
    }

    public static void respHeadersWriteLog(HttpServletResponse resp) {
        if (RequestContext.get() != null && LogInfo.get() != null) {
            StringBuilder response = new StringBuilder();
            Collection headerNames = resp.getHeaderNames();
            response.append("\r\nResponse Headers");
            for (String header : headerNames) {
                response.append("\r\n");
                response.append(header);
                response.append(":");
                response.append(resp.getHeader(header));
            }
            LogInfo.get().append((CharSequence)response);
            ApiLogInfo.get().setRespheader(response.toString());
        }
    }

    public static void reqContentWriteLog(String content) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\r\nRequest\r\n");
        stringBuilder.append(content);
        ApiLogInfo.get().setReqtext(stringBuilder.toString());
        if (LogInfo.get() != null && WebApiLog.needWriteLogDetail()) {
            LogInfo.get().append((CharSequence)stringBuilder);
        }
    }

    public static void respContentWriteLog(String content) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\r\nResponse\r\n");
        stringBuilder.append(content);
        ApiLogInfo.get().setResptext(stringBuilder.toString());
        if (RequestContext.get() != null && LogInfo.get() != null && WebApiLog.needWriteLogDetail()) {
            LogInfo.get().append((CharSequence)stringBuilder);
        }
    }

    static void writeLogInfo() {
        LogInfo.remove();
    }

    public static WebApiLogInfo getApiLogInfo() {
        return ApiLogInfo.get();
    }

    public static void reomveApiLogInfo() {
        ApiLogInfo.remove();
    }
}

