/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kcf.message;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.kcf.KCFException;
import kd.bos.kcf.WebApiLog;
import kd.bos.kcf.message.BinaryDataReader;
import kd.bos.kcf.message.EncodeType;
import kd.bos.kcf.message.EncryptType;
import kd.bos.kcf.message.FormatType;
import kd.bos.kcf.message.HttpMethod;
import kd.bos.kcf.message.KMessage;
import kd.bos.kcf.message.MapDataReader;
import kd.bos.kcf.message.MessageReader;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;

public class KRequest
extends KMessage {
    private HttpServletRequest request;
    private HttpMethod method = HttpMethod.Get;
    private Map<String, Object> parameters;
    private MessageReader reader;

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public KRequest(HttpServletRequest req, HttpMethod method) {
        this.request = req;
        this.method = method;
        this.setFormatType();
        if ("POST".equalsIgnoreCase(req.getMethod())) {
            this.method = HttpMethod.Post;
        }
        this.setEncodeType(EncodeType.None);
        this.setEncryptType(EncryptType.None);
        WebApiLog.reqHeadersWriteLog(req);
    }

    private void setFormatType() {
        String contentType = this.getHeader("Content-Type");
        FormatType fmt = contentType.contains("json") ? FormatType.Json : (contentType.contains("xml") ? FormatType.XML : FormatType.FormData);
        this.setFormatType(fmt);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public boolean isMeta() {
        String qs = this.request.getQueryString();
        if (StringUtils.isEmpty((String)qs)) {
            return false;
        }
        return qs.toLowerCase(Locale.ENGLISH).startsWith("meta");
    }

    public String getRelativeUrl() {
        String servlet_path = this.request.getContextPath() + this.request.getServletPath();
        String uri = this.request.getRequestURI();
        if (!"*".equals(servlet_path)) {
            return uri.substring(servlet_path.length());
        }
        return uri;
    }

    String getHeader(String header) {
        StringBuilder sb = new StringBuilder();
        Enumeration headers = this.request.getHeaders(header);
        while (headers.hasMoreElements()) {
            sb.append((String)headers.nextElement());
            sb.append(";");
        }
        return sb.toString().toLowerCase();
    }

    String getOriginalHeader(String header) {
        return this.request.getHeader(StringUtil.replaceInvalidString((String)header));
    }

    public Map<String, Object> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.getReader().read();
        }
        return this.parameters;
    }

    public <T> T getParameter(String key) {
        this.getParameters();
        return this.reader.read(key);
    }

    public Object getData() {
        return this.getReader().readBody();
    }

    public MessageReader getReader() {
        if (this.reader == null) {
            this.reader = this.newReader();
        }
        return this.reader;
    }

    private MessageReader newReader() {
        if (this.method == HttpMethod.Get || this.method == HttpMethod.Post && this.getFormatType() == FormatType.FormData) {
            return new MapDataReader(this.simplify(this.request.getParameterMap()));
        }
        try {
            return new BinaryDataReader((InputStream)this.request.getInputStream(), this.simplify(this.request.getParameterMap()));
        }
        catch (IOException e) {
            throw KCFException.InternalEx(Resources.getString((String)"\u8bfb\u53d6\u8bf7\u6c42\u4fe1\u606f\u65f6\u4ea7\u751f\u5f02\u5e38", (String)"KRequest_0", (String)"bos-dispatcher", (Object[])new Object[0]), e);
        }
    }

    private Map<String, Object> simplify(Map<String, String[]> map) {
        HashMap<String, Object> ret = new HashMap<String, Object>(map.size());
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String[] values = entry.getValue();
            if (values.length > 1) {
                throw KCFException.InternalFmtEx(Resources.getString((String)"Key %s \u5b58\u5728\u591a\u4e2a\u503c", (String)"KRequest_1", (String)"bos-dispatcher", (Object[])new Object[0]), entry.getKey());
            }
            ret.put(entry.getKey(), values[0]);
        }
        return ret;
    }
}

