/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kcf.message;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import kd.bos.fs.util.StringUtils;
import kd.bos.kcf.KCFException;
import kd.bos.kcf.serializor.JsonSerializer;

public class ResultMessage
implements Serializable {
    private static final int CauseDepth = 50;
    private static final long serialVersionUID = -8162614719414174064L;
    private boolean success;
    private boolean data_serialized = false;
    private String message;
    private Object data;
    private String errorCode;
    private KCFException ex;

    public Object getData() {
        return this.data;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public boolean getStatus() {
        return this.success;
    }

    public void setData(Object v) {
        this.data = v;
    }

    public void setMessage(String ex) {
        this.message = ex;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setException(KCFException v) {
        this.ex = v;
    }

    public KCFException getException() {
        return this.ex;
    }

    public String toJsonString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"success\":");
        if (this.success) {
            sb.append("\"true\",");
            sb.append("\"status\":");
            sb.append("\"true\",");
            if (!StringUtils.isEmpty((String)this.errorCode)) {
                sb.append("\"errorCode\":\"").append(this.errorCode).append("\",");
            }
            if (this.data_serialized) {
                sb.append("\"data\":").append(this.data);
            } else {
                sb.append("\"data\":").append(this.objectToJson(this.data));
            }
        } else {
            sb.append("\"false\"");
            sb.append(",");
            sb.append("\"status\":");
            sb.append("\"false\",");
            if (!StringUtils.isEmpty((String)this.errorCode)) {
                sb.append("\"errorCode\":\"").append(this.escapeString(this.errorCode)).append("\"");
                sb.append(",");
            }
            sb.append("\"message\":\"").append(this.escapeString(this.message)).append("\"");
            sb.append(",");
            sb.append("\"stack\":\"").append(this.escapeString(this.getStack())).append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private String objectToJson(Object data) {
        if (data == null) {
            return "null";
        }
        if (data instanceof String) {
            return "\"" + this.escapeString(data.toString()) + "\"";
        }
        if (data instanceof Boolean || data instanceof Number || data instanceof BigDecimal || data.getClass().isPrimitive()) {
            return data.toString();
        }
        return JsonSerializer.toJson(data, false);
    }

    private String escapeString(String s) {
        if (s == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private Throwable getReallyEx() {
        Throwable e = this.ex;
        int count = 0;
        if (e != null) {
            while (e.getCause() != null && count++ < 50) {
                e = e.getCause();
            }
        }
        return e;
    }

    private String getStack() {
        Throwable ex = this.getReallyEx();
        if (ex != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            return sw.getBuffer().toString();
        }
        return "";
    }

    public static ResultMessage fail(String message) {
        ResultMessage ret = new ResultMessage();
        ret.setSuccess(false);
        ret.setMessage(message);
        return ret;
    }

    public static ResultMessage fail(String message, String errorCode) {
        ResultMessage ret = new ResultMessage();
        ret.setSuccess(false);
        ret.setMessage(message);
        ret.setErrorCode(errorCode);
        return ret;
    }

    public static ResultMessage ex(KCFException ex) {
        ResultMessage ret = ResultMessage.fail(ex.getMessage());
        ret.setException(ex);
        return ret;
    }

    public static ResultMessage ex(KCFException ex, String errorCode) {
        ResultMessage ret = ResultMessage.fail(ex.getMessage(), errorCode);
        ret.setException(ex);
        return ret;
    }

    public static ResultMessage success(Object data) {
        return ResultMessage.success(data, false);
    }

    public static ResultMessage success(Object data, String errorCode) {
        return ResultMessage.success(data, false, errorCode);
    }

    public static ResultMessage success(Object data, boolean serialized) {
        ResultMessage ret = new ResultMessage();
        ret.setSuccess(true);
        ret.data_serialized = serialized;
        ret.setData(data);
        return ret;
    }

    public static ResultMessage success(Object data, boolean serialized, String errorCode) {
        ResultMessage ret = new ResultMessage();
        ret.setSuccess(true);
        ret.data_serialized = serialized;
        ret.setData(data);
        ret.setErrorCode(errorCode);
        return ret;
    }
}

