/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kcf.router;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.kcf.KCFConfig;
import kd.bos.kcf.KCFException;
import kd.bos.kcf.ServiceType;
import kd.bos.util.resource.Resources;

public class RouteRule {
    private PathMatcher matcher;
    private Class<?> svc_class;
    private boolean singleton = false;

    public void setExpression(String exp) {
        this.matcher = new NomalMatcher(exp);
    }

    public void setServiceClass(Class<?> clazz) {
        this.svc_class = clazz;
    }

    public Class<?> getServiceClass() {
        return this.svc_class;
    }

    public void setSingleton(boolean v) {
        this.singleton = v;
    }

    public boolean getSingleton() {
        return this.singleton;
    }

    public boolean matchedUrl(String url) {
        return this.matcher.match(url);
    }

    public Map<String, String> extractVars(String url) {
        return this.matcher.extractVars(url);
    }

    public ServiceType getInstance(KCFConfig cfg) {
        return this.newInstance(cfg);
    }

    private ServiceType newInstance(KCFConfig cfg) {
        try {
            ServiceType st = (ServiceType)this.svc_class.newInstance();
            if (st == null) {
                throw KCFException.InternalFmtEx(Resources.getString((String)"\u4e3a%s\u751f\u6210\u7684\u670d\u52a1\u7c7b\u578b\u4e3a\u7a7a", (String)"RouteRule_0", (String)"bos-dispatcher", (Object[])new Object[0]), this.svc_class);
            }
            st.initialize(cfg);
            return st;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw KCFException.InternalEx(Resources.getString((String)"\u521b\u5efa\u670d\u52a1\u7c7b\u578b\u5b9e\u4f8b\u65f6\u4ea7\u751f\u9519\u8bef", (String)"RouteRule_1", (String)"bos-dispatcher", (Object[])new Object[0]), e);
        }
    }

    class NomalMatcher
    implements PathMatcher {
        private String expression;

        public NomalMatcher(String exp) {
            this.expression = exp;
        }

        @Override
        public boolean match(String url) {
            int start = this.expression.length();
            if (this.expression.contains("{")) {
                start = this.expression.indexOf("{");
            }
            boolean matched = url.startsWith(this.expression.substring(0, start));
            return matched;
        }

        @Override
        public Map<String, String> extractVars(String url) {
            HashMap<String, String> map = new HashMap<String, String>();
            String[] url_segs = url.split("/");
            String[] exp_segs = this.expression.split("/");
            for (int i = 0; i < exp_segs.length; ++i) {
                String p = exp_segs[i].trim();
                if (!p.startsWith("{") || !p.endsWith("}")) continue;
                String key = p.substring(1, p.length() - 1);
                if (url_segs.length > i) {
                    map.put(key, url_segs[i]);
                    continue;
                }
                map.put(key, null);
            }
            return map;
        }
    }

    class RegExMatcher
    implements PathMatcher {
        private Pattern pattern = Pattern.compile("kcf");

        public RegExMatcher(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean match(String url) {
            Matcher m = this.pattern.matcher(url);
            return m.find();
        }

        @Override
        public Map<String, String> extractVars(String url) {
            return null;
        }
    }

    static interface PathMatcher {
        public boolean match(String var1);

        public Map<String, String> extractVars(String var1);
    }
}

