/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.model.OpenApiRequest;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.spi.ICustomApiServlet;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.kcf.controller.OpenApiController;
import kd.bos.openapi.kcf.utils.CustServletUtil;

public class CustomServletApiController
implements OpenApiController {
    private static final Log log = LogFactory.getLog(CustomServletApiController.class);

    @Override
    public ApiServiceData<Object> execute(HttpServletRequest req, HttpServletResponse resp) {
        String className = OpenApiContext.getOpenApiData().getClassName();
        Class<?> cacheClazz = CustServletUtil.getOrRegister(className);
        try {
            if (cacheClazz == null) {
                throw new OpenApiException(ApiErrorCode.HTTP_NOT_ACCEPTABLE, "Cannot create clazz for " + className, new Object[0]);
            }
            ICustomApiServlet customApiServlet = (ICustomApiServlet)cacheClazz.newInstance();
            customApiServlet.doAction(req, resp);
            String inputPara = customApiServlet.getInputParameter();
            OpenApiContext.setInputParameter(inputPara);
            String outputPara = customApiServlet.getOutputParameter();
            OpenApiContext.setOutputParameter(outputPara);
        }
        catch (Exception e) {
            String message = "[OpenAPI] An error occurred while executing the custom servlet, the plug-in className is " + className + ", cause: " + e.getMessage();
            log.error(message, (Throwable)e);
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_NOT_ACCEPTABLE, message, new Object[0]);
        }
        return null;
    }

    @Override
    public ApiServiceData<Object> asyncExecute(OpenApiRequest openApiRequest) {
        throw new OpenApiException(ApiErrorCode.PLUGIN_ERROR, "CustomApiServletApi cannot support asynchronous requests", new Object[0]);
    }

    @Override
    public boolean isDefaultProcessor() {
        return false;
    }
}

