/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.mock;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import kd.bos.context.RequestContext;
import kd.bos.openapi.common.util.DataSizeUtil;
import kd.bos.openapi.common.util.StringUtil;

public class MockHttpServletRequest
implements HttpServletRequest {
    private Map<String, Object> data;
    private String apiUrl;
    private String url;
    private Map<String, String> header;
    private String httpMethod;
    private String queryString;
    private Charset characterEncoding;

    public MockHttpServletRequest(String url, String httpMethod, Map<String, Object> data, Map<String, String> header) {
        this.url = url;
        this.data = data;
        this.header = header;
        this.httpMethod = httpMethod;
        this.characterEncoding = Charset.forName("UTF-8");
        this.apiUrl = url;
        int pos = url.indexOf("?");
        if (pos > 0 && pos < url.length() - 1) {
            this.apiUrl = url.substring(0, pos);
            this.queryString = url.substring(pos + 1);
        }
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String getUrl() {
        return this.url;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public String getHeader(String s) {
        return this.header == null ? null : this.header.get(s);
    }

    public Enumeration<String> getHeaders(String s) {
        ArrayList<String> ret = new ArrayList<String>();
        String value = this.header.get(s);
        if (StringUtil.isNotEmpty((String)value)) {
            String[] data;
            for (String item : data = value.split(";")) {
                ret.add(item);
            }
        }
        Enumeration<String> result = Collections.enumeration(ret);
        return result;
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.header != null) {
            for (Map.Entry<String, String> item : this.header.entrySet()) {
                ret.add(item.getKey());
            }
        }
        Enumeration<String> result = Collections.enumeration(ret);
        return result;
    }

    public String getContextPath() {
        String path = RequestContext.get().getClientFullContextPath();
        if (StringUtil.isEmpty((String)path)) {
            return "";
        }
        return path.substring(0, path.length() - 1);
    }

    public String getRequestURI() {
        return this.getContextPath().concat("/kapi").concat(this.apiUrl);
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.getRequestURI());
    }

    public String getMethod() {
        return this.httpMethod;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public int getContentLength() {
        return (int)DataSizeUtil.getObjectSize(this.data);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding.name();
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        this.characterEncoding = Charset.forName("UTF-8");
    }

    public String getServletPath() {
        return null;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String s) {
        return 0L;
    }

    public int getIntHeader(String s) {
        return 0;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String s) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public HttpSession getSession(boolean b) {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public String changeSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return false;
    }

    public void login(String s, String s1) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public Part getPart(String s) throws IOException, ServletException {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        return null;
    }

    public Object getAttribute(String s) {
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        return null;
    }

    public long getContentLengthLong() {
        return 0L;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public String getParameter(String s) {
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return null;
    }

    public String[] getParameterValues(String s) {
        return new String[0];
    }

    public Map<String, String[]> getParameterMap() {
        return new HashMap<String, String[]>();
    }

    public String getProtocol() {
        return null;
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public void setAttribute(String s, Object o) {
    }

    public void removeAttribute(String s) {
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration<Locale> getLocales() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public String getRealPath(String s) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }
}

