/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.result;

import javax.servlet.http.HttpServletResponse;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.kcf.context.ParameterHelper;
import kd.bos.openapi.kcf.result.ResultHandler;
import kd.bos.openapi.kcf.utils.ApiStreamUtil;

public class JsonResultHandler
implements ResultHandler {
    @Override
    public void handleResult(Object resultData) {
        HttpServletResponse resp = OpenApiContext.getResponse();
        this.handleResult(resultData, resp);
    }

    @Override
    public void handleResult(Object resultData, HttpServletResponse resp) {
        String json = OpenJsonUtil.toJson((Object)resultData);
        OpenApiContext.setOutputParameter(json);
        boolean isStatus = OpenApiContext.getResult().isStatus();
        if (isStatus) {
            int length = StringUtil.isEmpty((String)json) ? 0 : json.getBytes().length;
            try {
                ParameterHelper.validateParameterLength(length, false);
            }
            catch (OpenApiException ex) {
                OpenApiResult result = new OpenApiResult(false, ex.getCode(), ex.getMessage(), null);
                json = OpenJsonUtil.toJson((Object)result);
            }
        }
        ApiStreamUtil.writeData(json, resp, "application/json");
    }
}

