/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.result;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.HttpStatus;
import kd.bos.openapi.common.constant.RestSoapType;
import kd.bos.openapi.common.exception.AuthExtendException;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.ApiDataUtil;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.common.wsdl.SoapUtil;
import kd.bos.openapi.kcf.context.OpenApiAuthContext;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.kcf.context.ParameterHelper;
import kd.bos.openapi.kcf.mock.MockHttpServletResponse;
import kd.bos.openapi.kcf.result.ApiSerializerPluginResultHandler;
import kd.bos.openapi.kcf.result.JsonResultHandler;
import kd.bos.openapi.kcf.result.MockResultHandler;
import kd.bos.openapi.kcf.result.ResultHandler;
import kd.bos.openapi.kcf.result.Soap11ResultHandler;
import kd.bos.openapi.kcf.result.Soap12ResultHandler;
import kd.bos.openapi.kcf.result.StreamResultHandler;
import kd.bos.openapi.kcf.result.TextResultHandler;
import kd.bos.openapi.kcf.result.XmlResultHandler;
import kd.bos.openapi.kcf.spi.OpenApiServiceManager;
import kd.bos.openapi.kcf.utils.ApiStreamUtil;
import kd.bos.openapi.kcf.utils.ApiUtil;
import kd.bos.openapi.kcf.utils.OpenApiExceptionUtil;
import kd.bos.openapi.security.model.DigestResponseDto;
import kd.bos.openapi.security.model.ResponseSecurityDto;
import kd.bos.service.authorize.model.ApiCommonResult;

public class ResultProcessUtil {
    private static Log log = LogFactory.getLog(ResultProcessUtil.class);

    private ResultProcessUtil() {
    }

    public static void processResultHandler(String contextType, Object resultData, HttpServletResponse resp) {
        String httpAccept;
        String string = httpAccept = OpenApiContext.getResponse() == null ? "" : OpenApiContext.getResponse().getHeader("Accept");
        if (StringUtil.isEmpty((String)httpAccept)) {
            httpAccept = OpenApiContext.getRequest() == null ? "" : OpenApiContext.getRequestHeader("Accept");
        }
        ResultHandler resultHandler = new JsonResultHandler();
        String serializerPlugin = null;
        if (OpenApiContext.getOpenApiData() != null) {
            serializerPlugin = OpenApiContext.getOpenApiData().getSerializerPlugin();
        }
        if (serializerPlugin != null) {
            resultHandler = new ApiSerializerPluginResultHandler(httpAccept, contextType, serializerPlugin);
        } else if (resp instanceof MockHttpServletResponse) {
            resultHandler = new MockResultHandler();
        } else if (ApiUtil.isAcceptType("application/octet-stream", httpAccept)) {
            resultHandler = new StreamResultHandler();
        } else if (ApiUtil.isAcceptType("application/json", httpAccept)) {
            resultHandler = new JsonResultHandler();
        } else if (ApiUtil.isAcceptType("text/plain", httpAccept)) {
            resultHandler = new TextResultHandler();
        } else if (ApiUtil.isAcceptType("application/xml", httpAccept)) {
            resultHandler = new XmlResultHandler();
        } else if (ApiUtil.isContentType("application/json", contextType)) {
            resultHandler = new JsonResultHandler();
        } else if (ApiUtil.isContentType("application/xml", contextType) || ApiUtil.isContentType("text/xml", contextType) && !SoapUtil.isSoapBody((String)OpenApiContext.getInputParameter())) {
            resultHandler = new XmlResultHandler();
        } else if (ApiUtil.isContentType("text/xml", contextType)) {
            resultHandler = new Soap11ResultHandler();
        } else if (ApiUtil.isContentType("application/soap+xml", contextType)) {
            resultHandler = new Soap12ResultHandler();
        }
        resultHandler.handleResult(resultData, resp);
    }

    public static void processResult(ApiServiceData<Object> apiServiceData) {
        ResultProcessUtil.processResult(apiServiceData, false);
    }

    public static void processResult(ApiServiceData<Object> apiServiceData, boolean isException) {
        Map respHeaders = null;
        if (apiServiceData != null && apiServiceData.getResponse() != null) {
            respHeaders = apiServiceData.getResponse().getResponseHeaders();
            ParameterHelper.setResponseHeaders(OpenApiContext.getResponse(), respHeaders);
            Object data = apiServiceData.getResponse().getData();
            OpenApiResult contextResult = OpenApiContext.getResult();
            OpenApiContext.getContext().setModelTimeCost(apiServiceData.getModelTimeCost());
            contextResult.setData(data);
            contextResult.setStatus(apiServiceData.isStatus());
            String errorCode = apiServiceData.getErrorCode();
            String message = apiServiceData.getMessage();
            if (StringUtil.isEmpty((String)errorCode)) {
                errorCode = apiServiceData.isStatus() ? ApiErrorCode.OK.getStatusCode() : ApiErrorCode.HTTP_BAD_REQUEST.getStatusCode();
            } else if (apiServiceData.isStatus() && "success".equalsIgnoreCase(errorCode)) {
                errorCode = ApiErrorCode.OK.getStatusCode();
            }
            contextResult.setErrorCode(errorCode);
            if (!apiServiceData.isStatus() && apiServiceData.getStack() != null) {
                String stackMsg = OpenApiExceptionUtil.getExceptionMessage(apiServiceData.getStack(), apiServiceData.getPluginInstanceId());
                message = message != null ? message + "," + stackMsg : stackMsg;
            }
            contextResult.setMessage(message);
            if (ApiStreamUtil.getStatus() < HttpStatus.BAD_REQUEST.getStatusCode()) {
                int httpStatus = apiServiceData.getResponse().getHttpStatus();
                ApiStreamUtil.sendStatus(httpStatus);
            }
        }
        boolean isIncludeStatusWhenException = isException && "true".equals(OpenApiDataServiceFactory.getOpenApiDataService().getSysExtPara("OutStatusWhenException", "true"));
        String contextType = OpenApiContext.getRequest() == null ? "" : OpenApiContext.getRequestHeader("Content-Type");
        boolean isIncludeStatus = isIncludeStatusWhenException || ApiDataUtil.isOutParaIncludeStatus((OpenApiData)OpenApiContext.getOpenApiData(), (boolean)ApiUtil.isSoap(contextType));
        OpenApiResult result = OpenApiContext.getResult();
        ResultProcessUtil.wirteResponseStatusHeader(result);
        OpenApiResult plainResult = isIncludeStatus || result == null || result.isStatus() && result.getData() == null ? result : result.getData();
        Object encryptResult = ResultProcessUtil.getEncryptResultData(plainResult);
        ResultProcessUtil.processResultHandler(contextType, encryptResult, OpenApiContext.getResponse());
    }

    public static void processException() {
        Throwable exception = OpenApiContext.getContext().getException();
        OpenApiExceptionUtil.handleException(exception);
        ResultProcessUtil.processResult(null, true);
    }

    public static String getSoapResult(RestSoapType restSoapType, Object resultData) {
        String reponseNode;
        String namespace = OpenApiContext.getOpenApiData() == null ? "" : OpenApiContext.getOpenApiData().getNamespace();
        String string = reponseNode = OpenApiContext.getOpenApiData() == null ? "" : OpenApiContext.getOpenApiData().getWsOutputParam();
        if (OpenApiContext.getResult() != null && !OpenApiContext.getResult().isStatus()) {
            reponseNode = "Fault";
        }
        if (restSoapType == RestSoapType.SOAP1_1) {
            String soap = SoapUtil.getSoapXml((Object)resultData, (RestSoapType)RestSoapType.SOAP1_1, (String)namespace, (String)reponseNode);
            return soap;
        }
        String soap = SoapUtil.getSoapXml((Object)resultData, (RestSoapType)RestSoapType.SOAP1_2, (String)namespace, (String)reponseNode);
        return soap;
    }

    public static void wirteResponseStatusHeader(OpenApiResult result) {
        boolean status = false;
        String errorCode = "";
        if (result != null) {
            status = result.isStatus();
            errorCode = result.getErrorCode();
            if (errorCode != null && errorCode.length() > 200) {
                errorCode = errorCode.substring(0, 200);
            }
        }
        if (errorCode != null && ResultProcessUtil.containsChinese(errorCode)) {
            try {
                errorCode = URLEncoder.encode(errorCode, ApiStreamUtil.getAcceptCharset().displayName());
            }
            catch (UnsupportedEncodingException e) {
                log.error("wirteResponseStatusHeader - URLEncoder.encode: " + e.getMessage(), (Throwable)e);
            }
        }
        OpenApiContext.getResponse().setHeader("OpenApi-Status", Boolean.toString(status));
        OpenApiContext.getResponse().setHeader("OpenApi-ErrorCode", errorCode);
    }

    private static Object getEncryptResultData(Object plainData) {
        String openapiDataUrl = ApiDataUtil.getApiUrl((HttpServletRequest)OpenApiContext.getRequest());
        ResponseSecurityDto responseSecurityDto = ResponseSecurityDto.valueOf((String)RequestContext.get().getAuthType(), (Object)plainData, (String)RequestContext.get().getApi3rdAppId(), (String)OpenApiContext.getRequestHeader("sense"), (String)RequestContext.get().getAccountId(), (String)("/kapi" + openapiDataUrl));
        Object resultObj = OpenApiServiceManager.getApiSecurityService().resultHandle(responseSecurityDto);
        return resultObj;
    }

    private static boolean containsChinese(String str) {
        String regex = "[\\u4e00-\\u9fa5]";
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(str).find();
    }

    public static void processAuthResult(HttpServletRequest request, HttpServletResponse response, ApiCommonResult result) {
        ResultProcessUtil.processAuthResult(request, response, result, false);
    }

    public static void processAuthResult(HttpServletRequest request, HttpServletResponse response, ApiCommonResult result, boolean isDigestAuth) {
        ApiCommonResult resultData;
        String apiOnlyData = request.getHeader("ApiOnlyData");
        String contextType = request.getHeader("Content-Type");
        boolean isIncludeStatus = !"1".equals(apiOnlyData);
        response.setHeader("OpenApi-Status", Boolean.toString(result.getStatus()));
        response.setHeader("OpenApi-ErrorCode", result.getErrorCode());
        Object object = resultData = isIncludeStatus || result == null || result.getStatus() != false && result.getData() == null ? result : result.getData();
        if (isDigestAuth && resultData instanceof ApiCommonResult) {
            resultData = DigestResponseDto.create((ApiCommonResult)resultData);
        }
        String json = JacksonUtil.writeValueAsPrettyString((Object)resultData);
        OpenApiAuthContext.getContext().addParamExt("response", json);
        OpenApiAuthContext.getContext().addParamExt("status", result.getStatus());
        OpenApiAuthContext.getContext().addParamExt("errorCode", result.getErrorCode());
        OpenApiAuthContext.getContext().addParamExt("message", result.getMessage());
        OpenApiAuthContext.getContext().addParamExt("httpStatus", response.getStatus());
        ApiStreamUtil.writeData(json, response, "application/json");
    }

    public static void processAuthResult(HttpServletRequest request, HttpServletResponse response, ApiCommonResult result, Throwable e) {
        if (e instanceof AuthExtendException) {
            AuthExtendException authExtendException = (AuthExtendException)e;
            Map extParams = authExtendException.getExtParams();
            Map responseHeader = (Map)extParams.get("responseHeader");
            Object responseData = extParams.get("responseData");
            Integer httpStatus = (Integer)extParams.get("httpStatus");
            if (responseHeader != null && responseHeader.size() > 0) {
                for (Map.Entry header : responseHeader.entrySet()) {
                    response.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if (httpStatus != null && httpStatus > 0) {
                response.setStatus(httpStatus.intValue());
            }
            if (responseData != null) {
                String json = JacksonUtil.writeValueAsPrettyString(responseData);
                ApiStreamUtil.writeData(json, response, "application/json");
            }
        } else {
            ResultProcessUtil.processAuthResult(request, response, result);
        }
    }
}

