/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.result;

import java.nio.charset.Charset;
import javax.servlet.http.HttpServletResponse;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.HttpStatus;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.OpenApiFile;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.kcf.result.ResultHandler;
import kd.bos.openapi.kcf.utils.ApiStreamUtil;

public class StreamResultHandler
implements ResultHandler {
    @Override
    public void handleResult(Object resultData) {
        this.handleResult(resultData, OpenApiContext.getResponse());
    }

    @Override
    public void handleResult(Object resultData, HttpServletResponse resp) {
        OpenApiFile fileResult = new OpenApiFile("errorFile.txt", "text/plain", true, new byte[0]);
        String errMsg = "";
        if (resultData != null && !((OpenApiResult)resultData).isStatus()) {
            OpenApiResult result = (OpenApiResult)resultData;
            errMsg = "ErrorCode:" + result.getErrorCode() + ", Message:" + result.getMessage();
        } else if (resultData == null || ((OpenApiResult)resultData).getData() == null) {
            errMsg = "ErrorCode:" + ApiErrorCode.HTTP_BAD_REQUEST.getStatusCode() + " , CustomApiResult cannot be null.";
        } else {
            Object data = ((OpenApiResult)resultData).getData();
            if (!(data instanceof OpenApiFile)) {
                errMsg = "ErrorCode:" + ApiErrorCode.HTTP_BAD_REQUEST.getStatusCode() + ", CustomApiResult must be instance of OpenApiFile.";
            } else {
                errMsg = "";
                fileResult = (OpenApiFile)data;
            }
        }
        if (!StringUtil.isEmpty((String)errMsg)) {
            int httpStatus = HttpStatus.BAD_REQUEST.getStatusCode();
            if (ApiStreamUtil.getStatus() < HttpStatus.BAD_REQUEST.getStatusCode()) {
                ApiStreamUtil.sendStatus(httpStatus);
            }
            byte[] errorData = errMsg.getBytes(Charset.forName("UTF-8"));
            fileResult = new OpenApiFile("errorFile.txt", "text/plain", true, errorData);
        }
        try {
            if (fileResult != null && fileResult.isDownload()) {
                ApiStreamUtil.downloadAttachment(fileResult, resp);
            } else {
                ApiStreamUtil.openAttachment(fileResult, resp);
            }
        }
        catch (Exception ex) {
            throw new OpenApiException((Throwable)ex, ApiErrorCode.HTTP_BAD_REQUEST, ex.getMessage(), new Object[0]);
        }
    }
}

