/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.utils;

import javax.servlet.http.HttpServletRequest;
import kd.bos.context.RequestContext;
import kd.bos.openapi.api.model.ServiceApiData;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiContext;

public class ApiUtil {
    public static String getRequestPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String requestURI = request.getRequestURI();
        String[] path = requestURI.split(servletPath);
        return path[1];
    }

    public static Object newInstance(Class<?> clazz) {
        try {
            Object instance = clazz.newInstance();
            return instance;
        }
        catch (Exception ex) {
            throw new OpenApiException((Throwable)ex, ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while creating new class:" + clazz.getCanonicalName() + ",Reason:" + ex.getMessage(), new Object[0]);
        }
    }

    public static Object newInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object instance = clazz.newInstance();
            return instance;
        }
        catch (Exception ex) {
            throw new OpenApiException((Throwable)ex, ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while creating new class:" + className + ",Reason:" + ex.getMessage(), new Object[0]);
        }
    }

    public static boolean isAcceptType(String mediaType) {
        String accept = OpenApiContext.getRequest() == null ? "" : OpenApiContext.getRequestHeader("Accept");
        return ApiUtil.isAcceptType(mediaType, accept);
    }

    public static boolean isAcceptType(String mediaType, String httpAccept) {
        if (StringUtil.isEmpty((String)httpAccept)) {
            return false;
        }
        return httpAccept.contains(mediaType);
    }

    public static boolean isContentType(String mediaType) {
        String contentType = OpenApiContext.getRequest() == null ? "" : OpenApiContext.getRequestHeader("Content-Type");
        return ApiUtil.isContentType(mediaType, contentType);
    }

    public static boolean isContentType(String mediaType, String httpContextType) {
        String defaultMediaType = "application/json";
        if (StringUtil.isEmpty((String)httpContextType)) {
            return defaultMediaType.contains(mediaType);
        }
        return httpContextType.contains(mediaType);
    }

    public static boolean isSoap(String contextType) {
        return ApiUtil.isContentType("text/xml", contextType) || ApiUtil.isContentType("application/soap+xml", contextType);
    }

    public static String getThirdAppId() {
        String result = RequestContext.get().getApi3rdAppId();
        return result;
    }

    public static ServiceApiData getServiceApiData(OpenApiData openApiData) {
        if (openApiData == null) {
            return null;
        }
        ServiceApiData serviceApiData = new ServiceApiData();
        serviceApiData.setApiId(openApiData.getApiId());
        serviceApiData.setApiNumber(openApiData.getApiNumber());
        serviceApiData.setBizObject(openApiData.getBizObject());
        serviceApiData.setAppId(openApiData.getAppId());
        serviceApiData.setAppRealId(openApiData.getAppRealId());
        serviceApiData.setCloudId(openApiData.getCloudId());
        serviceApiData.setUrl(openApiData.getUrl());
        serviceApiData.setHttpMethod(openApiData.getHttpMethod().getName());
        serviceApiData.setApiServiceType(openApiData.getApiServiceType().toString());
        serviceApiData.setClassName(openApiData.getClassName());
        serviceApiData.setMethodName(openApiData.getMethodName());
        serviceApiData.setDesensitize(openApiData.isDesensitize());
        serviceApiData.setApiOperationType(openApiData.getApiOperationType());
        serviceApiData.setMuliLang(openApiData.isMuliLang());
        return serviceApiData;
    }
}

