/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Locale;
import java.util.Map;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiOperationType;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.RestSoapType;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.spi.OpenApiDataService;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.ParamCaseInsensitiveUtil;
import kd.bos.openapi.common.util.XmlJsonUtil;
import kd.bos.openapi.common.util.XmlUtil;
import kd.bos.openapi.common.wsdl.SoapUtil;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.kcf.utils.ApiUtil;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import org.apache.commons.lang.StringUtils;

public class DesensitizeUtil {
    private static final Log log = LogFactory.getLog(DesensitizeUtil.class);

    public static String handleRequestDesensitize(String request, OpenApiData openApiData) {
        OpenApiContext.getContext();
        return DesensitizeUtil.handleRequestDesensitize(request, openApiData, OpenApiContext.getRequest().getContentType());
    }

    public static String handleRequestDesensitize(String request, OpenApiData openApiData, String contextType) {
        boolean isDesensitize;
        if (StringUtils.isEmpty((String)request) || openApiData == null) {
            return request;
        }
        boolean isGet = "GET".equalsIgnoreCase(openApiData.getHttpMethod().getName());
        boolean bl = isDesensitize = openApiData.isDesensitize() && ApiServiceType.OPERATION == openApiData.getApiServiceType() && (ApiOperationType.QUERY.getOp().equalsIgnoreCase(openApiData.getApiOperationType()) || ApiOperationType.SAVE.getOp().equalsIgnoreCase(openApiData.getApiOperationType()));
        if (isGet && isDesensitize) {
            String[] params = request.split("&");
            if (params != null && params.length > 0) {
                StringBuilder paramsBuilder = new StringBuilder();
                int i = 0;
                for (String param : params) {
                    ++i;
                    String[] parvalus = param.split("=");
                    if (parvalus == null || parvalus.length != 2) continue;
                    String fieldName = DesensitizeUtil.findObjectFieldName(openApiData.getApiId(), parvalus[0]);
                    String value = parvalus[1];
                    Object desensitizeValue = "***";
                    desensitizeValue = ParamCaseInsensitiveUtil.headerhashcode.contains(fieldName.toLowerCase(Locale.ENGLISH)) ? "***" : (isDesensitize ? PrivacyCenterServiceHelper.getDesensitizeValue((String)openApiData.getBizObject(), (String)fieldName, (String)Lang.get().toString(), (String)"api", null, (Object)value) : value);
                    paramsBuilder.append(fieldName).append("=").append(desensitizeValue);
                    if (i >= params.length) continue;
                    paramsBuilder.append("&");
                }
                request = paramsBuilder.toString();
            }
            return request;
        }
        if (!isDesensitize) {
            return request;
        }
        if (ApiUtil.isContentType("application/json", contextType)) {
            request = DesensitizeUtil.jsonRequestDesensitive(request, openApiData);
        } else if (ApiUtil.isContentType("application/xml", contextType)) {
            JSONObject jsonObject = XmlJsonUtil.documentToJSONObject((String)request);
            JSONObject dataObj = jsonObject.getJSONObject("data");
            if (dataObj instanceof JSONObject) {
                DesensitizeUtil.updateJsonObjectValue(dataObj, openApiData);
            } else if (dataObj instanceof JSONArray) {
                for (int i = 0; i < ((JSONArray)dataObj).size(); ++i) {
                    JSONObject oneData = ((JSONArray)dataObj).getJSONObject(i);
                    DesensitizeUtil.updateJsonObjectValue(oneData, openApiData);
                }
            }
            request = XmlUtil.objectToXml((Object)jsonObject);
        } else if (ApiUtil.isContentType("text/xml", contextType) || ApiUtil.isContentType("application/soap+xml", contextType)) {
            RestSoapType soapType;
            JSONObject jsonObject = SoapUtil.readSoapToJson((String)request);
            Object dataObj = jsonObject.get((Object)"data");
            RestSoapType restSoapType = soapType = ApiUtil.isContentType("text/xml", contextType) ? RestSoapType.SOAP1_1 : RestSoapType.SOAP1_2;
            if (dataObj instanceof JSONObject) {
                DesensitizeUtil.updateJsonObjectValue((JSONObject)dataObj, openApiData);
            } else if (dataObj instanceof JSONArray) {
                for (int i = 0; i < ((JSONArray)dataObj).size(); ++i) {
                    JSONObject oneData = ((JSONArray)dataObj).getJSONObject(i);
                    DesensitizeUtil.updateJsonObjectValue(oneData, openApiData);
                }
            }
            request = SoapUtil.getSoapXml((Object)jsonObject, (RestSoapType)soapType, (String)openApiData.getNamespace(), (String)openApiData.getWsInputParam());
        }
        return request;
    }

    private static String jsonRequestDesensitive(String request, OpenApiData openApiData) {
        Object requestObj;
        block5: {
            block3: {
                Object data;
                block4: {
                    requestObj = JsonUtil.parseJson((String)request);
                    if (!(requestObj instanceof JSONObject)) break block3;
                    JSONObject reqJson = (JSONObject)requestObj;
                    data = reqJson.get((Object)"data");
                    if (!(data instanceof JSONArray)) break block4;
                    for (int i = 0; i < ((JSONArray)data).size(); ++i) {
                        JSONObject oneData = ((JSONArray)data).getJSONObject(i);
                        DesensitizeUtil.updateJsonObjectValue(oneData, openApiData);
                    }
                    break block5;
                }
                if (!(data instanceof JSONObject)) break block5;
                DesensitizeUtil.updateJsonObjectValue((JSONObject)data, openApiData);
                break block5;
            }
            if (requestObj instanceof JSONArray) {
                JSONArray reqJsonArray = (JSONArray)requestObj;
                for (int i = 0; i < reqJsonArray.size(); ++i) {
                    JSONObject oneData = reqJsonArray.getJSONObject(i);
                    DesensitizeUtil.updateJsonObjectValue(oneData, openApiData);
                }
            }
        }
        return JSON.toJSONString((Object)requestObj, (boolean)true);
    }

    private static void updateJsonObjectValue(JSONObject oneData, OpenApiData openApiData) {
        if (oneData == null || openApiData == null) {
            return;
        }
        for (Map.Entry entry : oneData.entrySet()) {
            Object desensitizeValue;
            Object desensitizeValue2;
            String entryValueArrayDataEntryValueArrayDataEntryFieldName;
            String fieldName = DesensitizeUtil.findObjectFieldName(openApiData.getApiId(), (String)entry.getKey());
            Object entryValue = entry.getValue();
            if (entryValue instanceof JSONArray) {
                JSONArray entryValueArray = (JSONArray)entryValue;
                for (int i = 0; i < entryValueArray.size(); ++i) {
                    JSONObject entryValueArrayData = entryValueArray.getJSONObject(i);
                    for (Map.Entry entryValueArrayDataEntry : entryValueArrayData.entrySet()) {
                        String entryValueArrayDataEntryFieldName = DesensitizeUtil.findObjectFieldName(openApiData.getApiId(), (String)entryValueArrayDataEntry.getKey());
                        Object entryValueArrayDataEntryValue = entryValueArrayDataEntry.getValue();
                        if (entryValueArrayDataEntryValue instanceof JSONArray) {
                            JSONArray entryValueArrayDataEntryValueArray = (JSONArray)entryValueArrayDataEntryValue;
                            for (i = 0; i < entryValueArrayDataEntryValueArray.size(); ++i) {
                                JSONObject entryValueArrayDataEntryValueArrayData = entryValueArrayDataEntryValueArray.getJSONObject(i);
                                for (Map.Entry entryValueArrayDataEntryValueArrayDataEntry : entryValueArrayDataEntryValueArrayData.entrySet()) {
                                    String entryValueArrayDataEntryValueArrayDataEntryFieldName2 = DesensitizeUtil.findObjectFieldName(openApiData.getApiId(), (String)entryValueArrayDataEntryValueArrayDataEntry.getKey());
                                    Object desensitizeValue3 = PrivacyCenterServiceHelper.getDesensitizeValue((String)openApiData.getBizObject(), (String)entryValueArrayDataEntryValueArrayDataEntryFieldName2, (String)Lang.get().toString(), (String)"api", null, entryValueArrayDataEntryValueArrayDataEntry.getValue());
                                    entryValueArrayDataEntryValueArrayDataEntry.setValue(desensitizeValue3);
                                }
                            }
                        }
                        if (entryValueArrayDataEntryValue instanceof JSONObject) {
                            for (Map.Entry entryValueArrayDataEntryValueArrayDataEntry : ((JSONObject)entryValueArrayDataEntryValue).entrySet()) {
                                entryValueArrayDataEntryValueArrayDataEntryFieldName = DesensitizeUtil.findObjectFieldName(openApiData.getApiId(), (String)entryValueArrayDataEntryValueArrayDataEntry.getKey());
                                desensitizeValue2 = PrivacyCenterServiceHelper.getDesensitizeValue((String)openApiData.getBizObject(), (String)entryValueArrayDataEntryValueArrayDataEntryFieldName, (String)Lang.get().toString(), (String)"api", null, entryValueArrayDataEntryValueArrayDataEntry.getValue());
                                entryValueArrayDataEntryValueArrayDataEntry.setValue(desensitizeValue2);
                            }
                            continue;
                        }
                        desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)openApiData.getBizObject(), (String)entryValueArrayDataEntryFieldName, (String)Lang.get().toString(), (String)"api", null, entryValueArrayDataEntry.getValue());
                        entryValueArrayDataEntry.setValue(desensitizeValue);
                    }
                }
            }
            if (entryValue instanceof JSONObject) {
                for (Map.Entry entryValueArrayDataEntry : ((JSONObject)entryValue).entrySet()) {
                    String entryValueArrayDataEntryFieldName = DesensitizeUtil.findObjectFieldName(openApiData.getApiId(), (String)entryValueArrayDataEntry.getKey());
                    Object entryValueArrayDataEntryValue = entryValueArrayDataEntry.getValue();
                    if (entryValueArrayDataEntryValue instanceof JSONArray) {
                        JSONArray entryValueArrayDataEntryValueArray = (JSONArray)entryValueArrayDataEntryValue;
                        for (int i = 0; i < entryValueArrayDataEntryValueArray.size(); ++i) {
                            JSONObject entryValueArrayDataEntryValueArrayData = entryValueArrayDataEntryValueArray.getJSONObject(i);
                            for (Map.Entry entryValueArrayDataEntryValueArrayDataEntry : entryValueArrayDataEntryValueArrayData.entrySet()) {
                                entryValueArrayDataEntryValueArrayDataEntryFieldName = DesensitizeUtil.findObjectFieldName(openApiData.getApiId(), (String)entryValueArrayDataEntryValueArrayDataEntry.getKey());
                                desensitizeValue2 = PrivacyCenterServiceHelper.getDesensitizeValue((String)openApiData.getBizObject(), (String)entryValueArrayDataEntryValueArrayDataEntryFieldName, (String)Lang.get().toString(), (String)"api", null, entryValueArrayDataEntryValueArrayDataEntry.getValue());
                                entryValueArrayDataEntryValueArrayDataEntry.setValue(desensitizeValue2);
                            }
                        }
                    }
                    if (entryValueArrayDataEntryValue instanceof JSONObject) {
                        for (Map.Entry entryValueArrayDataEntryValueArrayDataEntry : ((JSONObject)entryValueArrayDataEntryValue).entrySet()) {
                            String entryValueArrayDataEntryValueArrayDataEntryFieldName3 = DesensitizeUtil.findObjectFieldName(openApiData.getApiId(), (String)entryValueArrayDataEntryValueArrayDataEntry.getKey());
                            desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)openApiData.getBizObject(), (String)entryValueArrayDataEntryValueArrayDataEntryFieldName3, (String)Lang.get().toString(), (String)"api", null, entryValueArrayDataEntryValueArrayDataEntry.getValue());
                            entryValueArrayDataEntryValueArrayDataEntry.setValue(desensitizeValue);
                        }
                        continue;
                    }
                    Object desensitizeValue4 = PrivacyCenterServiceHelper.getDesensitizeValue((String)openApiData.getBizObject(), (String)entryValueArrayDataEntryFieldName, (String)Lang.get().toString(), (String)"api", null, entryValueArrayDataEntry.getValue());
                    entryValueArrayDataEntry.setValue(desensitizeValue4);
                }
                continue;
            }
            Object desensitizeValue5 = PrivacyCenterServiceHelper.getDesensitizeValue((String)openApiData.getBizObject(), (String)fieldName, (String)Lang.get().toString(), (String)"api", null, entry.getValue());
            entry.setValue(desensitizeValue5);
        }
    }

    private static String findObjectFieldName(Long apiId, String fieldName) {
        OpenApiDataService openApiDataService = OpenApiDataServiceFactory.getOpenApiDataService();
        return openApiDataService.findObjectFieldName(apiId, fieldName);
    }
}

