/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.kcf.utils;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.kcf.message.HttpMethod;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.circuitbreaker.CircuitbreakerFactory;
import kd.bos.mservice.spi.circuitbreaker.Circuitbreaker;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.ApiDataUtil;
import kd.bos.openapi.common.util.IOUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiAuthContext;
import kd.bos.openapi.kcf.result.ResultProcessUtil;
import kd.bos.openapi.kcf.spi.OpenApiServiceManager;
import kd.bos.openapi.kcf.utils.ApiAuthLogUtil;
import kd.bos.openapi.kcf.utils.OpenApiExceptionUtil;
import kd.bos.openapi.security.model.ApiIpInfoDto;
import kd.bos.openapi.security.model.TokenUrlEnum;
import kd.bos.openapi.security.oauth.token.AccessTokenRequestDto;
import kd.bos.service.authorize.model.ApiCommonResult;

public class OauthTokenUtil {
    private static final Log log = LogFactory.getLog(OauthTokenUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void accessTokenService(HttpServletRequest request, HttpServletResponse response, HttpMethod method, String url) {
        String authUrl;
        long timeST;
        block14: {
            timeST = System.currentTimeMillis();
            authUrl = ApiDataUtil.getApiUrl((HttpServletRequest)request);
            Circuitbreaker breakerThird = null;
            try {
                OpenApiAuthContext.getInstance(request, response);
                if (HttpMethod.Post != method) {
                    throw new OpenApiException(ApiErrorCode.HTTP_NOT_ALLOWED, ResManager.loadKDString((String)"\u8bf7\u6c42\u65b9\u5f0f\u4ec5\u652f\u6301POST\u3002", (String)"OauthTokenUtil_0", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
                }
                if (TokenUrlEnum.getToken((String)url) == null) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: \u4e0d\u5408\u6cd5\u7684URL\u3002", (String)"OauthTokenUtil_4", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
                }
                String accountId = OpenApiAuthContext.getContext().getCurrentCenter().getAccountId();
                String postDataString = OpenApiAuthContext.getContext().getBody();
                if (StringUtil.isEmpty((String)postDataString)) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: %1$s\u4e3a\u7a7a\u3002", (String)"OauthTokenUtil_1", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), "body"), new Object[0]);
                }
                Object bodyParam = OpenApiAuthContext.getContext().getContextMap().get("Request.Arg0");
                if (!(bodyParam instanceof Map)) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef:\u53c2\u6570\u9700\u8981\u4ee5JSON\u683c\u5f0f\u4f20\u5165\u3002", (String)"OauthTokenUtil_2", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), new Object[0]);
                }
                Map requestMap = (Map)bodyParam;
                Map<String, String> headers = OpenApiAuthContext.getContext().getHeaders();
                OauthTokenUtil.updateClientIdAndSecretByBasic(headers, requestMap);
                String clientId = (String)requestMap.get("client_id");
                OpenApiServiceManager.getTokenFacadeService().limit(url, clientId, accountId);
                String clientSecret = (String)requestMap.get("client_secret");
                if (StringUtil.isEmpty((String)clientId)) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: %1$s\u4e3a\u7a7a\u3002", (String)"OauthTokenUtil_1", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), "client_id"), new Object[0]);
                }
                Long thirdAppId = OpenApiServiceManager.getOpenApiAuthService().getThirdIdByNum(clientId, accountId);
                if (thirdAppId == null || thirdAppId == 0L) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef: \u7b2c\u4e09\u65b9\u5e94\u7528client_id\uff1a %1$s\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\u3002", (String)"OauthTokenUtil_3", (String)ResSystemType.KCF.getType(), (Object[])new Object[0]), clientId), new Object[0]);
                }
                String version = headers.get("OpenApiVer");
                OpenApiAuthContext.getContext().addParamExt("client_id", clientId);
                OpenApiAuthContext.getContext().addParamExt("thirdAppId", thirdAppId);
                String flowLimitResId = ApiDataUtil.getThirdResLimitResId((String)accountId, (String)thirdAppId.toString());
                breakerThird = CircuitbreakerFactory.get((String)"WebRequest", (String)"OpenApi").withName(flowLimitResId).begin();
                ApiIpInfoDto apiIpInfoDto = new ApiIpInfoDto();
                apiIpInfoDto.setIp(OpenApiAuthContext.getContext().getIp());
                apiIpInfoDto.setThirdId(thirdAppId);
                apiIpInfoDto.setAccountId(OpenApiAuthContext.getContext().getCurrentCenter().getAccountId());
                OpenApiServiceManager.getApiGateService().checkIP(apiIpInfoDto);
                AccessTokenRequestDto accessTokenRequestInfo = new AccessTokenRequestDto(clientSecret);
                accessTokenRequestInfo.setThirdAppNumber(clientId);
                ApiCommonResult result = OpenApiServiceManager.getTokenFacadeService().invoke(url, version);
                ResultProcessUtil.processAuthResult(request, response, result);
                OpenApiAuthContext.getContext().addParamExt("errorCode", "0");
                if (breakerThird == null) break block14;
            }
            catch (Throwable e) {
                try {
                    ApiCommonResult result = new ApiCommonResult();
                    result.setMessage(e.getMessage());
                    result.setStatus(Boolean.valueOf(false));
                    String msg = "----OauthTokenUtil OpenApi Auth Failed. error:" + e.getMessage();
                    log.error(msg, e);
                    OpenApiExceptionUtil.handleAuthException(e, response, result);
                    ResultProcessUtil.processAuthResult(request, response, result);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (breakerThird != null) {
                        IOUtil.closeQuietly(breakerThird);
                    }
                    int timeCost = (int)(System.currentTimeMillis() - timeST);
                    if (OpenApiAuthContext.getContext() != null && OpenApiAuthContext.getContext().isParamErrorCode()) {
                        ApiAuthLogUtil.writeAuthApiLog(authUrl, timeCost);
                    }
                    OpenApiAuthContext.close();
                }
            }
            IOUtil.closeQuietly((AutoCloseable)breakerThird);
        }
        int timeCost = (int)(System.currentTimeMillis() - timeST);
        if (OpenApiAuthContext.getContext() != null && OpenApiAuthContext.getContext().isParamErrorCode()) {
            ApiAuthLogUtil.writeAuthApiLog(authUrl, timeCost);
        }
        OpenApiAuthContext.close();
    }

    private static void updateClientIdAndSecretByBasic(Map<String, String> headers, Map<String, Object> requestMap) {
        String[] authorizationStrings;
        String authorization = headers.get("Authorization");
        if (StringUtil.isNotEmpty((String)authorization) && (authorization = authorization.trim()).startsWith("Basic") && (authorizationStrings = authorization.split("\\s+")).length == 2 && authorizationStrings[0].equalsIgnoreCase("Basic") && StringUtil.isNotEmpty((String)authorizationStrings[1])) {
            String[] clientIdAndKeys;
            String basicString = authorizationStrings[1];
            String clientIdAndKey = new String(Base64.getUrlDecoder().decode(basicString));
            String[] stringArray = clientIdAndKeys = StringUtil.isNotEmpty((String)clientIdAndKey) ? clientIdAndKey.split(":") : new String[]{};
            if (clientIdAndKeys.length == 2) {
                requestMap.put("client_id", clientIdAndKeys[0]);
                requestMap.put("client_secret", clientIdAndKeys[1]);
            }
        }
    }

    public static Map<String, String> getTokenInfo(Map<String, String> headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        String authType = "";
        String isNewTokenAuth = "0";
        String jwt = headers.get("jwt");
        String token = "";
        if (StringUtil.isNotEmpty((String)jwt)) {
            authType = "3";
            if (jwt.startsWith("OPENAPIAUTH_")) {
                isNewTokenAuth = "1";
            }
        } else {
            token = headers.get("access_token");
            if (StringUtil.isEmpty((String)token)) {
                token = headers.get("accesstoken");
            }
            if (StringUtil.isNotEmpty((String)token)) {
                authType = "1";
                if (token.startsWith("OPENAPIAUTH_")) {
                    isNewTokenAuth = "1";
                }
            }
        }
        result.put("authType", authType);
        result.put("access_token", token);
        result.put("jwt", jwt);
        result.put("isNewTokenAuth", isNewTokenAuth);
        return result;
    }
}

