/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.opp.plugin;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.acl.ApilAclManager;
import kd.bos.openapi.base.dataservice.OpenApiDataServiceImpl;
import kd.bos.openapi.base.util.CommonConfigUtil;
import kd.bos.openapi.base.util.DistributeCacheUtil;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.common.util.CacheUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.PasswordEncryptUtil;

public class ThirdAppClearCacheOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(OpenApiDataServiceImpl.class);
    private static final String OPENAPI_3RDAPPS = "third_app";
    private static final String THIRD_BASIC_ENTRY_IP = "entryentity_basicauth";
    private static final String THIRD_BASIC_SIGN_CODE = "basesigncode";
    private static final String COSMIC_LOCAL_APPLIST = "cosmic_local_applist";
    private static final String COSMIC_LOCAL_BASICAUTH = "cosmic_local_basicauth";
    private static final String SPLIT = "-";
    private static final String BASE_DATA = "basedata";
    private static final String CACHE_REGION = "login_region";
    private static final String OPENAPI_UNITTEST_NUM = "openapi_unittest";
    private static CacheConfigInfo localConfig = new CacheConfigInfo();

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Object[] dataEntities = e.getDataEntities();
        if (CollectionUtil.isEmpty((Object[])dataEntities)) {
            return;
        }
        String operationKey = e.getOperationKey();
        if ("delete".equals(operationKey)) {
            for (Object entity : dataEntities) {
                if (entity == null) continue;
                String thirdAppId = entity.getString("id");
                if (StringUtil.isNotEmpty((String)thirdAppId)) {
                    ApilAclManager.removeIpinfondThirdAppAcl((String)thirdAppId);
                    ThirdAppClearCacheOp.clearBasicAuthCache(thirdAppId);
                }
                if (!OPENAPI_UNITTEST_NUM.equals(entity.getString("number"))) continue;
                DistributeCacheUtil.removeCacheByKey((String)"bos_open_accesstoken", (String)("openapi_unittest_access_token_" + RequestContext.get().getUserId()));
            }
        } else if ("save".equals(operationKey)) {
            for (Object entity : dataEntities) {
                if (entity == null) continue;
                boolean isChangePwd = false;
                Iterable props = entity.getDataEntityState().getBizChangedProperties();
                for (IDataEntityProperty prop : props) {
                    if (!prop.getName().equals("syspwd")) continue;
                    isChangePwd = true;
                    break;
                }
                if (!isChangePwd) continue;
                String syspwd = entity.getString("syspwd");
                String thirdAppNum = entity.getString("number");
                if (!StringUtil.isNotEmpty((String)syspwd) || syspwd.length() == 160) continue;
                String encryptedPassword = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)syspwd);
                entity.set("syspwd", (Object)encryptedPassword);
                if (!OPENAPI_UNITTEST_NUM.equals(thirdAppNum)) continue;
                CommonConfigUtil.setValue((int)6, (String)"unittest_token", (String)EncrypterFactory.getEncrypter().encode(syspwd));
                DistributeCacheUtil.removeCacheByKey((String)"bos_open_accesstoken", (String)("openapi_unittest_access_token_" + RequestContext.get().getUserId()));
            }
        } else if ("disable".equals(operationKey)) {
            DistributeCacheUtil.removeCacheByKey((String)"bos_open_accesstoken", (String)("openapi_unittest_access_token_" + RequestContext.get().getUserId()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        Object[] dataEntities = e.getDataEntities();
        if (CollectionUtil.isEmpty((Object[])dataEntities)) {
            return;
        }
        String operationKey = e.getOperationKey();
        if ("save".equals(operationKey) || "enable".equals(operationKey) || "disable".equals(operationKey)) {
            for (Object entity : dataEntities) {
                String thirdAppId;
                if (entity == null || !StringUtil.isNotEmpty((String)(thirdAppId = entity.getString("id")))) continue;
                ApilAclManager.removeIpinfondThirdAppAcl((String)thirdAppId);
                ThirdAppClearCacheOp.clearBasicAuthCache(thirdAppId);
                ThirdAppClearCacheOp.saveOpenCert(thirdAppId);
                ThirdAppSecurityUtil.removeCache((String)RequestContext.get().getAccountId(), (String)thirdAppId);
                String number = entity.getString("number");
                ThirdAppSecurityUtil.removeThirdNumCache((String)RequestContext.get().getAccountId(), (String)number);
                CacheUtil.removeCacheByKey((String)"THIRDAPP_SSOLIST", (String)"THIRDAPP_SSOLIST".concat("_").concat(thirdAppId), (String)RequestContext.get().getAccountId());
            }
        }
    }

    private static void saveOpenCert(String thirdAppId) {
    }

    private static void clearBasicAuthCache(String thirdId) {
        LocalMemoryCache localMemoryCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CACHE_REGION, BASE_DATA, localConfig);
        localMemoryCache.remove(new String[]{COSMIC_LOCAL_APPLIST.concat(RequestContext.get().getAccountId())});
        LocalMemoryCache lMCOpen3rdAppsApi = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("OpenAPI".concat(RequestContext.get().getAccountId()), "Open3rdAppsApi", localConfig);
        lMCOpen3rdAppsApi.clear();
        String basicAuthKeyPrefix = COSMIC_LOCAL_BASICAUTH.concat(SPLIT).concat(RequestContext.get().getAccountId()).concat(SPLIT);
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(thirdId), (String)OPENAPI_3RDAPPS);
        if (object == null) {
            log.info("cannot find thirdId in clear cache.");
            return;
        }
        DynamicObjectCollection basicAuthObjectList = object.getDynamicObjectCollection(THIRD_BASIC_ENTRY_IP);
        if (basicAuthObjectList != null && !basicAuthObjectList.isEmpty()) {
            basicAuthObjectList.forEach(dynamicObject -> {
                String basicSignCode = dynamicObject.getString(THIRD_BASIC_SIGN_CODE);
                if (StringUtil.isNotEmpty((String)basicSignCode)) {
                    String basicAuthKey = basicAuthKeyPrefix.concat(basicSignCode);
                    localMemoryCache.remove(new String[]{basicAuthKey});
                }
            });
        }
    }

    static {
        localConfig.setMaxItemSize(5000);
        localConfig.setTimeout(600);
    }
}

