> 单个动态对象转map

#### 基本用法：

```js
DynamicObjectUtil.toMap(dyObject);
```

#### 参数说明：

| 参数     | 说明     | 类型          | 必填 |
| -------- | -------- | ------------- | ---- |
| dyObject | 动态对象 | DynamicObject | √    |

#### 结果说明：

返回map结构


#### 代码示例：

```js
//这里使用微服务调用返回动态对象
var dyObject = MS.invokeBosService("bos", "QueryService", "getDynamicObject", []);
DynamicObjectUtil.toMap(dyObject);
```

#### 输出结果：

```js
{
		"apiservicetype":"2",
		"modifytime":"2022-09-15 15:16:56.288",
		"modifier":
			{
				"masterid":"1484096962776031232",
				"_Type_":"bos_user",
				"multilanguagetext":[

					{
						"_Type_":"locale",
						"pkid":"2N=545T29SSY",
						"name":"weiyaofeng",
						"localeid":"zh_CN"
					},

					{
						"_Type_":"locale",
						"pkid":"2N=545T29SSZ",
						"name":"weiyaofeng",
						"localeid":"zh_TW"
					}
				],
          ......
```

