> 对象转JSON字符串

#### 基本用法：

```js
JSON.toJSONString(obj, features);
```

#### 参数说明：

| 参数     | 说明                                                         | 类型     | 必填 |
| -------- | ------------------------------------------------------------ | -------- | ---- |
| obj      | 转换对象                                                     | 任意类型 | √    |
| features | 序列化特性（`FJ_WriteDateUseDateFormat`：日期格式化，`FJ_WriteMapNullValue`：输出Map的null值， `FJ_WriteBigDecimalAsPlain`：BigDecimal序列化为字符串，`FJ_PrettyFormat`：格式化JSON缩进） | 数组     |      |

#### 结果说明：

JSON字符串


#### 代码示例：

```js
var map = {a:1, b:NOW, c:NewArray([11, "22"])};
JSON.toJSONString(map, [FJ_PrettyFormat, FJ_WriteDateUseDateFormat]);
```

#### 输出结果：

```js
{
	"a":1,
	"b":"2022-03-30 16:52:16",
	"c":[
		11,
		"22"
	]
}
```

