> 平台微服务调用

#### 基本用法：

```js
MS.invokeBosService(appId, serviceName, methodName, params);
```

#### 参数说明：

| 参数        | 说明           | 类型   | 必填 |
| ----------- | -------------- | ------ | ---- |
| appId       | 应用Id         | 字符串 | √    |
| serviceName | 注册的服务名称 | 字符串 | √    |
| methodName  | 调用服务方法   | 字符串 | √    |
| params      | 方法入参       | 数组   | √    |

#### 结果说明：

调用服务方法返回值


#### 代码示例：

```js
var result = MS.invokeBosService("bos", "QueryService", "startWebApiQuery", 
                    ["openapi_unittest", "id", null, null, 10]);
JSON.toJSONString(result, [FJ_PrettyFormat]);
```

#### 输出结果：

```js
{
	"cacheId":"datasetcache-51ed8462e68d4d33913693a81bd35669",
	"rows":16,
	"success":true
}
```
