> API调用，适用于请求地址以 **/V2** 开头的查询操作服务API

#### 基本用法：

```java
OpenApiResult result = OpenApiSdkUtil.query(String apiUrl, Map<String, Object> data, int pageSize, int pageNo);
```

#### 参数说明：

| 参数     | 说明      | 类型                | 必填 |
| -------- | --------- | ------------------- | ---- |
| apiUrl   | 请求地址  | String              | √    |
| data     | data 参数 | Map<String, Object> | √    |
| pageSize | 每页大小  | int                 | √    |
| pageNo   | 页码      | int                 | √    |

#### 结果说明：

> OpenApiResult

| 参数      | 说明                            | 类型     |
| --------- | ------------------------------- | -------- |
| status    | 状态：true - 成功, false - 失败 | boolean  |
| errorCode | 错误代码                        | String   |
| message   | 错误信息                        | String   |
| data      | 响应数据                        | 任意类型 |


#### 代码示例：

```java
String apiUrl = "/v2/xxxxx";

Map<String, Object> data = new HashMap<>();
data.put("number", "xxx");

OpenApiResult result = OpenApiSdkUtil.query(apiUrl, data, 10, 1);
```

