/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class EnableMultiOrgEditPlugin
extends AbstractFormPlugin {
    private static final String ICON_SINGLE = "/images/pc/other/danzuzhi.png";
    private static final String ICON_GROUP = "/images/pc/other/duozuzhijituan.png";
    private static final String KEY_ENABLEMULTORG = "enablemultorg";
    private static final String KEY_SAVE = "btsave";
    private static final String KEY_PRO_MAS = "PRO_MAS";
    private static final String BASE_APPID = "83bfebc8000037ac";
    private static final String BOS_ENABLE_MULTORG_ENTITY = "bos_enablemultorg";
    private static final String COMFIRM = "comfirm";
    private static final String RELOGIN = "relogin";
    private static final char MARK_NEW_LINE = '\n';

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap"});
        boolean isSingleOrg = this.isSingleOrg();
        this.getView().setEnable(Boolean.valueOf(isSingleOrg), new String[]{KEY_ENABLEMULTORG});
        this.getView().setVisible(Boolean.valueOf(isSingleOrg), new String[]{KEY_SAVE});
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        int result = mbce.getResult().getValue();
        switch (callBackId) {
            case "comfirm": {
                if (result != MessageBoxResult.Yes.getValue()) break;
                this.saveOrgManageMode(3);
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u542f\u7528\u591a\u7ec4\u7ec7", "EnableMultiOrgEditPlugin_0", "bos-org-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6210\u529f\u542f\u7528\u591a\u7ec4\u7ec7\u3002", "EnableMultiOrgEditPlugin_1", "bos-org-formplugin");
                this.writeLog(opName, opDesc, BOS_ENABLE_MULTORG_ENTITY, BASE_APPID);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u542f\u7528\u591a\u7ec4\u7ec7\u9700\u8981\u91cd\u65b0\u767b\u5f55\u624d\u80fd\u751f\u6548\u3002", (String)"EnableMultiOrgEditPlugin_2", (String)"bos-org-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener(RELOGIN, (IFormPlugin)this));
                break;
            }
            case "relogin": {
                this.loginout();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initialDesription(3);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String opkey = evt.getItemKey();
        if (KEY_SAVE.equals(opkey)) {
            boolean isEnableMultOrg = (Boolean)this.getModel().getValue(KEY_ENABLEMULTORG);
            if (!isEnableMultOrg) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u591a\u7ec4\u7ec7\uff0c\u518d\u70b9\u51fb\u5b8c\u6210\u64cd\u4f5c\u3002", (String)"EnableMultiOrgEditPlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0]));
                return;
            }
            LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)KEY_PRO_MAS);
            if (!checkResult.getHasLicense().booleanValue()) {
                this.getView().showErrorNotification(checkResult.getMsg());
                return;
            }
            StringBuilder warn = new StringBuilder();
            warn.append(ResManager.loadKDString((String)"\u542f\u7528\u591a\u7ec4\u7ec7\u540e\uff0c\u4e0d\u80fd\u8fd4\u56de\u5355\u4f53\u7ec4\u7ec7\u6a21\u5f0f\u3002", (String)"EnableMultiOrgEditPlugin_4", (String)"bos-org-formplugin", (Object[])new Object[0]));
            warn.append(System.lineSeparator());
            warn.append(ResManager.loadKDString((String)"\u786e\u8ba4\u542f\u7528\u591a\u7ec4\u7ec7\u5417\uff1f", (String)"EnableMultiOrgEditPlugin_5", (String)"bos-org-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(warn.toString(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(COMFIRM, (IFormPlugin)this));
        }
    }

    private void initialDesription(int orgManageMode) {
        IDataModel model = this.getModel();
        StringBuilder descTitle = new StringBuilder(ResManager.loadKDString((String)"\u5e94\u7528\u7279\u70b9\uff1a", (String)"EnableMultiOrgEditPlugin_6", (String)"bos-org-formplugin", (Object[])new Object[0]));
        StringBuilder describe = new StringBuilder();
        StringBuilder attention = new StringBuilder();
        String iconUrl = "";
        switch (orgManageMode) {
            case 1: {
                iconUrl = ICON_SINGLE;
                descTitle.append(ResManager.loadKDString((String)"\u5355\u4f53\u6cd5\u4eba\u7684\u72ec\u7acb\u8fd0\u8425", (String)"EnableMultiOrgEditPlugin_7", (String)"bos-org-formplugin", (Object[])new Object[0]));
                describe.append(ResManager.loadKDString((String)"\u4e2d\u5c0f\u578b\u6cd5\u4eba\u4f01\u4e1a", (String)"EnableMultiOrgEditPlugin_8", (String)"bos-org-formplugin", (Object[])new Object[0]));
                break;
            }
            case 3: {
                iconUrl = ICON_GROUP;
                descTitle.append(ResManager.loadKDString((String)"\u7740\u91cd\u534f\u4f5c\u4e0e\u5206\u5de5\u7684\u8fd0\u8425\u7ba1\u63a7", (String)"EnableMultiOrgEditPlugin_9", (String)"bos-org-formplugin", (Object[])new Object[0]));
                describe.append(ResManager.loadKDString((String)"\u5355\u6cd5\u4eba\u591a\u4e8b\u4e1a\u90e8\u72ec\u7acb\u6838\u7b97\u7684\u4f01\u4e1a", (String)"EnableMultiOrgEditPlugin_10", (String)"bos-org-formplugin", (Object[])new Object[0]));
                describe.append(System.lineSeparator());
                describe.append(ResManager.loadKDString((String)"\u5355\u6cd5\u4eba\u591a\u5de5\u5382\u72ec\u7acb\u6838\u7b97\u7684\u4f01\u4e1a", (String)"EnableMultiOrgEditPlugin_11", (String)"bos-org-formplugin", (Object[])new Object[0]));
                describe.append(System.lineSeparator());
                describe.append(ResManager.loadKDString((String)"\u5355\u6cd5\u4eba\u8de8\u5730\u57df\u7ecf\u8425\u8bbe\u7acb\u5206\u652f\u673a\u6784\u72ec\u7acb\u6838\u7b97\u7684\u4f01\u4e1a", (String)"EnableMultiOrgEditPlugin_12", (String)"bos-org-formplugin", (Object[])new Object[0]));
                describe.append(System.lineSeparator());
                describe.append(ResManager.loadKDString((String)"\u5355\u6cd5\u4eba\u591a\u95e8\u5e97\u72ec\u7acb\u6838\u7b97\u7684\u4f01\u4e1a", (String)"EnableMultiOrgEditPlugin_13", (String)"bos-org-formplugin", (Object[])new Object[0]));
                attention.append(ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879\uff1a", (String)"EnableMultiOrgEditPlugin_14", (String)"bos-org-formplugin", (Object[])new Object[0]));
                attention.append(System.lineSeparator());
                attention.append(ResManager.loadKDString((String)"1\u3001\u542f\u7528\u591a\u7ec4\u7ec7\u524d\u9700\u8981\u5148\u5907\u4efd\u6570\u636e\uff1b", (String)"EnableMultiOrgEditPlugin_15", (String)"bos-org-formplugin", (Object[])new Object[0]));
                attention.append(System.lineSeparator());
                attention.append(ResManager.loadKDString((String)"2\u3001\u672a\u8d2d\u4e70\u591a\u7ec4\u7ec7\u8bb8\u53ef\u7279\u6027\u4e0d\u8981\u542f\u7528\u591a\u7ec4\u7ec7\uff0c\u5426\u5219\u5bfc\u5165\u8bb8\u53ef\u540e\u6570\u636e\u4e2d\u5fc3\u65e0\u6cd5\u767b\u5f55\u4f7f\u7528\uff1b", (String)"EnableMultiOrgEditPlugin_16", (String)"bos-org-formplugin", (Object[])new Object[0]));
                attention.append(System.lineSeparator());
                attention.append(ResManager.loadKDString((String)"3\u3001\u542f\u7528\u591a\u7ec4\u7ec7\u540e\u4e0d\u80fd\u8fd4\u56de\u5355\u4f53\u7ec4\u7ec7\u6a21\u5f0f\uff1b", (String)"EnableMultiOrgEditPlugin_17", (String)"bos-org-formplugin", (Object[])new Object[0]));
                attention.append(System.lineSeparator());
                attention.append(ResManager.loadKDString((String)"4\u3001\u542f\u7528\u591a\u7ec4\u7ec7\u9700\u8981\u91cd\u65b0\u767b\u5f55\u624d\u751f\u6548\u3002", (String)"EnableMultiOrgEditPlugin_18", (String)"bos-org-formplugin", (Object[])new Object[0]));
                break;
            }
        }
        model.setValue("descriptiontitle", (Object)descTitle);
        model.setValue("description", (Object)describe);
        model.setValue("attention", (Object)attention);
        Image icon = (Image)this.getControl("icon");
        if (icon != null) {
            icon.setUrl(iconUrl);
        }
    }

    private void saveOrgManageMode(int orgManageMode) {
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        paramMap.put("orgmanagemode", Integer.toString(orgManageMode));
        paramMap.put("showcontent", "1,2,3,4");
        SystemParamServiceHelper.saveAppParameter((String)"15", (Long)((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId(), (Long)0L, null, paramMap);
    }

    private void writeLog(MultiLangEnumBridge opName, MultiLangEnumBridge opDesc, String bizObjId, String bizAppid) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        appLogInfo.setUserID(userId);
        appLogInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        appLogInfo.setOpTime(new Date());
        appLogInfo.setOpName("enableMultiOrg", opName);
        appLogInfo.setOpDesc(opDesc, new String[0]);
        appLogInfo.setBizObjID(bizObjId);
        appLogInfo.setBizAppID(bizAppid);
        appLogInfo.setClientType(RequestContext.get().getClient());
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }

    private void loginout() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> mpURL = new HashMap<String, String>();
        mpURL.put("url", "auth/logout.do");
        mpURL.put("openStyle", "0");
        proxy.addAction("openUrl", mpURL);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u9000\u51fa", "EnableMultiOrgEditPlugin_19", "bos-org-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u9000\u51fa\u6210\u529f", "EnableMultiOrgEditPlugin_20", "bos-org-formplugin");
        this.writeLog(opName, opDesc, "bos_user", BASE_APPID);
    }

    private boolean isSingleOrg() {
        int orgmanageMode = OrgUnitServiceHelper.getOrgmanageMode();
        return 1 == orgmanageMode;
    }
}

