/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Tab;
import kd.bos.form.field.FieldEdit;
import kd.bos.org.OrgFormPlugin;
import kd.bos.org.model.OrgParam;
import kd.bos.org.service.common.OrgParamValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgBillPlugin
extends OrgFormPlugin {
    private static final String HIDENINFO_TABPAGEAP = "tabpageap";

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.lockOrgUnitBiz(dataEntity);
        this.hiddenCompanyPanel(dataEntity);
        this.getView().getModel().setDataChanged(false);
    }

    @Override
    protected boolean isSetOrgPatternForGalaxy(DynamicObject dataEntity) {
        super.isSetOrgPatternForGalaxy(dataEntity);
        long orgId = dataEntity.getLong("id");
        if (orgId > 0L) {
            return true;
        }
        DynamicObject parentObj = dataEntity.getDynamicObject("parent");
        if (parentObj == null) {
            return true;
        }
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        long orgPatternId = 4L;
        if (rootOrgId == parentObj.getLong("id") && OrgParamValidator.checkCorporateLimitCountOfGalaxy((OrgParam)new OrgParam())) {
            orgPatternId = 1L;
        }
        this.getModel().setValue("orgpattern", (Object)orgPatternId);
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if ("orgpattern".equals(proName)) {
            DynamicObject obj = e.getChangeSet()[0].getDataEntity();
            this.hiddenCompanyPanel(obj);
            DynamicObject patternObj = obj.getDynamicObject("orgpattern");
            if (patternObj == null) {
                return;
            }
            long patternId = patternObj.getLong("id");
            String orgManageMode = this.getPageCache().get("orgmanagemode");
            if (Integer.toString(3).equals(orgManageMode) && (patternId == 7L || patternId == 1L)) {
                this.getModel().setValue("fisaccounting", (Object)Boolean.TRUE);
            }
        } else {
            this.bizPropertyChanged(proName, e.getChangeSet()[0].getNewValue());
        }
    }

    private void bizPropertyChanged(String proName, Object value) {
        if (!(value instanceof Boolean)) {
            return;
        }
        if (Boolean.parseBoolean(value.toString())) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (!dataEntity.getDataEntityState().getFromDatabase()) {
            return;
        }
        DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((Object)dataEntity.getPkValue(), (DynamicObjectType)dataEntity.getDynamicObjectType());
        if (orgObj == null) {
            return;
        }
        DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
        for (DynamicObject structureObj : structureObjCol) {
            DynamicObject bizObj;
            DynamicObject viewObj;
            DynamicObject parentObj = structureObj.getDynamicObject("viewparent");
            if (parentObj != null || structureObj.getBoolean("isleaf") || (viewObj = structureObj.getDynamicObject("view")) == null || (bizObj = viewObj.getDynamicObject("treetypeid")) == null || (bizObj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizObj.getPkValue(), (String)"bos_org_biz")) == null || !Objects.equals(proName, bizObj.get("propertyname"))) continue;
            this.getView().showTipNotification(OrgMessage.getMessage((String)"M00225", (Object[])new Object[]{bizObj.getString("fname")}), Integer.valueOf(5000));
            this.getModel().beginInit();
            this.getModel().setValue(proName, (Object)Boolean.TRUE);
            this.getModel().endInit();
            this.getView().updateView(proName);
            break;
        }
    }

    private void lockOrgUnitBiz(DynamicObject orgObj) {
        HashSet<String> lockProperties = new HashSet<String>(64);
        int orgManageMode = OrgUnitServiceHelper.getOrgmanageMode();
        this.getPageCache().put("orgmanagemode", Integer.toString(orgManageMode));
        Long orgID = (Long)orgObj.getPkValue();
        Map bizMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", null);
        if (1 == orgManageMode) {
            this.lockOrgUnitBizWhenSingleMode(orgID, bizMap, lockProperties);
        } else {
            this.lockOrgUnitBizWhenGroupMode(orgID, lockProperties);
        }
        this.showPresetBiz(bizMap, orgObj);
        this.lockFreezeBiz(bizMap, lockProperties);
        if (!lockProperties.isEmpty()) {
            this.getView().setEnable(Boolean.valueOf(false), lockProperties.toArray(new String[0]));
        }
    }

    private void lockOrgUnitBizWhenSingleMode(long orgID, Map<Object, DynamicObject> bizMap, Set<String> lockProperties) {
        if (OrgUnitServiceHelper.getRootOrgId() == orgID) {
            lockProperties.add("fisaccounting");
        } else {
            for (DynamicObject dyo : bizMap.values()) {
                String propertyName = dyo.getString("propertyname");
                if (StringUtils.isBlank((CharSequence)propertyName)) continue;
                lockProperties.add(propertyName);
            }
        }
    }

    private void lockOrgUnitBizWhenGroupMode(long orgID, Set<String> lockProperties) {
        if (OrgUnitServiceHelper.getRootOrgId() == orgID) {
            lockProperties.add("fisaccounting");
        }
        if (orgID == 0L) {
            this.getModel().setValue("fisaccounting", (Object)Boolean.TRUE);
        }
    }

    private void showPresetBiz(Map<Object, DynamicObject> bizMap, DynamicObject orgObj) {
        int count = bizMap.size();
        HashMap<String, DynamicObject> visibleMap = new HashMap<String, DynamicObject>(count);
        ArrayList<String> oldDutyList = new ArrayList<String>(count);
        this.getShowPresetBiz(bizMap, orgObj, visibleMap, oldDutyList);
        this.getPageCache().put("treetype", SerializationUtils.toJsonString(oldDutyList));
        for (int i = 1; i <= 10; ++i) {
            String propertyName = "fispresetbiz" + i;
            DynamicObject bizObj = (DynamicObject)visibleMap.get(propertyName);
            if (bizObj == null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{propertyName});
                continue;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{propertyName});
            String bizName = bizObj.getString("fname");
            FieldEdit bizField = (FieldEdit)this.getControl(propertyName);
            if (bizField == null) continue;
            bizField.setText(bizName);
            bizField.setCaption(new LocaleString(bizName));
        }
    }

    private void getShowPresetBiz(Map<Object, DynamicObject> bizMap, DynamicObject orgObj, Map<String, DynamicObject> visibleMap, List<String> oldDutyList) {
        for (DynamicObject bizObj : bizMap.values()) {
            String propertyName = bizObj.getString("propertyname");
            if (StringUtils.isBlank((CharSequence)propertyName)) continue;
            FieldEdit bizField = (FieldEdit)this.getControl(propertyName);
            if (bizField != null) {
                String bizName = bizObj.getString("fname");
                bizField.setText(bizName);
            }
            if (bizObj.getBoolean("enable") && bizObj.getBoolean("visiable") && bizObj.getBoolean("basemaintain")) {
                if (orgObj.getBoolean(propertyName) && orgObj.getLong("id") != 0L) {
                    String treeType = bizObj.getString("fnumber");
                    oldDutyList.add(treeType);
                }
                if (!propertyName.startsWith("fispresetbiz")) continue;
                visibleMap.put(propertyName, bizObj);
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{propertyName});
        }
    }

    private void hiddenCompanyPanel(DynamicObject obj) {
        DynamicObject patternObj = obj.getDynamicObject("orgpattern");
        if (patternObj == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{HIDENINFO_TABPAGEAP});
            return;
        }
        String patterntype = patternObj.getString("patterntype");
        if ("1".equals(patterntype) || "2".equals(patterntype)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{HIDENINFO_TABPAGEAP});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{HIDENINFO_TABPAGEAP});
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab("tabpageap1");
            if ("3".equalsIgnoreCase(patterntype) || "4".equalsIgnoreCase(patterntype)) {
                this.getModel().setValue("uniformsocialcreditcode", (Object)"");
                this.getModel().setValue("ftaxregnum", (Object)"");
            }
        }
    }

    private void lockFreezeBiz(Map<Object, DynamicObject> bizMap, Set<String> lockProperties) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("structure");
        ArrayList<String> freezeProperties = new ArrayList<String>(entryEntity.size());
        for (DynamicObject structureObj : entryEntity) {
            String property;
            DynamicObject bizObj;
            DynamicObject viewBizObj;
            DynamicObject viewObj;
            if (!structureObj.getBoolean("isfreeze") || (viewObj = structureObj.getDynamicObject("view")) == null || (viewBizObj = viewObj.getDynamicObject("treetypeid")) == null || (bizObj = bizMap.get(viewBizObj.getPkValue())) == null || !StringUtils.isNotBlank((CharSequence)(property = bizObj.getString("propertyname")))) continue;
            freezeProperties.add(property);
        }
        if (!freezeProperties.isEmpty()) {
            lockProperties.addAll(freezeProperties);
            String freezeLabel = BaseMessage.getMessage((String)"M00069");
            for (String property : freezeProperties) {
                LocaleString displayName;
                FieldEdit bizField = (FieldEdit)this.getControl(property);
                if (bizField == null || (displayName = bizField.getProperty().getDisplayName()) == null) continue;
                bizField.setCaption(new LocaleString(displayName.getLocaleValue() + freezeLabel));
            }
        }
    }
}

