/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.org.biz.view.OrgViewSchemaRefrenceChecker;
import kd.bos.org.manager.OrgLeafUtils;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.yzj.interfaces.IYzjOrgService;
import kd.bos.yzj.model.org.YzjOrgParam;
import kd.bos.yzj.service.YzjServiceFactory;

public class OrgDeleteTreeListPlugin
extends StandardTreeListPlugin {
    private boolean isSearchClick = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        OrgTreeParam param = new OrgTreeParam();
        TreeNode root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (root != null) {
            this.getTreeModel().setRoot(root);
            this.getTreeModel().setCurrentNodeId((Object)root.getId());
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        OrgTreeParam param = new OrgTreeParam();
        param.setId(Long.parseLong(nodeId));
        param.setOrgViewType("15");
        e.setChildNodes(OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param));
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.isSearchClick = true;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        String nodeId = e.getNodeId().toString();
        if (StringUtils.isBlank((CharSequence)nodeId) || this.treeListView.getTreeModel().getRoot().getId() == nodeId) {
            return;
        }
        if (this.isSearchClick) {
            this.isSearchClick = false;
        } else {
            List orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)15L, Collections.singletonList(Long.valueOf(nodeId)), (boolean)true);
            QFilter orgFilter = new QFilter("id", "in", (Object)orgIds);
            e.addQFilter(orgFilter);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "bar_delete": {
                BillList biiiList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection seletedRows = biiiList.getSelectedRows();
                if (!Utils.isListEmpty((List)seletedRows)) break;
                this.getView().showTipNotification(BaseMessage.getMessage((String)"M00020"));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "bar_delete": {
                this.getView().showConfirm(OrgMessage.getMessage((String)"M00031"), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete"));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        evt.getResult();
        if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            return;
        }
        String callBackId = evt.getCallBackId();
        if (!"delete".equals(callBackId)) {
            return;
        }
        BillList biiiList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection seletedRows = biiiList.getSelectedRows();
        ArrayList<Long> orgIds = new ArrayList<Long>(seletedRows.size());
        for (ListSelectedRow row : seletedRows) {
            orgIds.add(Long.valueOf(row.getPrimaryKeyValue().toString()));
        }
        if (!this.isDeleteAble(orgIds)) {
            return;
        }
        if (!this.deletedFromYzj(orgIds)) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                this.delete(orgIds);
            }
            catch (Exception e) {
                h.markRollback();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u5220\u9664\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a%1$s", (String)"OrgDeleteTreeListPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
        this.refresh(orgIds);
    }

    private boolean isDeleteAble(List<Long> orgIds) {
        HashSet<String> ignoreEntitySet = new HashSet<String>();
        ignoreEntitySet.add("bos_org_history");
        ignoreEntitySet.add("bos_org_structure");
        ignoreEntitySet.add("bos_org_structure_history");
        ignoreEntitySet.add("bos_adminorg_structure");
        ignoreEntitySet.add("bos_maindataorg");
        ignoreEntitySet.add("bos_yzj_org");
        ignoreEntitySet.add("bos_yzj_user");
        String refErrorMsg = OrgViewSchemaRefrenceChecker.isRefrenced(orgIds, ignoreEntitySet, "bos_org");
        if (StringUtils.isNotBlank((CharSequence)refErrorMsg)) {
            this.getView().showTipNotification(refErrorMsg);
            return false;
        }
        return true;
    }

    private boolean deletedFromYzj(List<Long> orgIds) {
        ArrayList<YzjOrgParam> paramList = new ArrayList<YzjOrgParam>();
        QFilter adminFilter = new QFilter("fisadministrative", "=", (Object)Boolean.TRUE);
        QFilter adminOrgFilter = new QFilter("id", "in", orgIds);
        QFilter[] adminOrgFilters = new QFilter[]{adminFilter, adminOrgFilter};
        DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.org.OrgDeleteTreeListPlugin.delete", (String)"bos_org", (String)"fyzjorgid", (QFilter[])adminOrgFilters, null);
        Object object = null;
        try {
            if (!ds.hasNext()) {
                boolean bl = true;
                return bl;
            }
            for (Row row : ds) {
                YzjOrgParam param = new YzjOrgParam();
                String yzjOrgId = row.getString("fyzjorgid");
                if (!StringUtils.isNotBlank((CharSequence)yzjOrgId)) continue;
                param.setYzjOrgId(yzjOrgId);
                paramList.add(param);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (paramList.isEmpty()) {
            return true;
        }
        IYzjOrgService yzjService = YzjServiceFactory.getOrgService();
        yzjService.deleteById(paramList);
        for (YzjOrgParam orgParam : paramList) {
            if (orgParam.isSuccess()) continue;
            this.getView().showTipNotification(orgParam.getMsg());
            return false;
        }
        return true;
    }

    private void delete(List<Long> orgIds) {
        OrgLeafUtils.updateParentOrgLeaf(orgIds);
        QFilter orgStrucFilter = new QFilter("org", "in", orgIds);
        QFilter[] orgStrucFilters = new QFilter[]{orgStrucFilter};
        DeleteServiceHelper.delete((String)"bos_org_structure", (QFilter[])orgStrucFilters);
        QFilter orgFilter = new QFilter("id", "in", orgIds);
        QFilter[] orgFilters = new QFilter[]{orgFilter};
        DeleteServiceHelper.delete((String)"bos_org", (QFilter[])orgFilters);
    }

    private void refresh(List<Long> orgIds) {
        TreeView treeView = this.treeListView.getTreeView();
        Map focusNodeMap = treeView.getTreeState().getFocusNode();
        List deleteNodeList = orgIds.stream().map(orgId -> Long.toString(orgId)).collect(Collectors.toList());
        treeView.deleteNodes(deleteNodeList);
        if (focusNodeMap == null) {
            treeView.treeNodeClick("", this.getTreeModel().getRoot().getId());
        } else {
            String parentNodeId = focusNodeMap.get("parentid").toString();
            if (StringUtils.isNotBlank((CharSequence)parentNodeId) && deleteNodeList.contains(parentNodeId)) {
                treeView.treeNodeClick("", parentNodeId);
            } else {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
            }
        }
    }
}

