/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.org.utils.OrgCheckerUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrgDisableValidator
extends AbstractValidator {
    public void validate() {
        HashMap<Object, ExtendedDataEntity> dataEntityMap = new HashMap<Object, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            dataEntityMap.put(dataEntity.getDataEntity().getPkValue(), dataEntity);
        }
        this.validateAdminOrg(dataEntityMap);
        this.orgCheckerValidate(dataEntityMap);
    }

    private void validateAdminOrg(Map<Object, ExtendedDataEntity> dataEntityMap) {
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter orgFilter = new QFilter("org", "in", dataEntityMap.keySet());
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        enableFilter = enableFilter.and(new QFilter("org.enable", "=", (Object)Boolean.TRUE));
        QFilter[] filters = new QFilter[]{freezeFilter, viewFilter, orgFilter, enableFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgDisableValidator.validateAdminOrg", (String)"bos_org_structure", (String)"org", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                ExtendedDataEntity dataEntity = dataEntityMap.get(row.getLong("org"));
                if (dataEntity == null) continue;
                this.addErrorMessage(dataEntity, OrgMessage.getMessage((String)"M00129"));
            }
        }
    }

    private void orgCheckerValidate(Map<Object, ExtendedDataEntity> dataEntityMap) {
        ArrayList orgIds = new ArrayList();
        dataEntityMap.keySet().forEach(id -> orgIds.add((Long)id));
        ArrayList<Long> viewIds = new ArrayList<Long>();
        viewIds.add(0L);
        HashMap operationParams = new HashMap(this.getOption().getVariables());
        Map checkerOrgViewErrorMap = OrgCheckerUtils.execute((String)"disable", orgIds, viewIds, operationParams);
        for (Map.Entry org2View2ErrorsEntry : checkerOrgViewErrorMap.entrySet()) {
            Long orgId;
            ExtendedDataEntity extendedDataEntity;
            Map view2ErrorsMap = (Map)org2View2ErrorsEntry.getValue();
            if (CollectionUtils.isEmpty((Map)view2ErrorsMap) || (extendedDataEntity = dataEntityMap.get(orgId = (Long)org2View2ErrorsEntry.getKey())) == null) continue;
            for (Map.Entry view2ErrorsEntry : view2ErrorsMap.entrySet()) {
                Set errors = (Set)view2ErrorsEntry.getValue();
                if (CollectionUtils.isEmpty((Collection)errors)) continue;
                for (String error : errors) {
                    this.addErrorMessage(extendedDataEntity, error);
                }
            }
        }
    }
}

