/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org;

import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.org.utils.OrgUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgEnableValidator
extends AbstractValidator {
    public void validate() {
        this.validateOrgPattern();
    }

    private void validateOrgPattern() {
        if (!OrgUnitServiceHelper.isGalaxyUltimate()) {
            return;
        }
        int corporateOrgCount = -1;
        int corporateLimitCount = -1;
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject orgObj = dataEntity.getDataEntity();
            DynamicObject patternObj = orgObj.getDynamicObject("orgpattern");
            if (patternObj == null || !"1".equals(patternObj.getString("patterntype"))) continue;
            if (corporateOrgCount == -1) {
                corporateOrgCount = OrgUtils.getCorporateOrgIds((boolean)false).size();
            }
            if (corporateLimitCount == -1) {
                corporateLimitCount = OrgUnitServiceHelper.getCorporateLimitCountOfGalaxy();
            }
            if (corporateOrgCount >= corporateLimitCount) {
                this.addErrorMessage(dataEntity, OrgMessage.getMessage((String)"M00152", (Object[])new Object[]{corporateLimitCount, corporateOrgCount - corporateLimitCount + 1}));
                continue;
            }
            ++corporateOrgCount;
        }
    }
}

