/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org;

import java.util.EventObject;
import java.util.HashMap;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.OrgParam;
import kd.bos.org.service.common.OrgParamValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgFormPlugin
extends AbstractFormPlugin {
    private static final String TOOL_BARNAME = "tbmain";

    public String getOrgViewType() {
        return "15";
    }

    public void registerListener(EventObject e) {
        BasedataEdit orgPattern;
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOL_BARNAME});
        OrgEdit parentOrg = (OrgEdit)this.getControl("parent");
        if (parentOrg != null) {
            parentOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
                String orgViewType = this.getOrgViewType();
                formShowParameter.setCustomParam("orgFuncId", (Object)orgViewType);
                formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)orgViewType);
                OrgEdit parentOrg1 = (OrgEdit)beforeF7SelectEvent.getSource();
                parentOrg1.setOrgFunc(orgViewType);
                OrgProp orgProp = (OrgProp)beforeF7SelectEvent.getProperty();
                orgProp.setOrgFunc(orgViewType);
            });
        }
        if ((orgPattern = (BasedataEdit)this.getControl("orgpattern")) != null) {
            orgPattern.addBeforeF7SelectListener(event -> {
                ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
                this.filterOrgPatternForGalaxy(listShowParameter);
            });
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindOtherData();
        if (OrgUnitServiceHelper.isGalaxyUltimate()) {
            this.isSetOrgPatternForGalaxy(this.getModel().getDataEntity());
        }
        this.getView().getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        if (eventArgs.getSource() instanceof Save) {
            OperationResult operationResult = eventArgs.getOperationResult();
            if (operationResult == null || !operationResult.isSuccess()) {
                return;
            }
            this.getParentAndCacheView(null);
            this.getPageCache().put("returnOperationToParent", "save");
        }
    }

    private void filterOrgPatternForGalaxy(ListShowParameter listShowParameter) {
        QFilter filter;
        if (!OrgUnitServiceHelper.isGalaxyUltimate()) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long orgId = dataEntity.getLong("id");
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        if (rootOrgId == orgId) {
            filter = new QFilter("id", "in", (Object)new Long[]{7L, 8L});
        } else {
            filter = new QFilter("id", "not in", (Object)new Long[]{7L, 8L});
            DynamicObject parentObj = dataEntity.getDynamicObject("parent");
            if (dataEntity.getBoolean("isbizorg")) {
                boolean includeCorporate;
                if (parentObj != null && rootOrgId != parentObj.getLong("id")) {
                    includeCorporate = false;
                } else {
                    OrgParam orgParam = new OrgParam();
                    orgParam.setId(orgId);
                    includeCorporate = OrgParamValidator.checkCorporateLimitCountOfGalaxy((OrgParam)orgParam);
                }
                if (!includeCorporate) {
                    filter = filter.and(new QFilter("patterntype", "!=", (Object)"1"));
                }
            }
        }
        listShowParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private void bindOtherData() {
        DynamicObject orgObj = this.getModel().getDataEntity();
        long orgID = orgObj.getLong("id");
        boolean fromDatabase = orgObj.getDataEntityState().getFromDatabase();
        this.bindParentData(fromDatabase);
        if (OrgUnitServiceHelper.getRootOrgId() == orgID) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"parent"});
        } else {
            OrgEdit parentOrgEdit = (OrgEdit)this.getControl("parent");
            parentOrgEdit.setMustInput(true);
        }
    }

    protected boolean isSetOrgPatternForGalaxy(DynamicObject dataEntity) {
        return true;
    }

    private void bindParentData(boolean fromDatabase) {
        Object parentId = fromDatabase ? this.getParentAndCacheView(this.getOrgViewType()) : this.getView().getFormShowParameter().getCustomParam("parent");
        if (parentId != null) {
            this.getModel().setValue("parent", parentId);
        }
    }

    private Object getParentAndCacheView(String viewNumber) {
        Object parentId = null;
        DynamicObjectCollection structureObjCol = this.getModel().getDataEntity().getDynamicObjectCollection("structure");
        TreeMap<String, String> checkedParentViewMap = new TreeMap<String, String>();
        for (DynamicObject structureObj : structureObjCol) {
            DynamicObject bizObj;
            long viewId;
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            if (viewObj == null) continue;
            String currentViewNumber = viewObj.getString("number");
            if (viewNumber != null && viewNumber.equals(currentViewNumber)) {
                if (parentId == null) {
                    DynamicObject parentObj = structureObj.getDynamicObject("viewparent");
                    Object object = parentId = parentObj == null ? Long.valueOf(0L) : parentObj.getPkValue();
                }
                if (structureObj.getBoolean("isfreeze")) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
                }
            }
            if (15L == (viewId = viewObj.getLong("id")) || 16L == viewId || !viewObj.getBoolean("isdefault") || structureObj.getBoolean("isleaf") || (bizObj = viewObj.getDynamicObject("treetypeid")) == null) continue;
            checkedParentViewMap.put(currentViewNumber, bizObj.getString("fname"));
        }
        this.getPageCache().put("originalCheckedParentView", SerializationUtils.toJsonString(checkedParentViewMap));
        return parentId;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String pkid = "0";
        Object pk = this.getModel().getDataEntity().getPkValue();
        if (pk != null) {
            pkid = pk.toString();
        }
        boolean isCloseOperation = false;
        if (!(this.getModel().getDataChanged() && !"0".equals(pkid) || "save".equals(this.getPageCache().get("returnOperationToParent")))) {
            isCloseOperation = true;
        }
        if (isCloseOperation) {
            HashMap<String, String> returnData = new HashMap<String, String>();
            returnData.put("operation", "tblclose");
            this.getView().returnDataToParent(returnData);
        } else {
            this.generateReturnData(pkid);
        }
    }

    private void generateReturnData(String orgId) {
        HashMap<String, TreeNode> returnData = new HashMap<String, TreeNode>();
        DynamicObject parentObj = (DynamicObject)this.getModel().getValue("parent");
        String parentId = "0";
        if (parentObj != null) {
            parentId = parentObj.getPkValue().toString();
        }
        boolean isLeaf = true;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCustomParam("isleaf") != null) {
            isLeaf = (Boolean)formShowParameter.getCustomParam("isleaf");
        }
        if ("0".equals(parentId)) {
            parentId = "";
        }
        DynamicObject orgObj = this.getModel().getDataEntity();
        String name = orgObj.getString("name");
        name = OrgUnitServiceHelper.formatOrgTreeNodeName((String)orgObj.getString("number"), (String)name);
        TreeNode treeNode = new TreeNode(parentId, orgId, name, !isLeaf);
        returnData.put("TreeNode", treeNode);
        this.getView().returnDataToParent(returnData);
    }
}

