/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.org.utils.OrgUtils;

public class OrgImportFormPlugin
extends AbstractFormPlugin {
    private Map<String, DynamicObject> notBaseMaintainBizViewNumberMap;

    public void beforeImportData(BeforeImportDataEventArgs e) {
        if (e.getSourceData() instanceof JSONObject) {
            JSONArray structureArr = ((JSONObject)e.getSourceData()).getJSONArray("structure");
            this.validateBaseMaintainView(e, structureArr);
        }
    }

    private void validateBaseMaintainView(BeforeImportDataEventArgs e, JSONArray structureArr) {
        if (structureArr == null || structureArr.isEmpty()) {
            return;
        }
        if (this.notBaseMaintainBizViewNumberMap == null) {
            this.notBaseMaintainBizViewNumberMap = OrgUtils.getNotBaseMaintainViewMap();
        }
        AppInfo baseAppInfo = AppMetadataCache.getAppInfoByNumber((String)"base");
        String appName = "";
        if (baseAppInfo != null && baseAppInfo.getName() != null) {
            appName = baseAppInfo.getName().getLocaleValue();
        }
        for (Object structureObj : structureArr) {
            JSONObject viewJsonObj = ((JSONObject)structureObj).getJSONObject("view");
            if (viewJsonObj == null) continue;
            Object number = viewJsonObj.get((Object)"number");
            if (StringUtils.isBlank((Object)number)) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), OrgMessage.getMessage((String)"M00002"));
                continue;
            }
            DynamicObject viewObj = this.notBaseMaintainBizViewNumberMap.get(number);
            if (viewObj == null) continue;
            e.setCancel(true);
            if (viewObj.getBoolean("isdefault")) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), OrgMessage.getMessage((String)"M00180", (Object[])new Object[]{appName}));
                continue;
            }
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(-1), OrgMessage.getMessage((String)"M00181"));
        }
    }
}

