/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.org.history.OrgHistoryUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgOperationServicePlugIn
extends AbstractOperationServicePlugIn {
    protected static final int ORG_BIZ_INIT_COUNT = 64;

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (e.getDataEntities() == null || e.getDataEntities().length == 0) {
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(e.getDataEntities().length);
        for (DynamicObject org : e.getDataEntities()) {
            orgIds.add(org.getLong("id"));
        }
        String operationKey = e.getOperationKey().toLowerCase();
        if ("enable".equals(operationKey) || "disable".equals(operationKey)) {
            OrgHistoryUtils.saveOrgHistory(orgIds);
            OrgHistoryUtils.saveOrgStructureHistory(orgIds);
        }
        PermissionServiceHelper.clearAllCache();
    }
}

