/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgRelationItem;
import kd.bos.entity.property.org.OrgRelationItemDirect;
import kd.bos.entity.property.org.OrgRelationItemOrg;
import kd.bos.entity.property.org.OrgRelationItemType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.org.controller.filter.OrgRelationFilter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OrgRelationCheckPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String ENTITY_OBJ = "entityobj";
    private static final String RELATION_TYPE_ENTRY = "relationtypeentry";
    private static final String TO_ORG_ENTRY = "toorgentry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        OrgEdit fromOrg = (OrgEdit)this.getControl("fromorg");
        fromOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        OrgEdit toOrg = (OrgEdit)this.getControl("toorg");
        toOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid leftEntry = (EntryGrid)this.getControl(RELATION_TYPE_ENTRY);
        if (leftEntry != null) {
            leftEntry.addRowClickListener((RowClickEventListener)this);
        }
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        if ("tblrefresh".equals(evt.getItemKey())) {
            this.refreshAll();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String evtKey;
        Object source = evt.getSource();
        if (source instanceof EntryGrid && RELATION_TYPE_ENTRY.equals(evtKey = ((EntryGrid)source).getKey())) {
            this.refreshOrg(evt.getRow());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ENTITY_OBJ.equals(name)) {
            this.refreshAll();
        } else if ("fromorg".equals(name)) {
            this.refreshOrg(this.getSelectedRowIndex());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if ("fromorg".equals(name)) {
            this.setOrgFuncId(event, "fromtype");
        } else if ("toorg".equals(name)) {
            if (this.getModel().getValue("fromorg") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5173\u8054\u7ec4\u7ec7\u3002", (String)"OrgRelationCheckPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            this.setOrgFuncId(event, "totype");
        }
    }

    private void refreshAll() {
        OrgEdit orgEdit = (OrgEdit)this.getControl("toorg");
        orgEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u672c\u7ec4\u7ec7", (String)"OrgRelationCheckPlugin_9", (String)"bos-org-formplugin", (Object[])new Object[0])));
        OrgEdit fromOrgEdit = (OrgEdit)this.getControl("fromorg");
        fromOrgEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5173\u8054\u7ec4\u7ec7", (String)"OrgRelationCheckPlugin_10", (String)"bos-org-formplugin", (Object[])new Object[0])));
        this.getModel().deleteEntryData(RELATION_TYPE_ENTRY);
        this.getModel().deleteEntryData(TO_ORG_ENTRY);
        this.getModel().setValue("toorg", null);
        DynamicObject entityObj = (DynamicObject)this.getModel().getValue(ENTITY_OBJ);
        if (entityObj != null) {
            this.readOrgRelation(entityObj);
        }
    }

    private void readOrgRelation(DynamicObject entityObj) {
        String entityId = entityObj.getPkValue().toString();
        EntityMetadata runtimeMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        if (runtimeMeta == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u83b7\u53d6\u8fd0\u884c\u65f6\u8868\u5355\u4fe1\u606f\u5931\u8d25\u3002", (String)"OrgRelationCheckPlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0]), entityId));
            return;
        }
        List items = runtimeMeta.getItems();
        if (CollectionUtils.isEmpty((Collection)items)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8868\u5355\u4e0d\u5b58\u5728\u5b57\u6bb5\u4fe1\u606f\u3002", (String)"OrgRelationCheckPlugin_4", (String)"bos-org-formplugin", (Object[])new Object[0]), entityId));
            return;
        }
        int count = items.size();
        TreeMap<OrgField, List> orgRelationMap = new TreeMap<OrgField, List>(Comparator.comparing(AbstractElement::getKey));
        HashSet<String> relationTypeNumberList = new HashSet<String>(count);
        for (EntityItem item : items) {
            OrgField orgField;
            List orgRelation;
            if (!(item instanceof OrgField) || CollectionUtils.isEmpty((Collection)(orgRelation = (orgField = (OrgField)item).getOrgRelation()))) continue;
            orgRelationMap.computeIfAbsent(orgField, v -> new ArrayList()).addAll(orgRelation);
            for (OrgRelationItem relationItem : orgRelation) {
                OrgRelationItemType relationItemType = relationItem.getType();
                relationTypeNumberList.add(relationItemType.getNumber());
            }
        }
        if (CollectionUtils.isEmpty(orgRelationMap)) {
            return;
        }
        Map<String, DynamicObject> relationIdMap = this.getRelationType(relationTypeNumberList);
        Map<String, DynamicObject> bizIdMap = this.getBiz();
        for (Map.Entry entry : orgRelationMap.entrySet()) {
            OrgField orgField = (OrgField)entry.getKey();
            List orgRelationItemList = (List)entry.getValue();
            for (OrgRelationItem relationItem : orgRelationItemList) {
                int index = this.getModel().createNewEntryRow(RELATION_TYPE_ENTRY);
                OrgRelationItemType relationItemType = relationItem.getType();
                this.getModel().setValue("relationitem", (Object)SerializationUtils.toJsonString((Object)relationItem), index);
                this.getModel().setValue("relationtype", (Object)relationIdMap.get(relationItemType.getNumber()), index);
                OrgRelationItemDirect direct = relationItem.getDirect();
                this.getModel().setValue("direct", (Object)direct.getIndex(), index);
                this.getModel().setValue("directname", (Object)direct.getDisplay(), index);
                OrgRelationItemOrg org = relationItem.getOrg();
                this.getModel().setValue("tofieldname", (Object)this.getOrgDisplayName(runtimeMeta, (EntityItem)orgField), index);
                this.getModel().setValue("fromfieldname", (Object)this.getOrgDisplayName(runtimeMeta, runtimeMeta.getItemById(org.getId())), index);
                if ("fromorg".equals(direct.getIndex())) {
                    this.getModel().setValue("totype", (Object)bizIdMap.get(relationItemType.getFromtype()), index);
                    this.getModel().setValue("fromtype", (Object)bizIdMap.get(relationItemType.getTotype()), index);
                    continue;
                }
                this.getModel().setValue("totype", (Object)bizIdMap.get(relationItemType.getTotype()), index);
                this.getModel().setValue("fromtype", (Object)bizIdMap.get(relationItemType.getFromtype()), index);
            }
        }
    }

    private String getOrgDisplayName(EntityMetadata runtimeMeta, EntityItem item) {
        String orgDisplayName = "";
        if (item == null) {
            return orgDisplayName;
        }
        EntityItem parentItem = runtimeMeta.getItemById(item.getParentId());
        if (parentItem == null || parentItem instanceof BillEntity) {
            orgDisplayName = ResManager.loadKDString((String)"\u5355\u5934\u00b7", (String)"OrgRelationCheckPlugin_5", (String)"bos-org-formplugin", (Object[])new Object[0]);
        } else if (parentItem instanceof SubEntryEntity) {
            orgDisplayName = ResManager.loadKDString((String)"\u5b50\u5355\u4f53\u00b7", (String)"OrgRelationCheckPlugin_6", (String)"bos-org-formplugin", (Object[])new Object[0]);
        } else if (parentItem instanceof EntryEntity) {
            orgDisplayName = ResManager.loadKDString((String)"\u5355\u4f53\u00b7", (String)"OrgRelationCheckPlugin_7", (String)"bos-org-formplugin", (Object[])new Object[0]);
        }
        return String.format("(%s)%s", item.getKey(), orgDisplayName + item.getName());
    }

    private Map<String, DynamicObject> getRelationType(Set<String> numberList) {
        HashMap<String, DynamicObject> numberObjMap = new HashMap<String, DynamicObject>(numberList.size());
        QFilter numberFilter = new QFilter("number", "in", numberList);
        QFilter[] filters = new QFilter[]{numberFilter};
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_typerelation", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)objectMap)) {
            return numberObjMap;
        }
        for (Map.Entry entry : objectMap.entrySet()) {
            DynamicObject obj = (DynamicObject)entry.getValue();
            numberObjMap.put(obj.getString("number"), obj);
        }
        return numberObjMap;
    }

    private Map<String, DynamicObject> getBiz() {
        HashMap<String, DynamicObject> numberObjMap = new HashMap<String, DynamicObject>(64);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", (String)"id,fnumber,fname", null);
        if (CollectionUtils.isEmpty((Map)objectMap)) {
            return numberObjMap;
        }
        for (Map.Entry entry : objectMap.entrySet()) {
            DynamicObject obj = (DynamicObject)entry.getValue();
            numberObjMap.put(obj.getString("fnumber"), obj);
        }
        return numberObjMap;
    }

    private int getSelectedRowIndex() {
        EntryGrid relationTypeEntry = (EntryGrid)this.getControl(RELATION_TYPE_ENTRY);
        int[] selectRows = relationTypeEntry.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return -1;
        }
        return selectRows[0];
    }

    private void setOrgFuncId(BeforeF7SelectEvent event, String typeId) {
        int selectRow = this.getSelectedRowIndex();
        if (selectRow == -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u79cd\u534f\u4f5c\u7c7b\u578b\u3002", (String)"OrgRelationCheckPlugin_8", (String)"bos-org-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        DynamicObject bizObj = (DynamicObject)this.getModel().getValue(typeId, selectRow);
        if (bizObj != null) {
            event.getFormShowParameter().setCustomParam("orgFuncId", (Object)bizObj.getString("fnumber"));
        }
    }

    private void refreshOrg(int rowIndex) {
        this.getModel().deleteEntryData(TO_ORG_ENTRY);
        this.getModel().setValue("toorg", null);
        if (rowIndex < 0) {
            return;
        }
        Object relationItem = this.getModel().getValue("relationitem", rowIndex);
        if (StringUtils.isBlank((Object)relationItem)) {
            return;
        }
        OrgRelationItem orgRelationItem = (OrgRelationItem)SerializationUtils.fromJsonString((String)relationItem.toString(), OrgRelationItem.class);
        this.refreshOrgPropRelation(orgRelationItem, rowIndex);
        this.refreshRelationOrg(orgRelationItem);
    }

    private void refreshOrgPropRelation(OrgRelationItem orgRelationItem, int rowIndex) {
        OrgEdit orgEdit = (OrgEdit)this.getControl("toorg");
        orgEdit.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"\u672c\u7ec4\u7ec7%1$s%2$s", (String)"OrgRelationCheckPlugin_1", (String)"bos-org-formplugin", (Object[])new Object[0]), "-", this.getModel().getValue("tofieldname", rowIndex))));
        OrgProp orgProp = (OrgProp)orgEdit.getProperty();
        OrgRelationItemOrg org = orgRelationItem.getOrg();
        OrgEdit fromOrgEdit = (OrgEdit)this.getControl("fromorg");
        fromOrgEdit.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"\u5173\u8054\u7ec4\u7ec7%1$s%2$s", (String)"OrgRelationCheckPlugin_2", (String)"bos-org-formplugin", (Object[])new Object[0]), "-", this.getModel().getValue("fromfieldname", rowIndex))));
        org.setId(fromOrgEdit.getId());
        org.setNumber(fromOrgEdit.getKey());
        org.setName(fromOrgEdit.getProperty().getDisplayName().getLocaleValue());
        ArrayList<OrgRelationItem> orgRelation = new ArrayList<OrgRelationItem>(1);
        orgRelation.add(orgRelationItem);
        orgProp.setOrgRelation(orgRelation);
    }

    private void refreshRelationOrg(OrgRelationItem orgRelationItem) {
        DynamicObject fromOrgObj = (DynamicObject)this.getModel().getValue("fromorg");
        if (fromOrgObj == null) {
            return;
        }
        Map mapRet = orgRelationItem.toValidMap();
        mapRet.put("orgpkid", fromOrgObj.getPkValue());
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setCustomParam("orgRelation", (Object)mapRet);
        OrgRelationFilter relationFilter = new OrgRelationFilter(listShowParameter);
        List<Long> bizRelationOrgIds = relationFilter.getOrgIds();
        if (CollectionUtils.isEmpty(bizRelationOrgIds)) {
            return;
        }
        int[] indexArr = this.getModel().batchCreateNewEntryRow(TO_ORG_ENTRY, bizRelationOrgIds.size());
        int index = 0;
        for (Long relationOrgId : bizRelationOrgIds) {
            this.getModel().setValue("org", (Object)relationOrgId, indexArr[index++]);
        }
    }
}

