/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;

public class OrgRelationCondPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String BASE_CONDITION_CACHE = "base_condition_cache";
    private static final String CONDITION_CACHE = "condition_cache";
    private static final String LAST_ENTRY_ROW_INDEX = "lastEntryRowIndex";
    private static final String BOS_ENTITYOBJECT = "bos_entityobject";

    public void initialize() {
        this.addClickListeners(new String[]{"bar_save"});
        this.addItemClickListeners(new String[]{"toolbar"});
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initConditionParam();
    }

    private void initConditionParam() {
        Object conditionParam = this.getView().getFormShowParameter().getCustomParam("condition");
        if (StringUtils.isBlank((Object)conditionParam)) {
            return;
        }
        List conditionMapList = (List)SerializationUtils.fromJsonString((String)conditionParam.toString(), List.class);
        if (Utils.isListEmpty((List)conditionMapList)) {
            return;
        }
        for (Map conditionMap : conditionMapList) {
            int index = this.getModel().createNewEntryRow("entryentity");
            for (Map.Entry entry : conditionMap.entrySet()) {
                this.getModel().setValue("name", entry.getKey(), index);
            }
        }
        String condition = SerializationUtils.toJsonString((Object)conditionMapList);
        this.getPageCache().put(BASE_CONDITION_CACHE, condition);
        this.getPageCache().put(CONDITION_CACHE, condition);
        this.getPageCache().put(LAST_ENTRY_ROW_INDEX, "0");
    }

    public void afterBindData(EventObject e) {
        List<Map<String, String>> conditionMapList = this.getConditionCache();
        if (!conditionMapList.isEmpty()) {
            Map<String, String> conditionMap = conditionMapList.get(0);
            for (Map.Entry<String, String> entry : conditionMap.entrySet()) {
                this.updateFilterGrid(entry.getKey(), entry.getValue());
            }
        }
    }

    private List<Map<String, String>> getConditionCache() {
        String conditionCache = this.getPageCache().get(CONDITION_CACHE);
        List conditionMapList = null;
        if (StringUtils.isNotBlank((CharSequence)conditionCache)) {
            conditionMapList = (List)SerializationUtils.fromJsonString((String)conditionCache, List.class);
        }
        if (conditionMapList == null) {
            return new ArrayList<Map<String, String>>(0);
        }
        return conditionMapList;
    }

    private void updateFilterGrid(String bizObjectId, String condition) {
        FilterGrid filterGrid = (FilterGrid)this.getControl("rule");
        FilterCondition filterCondition = null;
        filterCondition = StringUtils.isBlank((CharSequence)condition) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)condition, FilterCondition.class);
        filterGrid.SetValue(filterCondition);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)bizObjectId);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        filterGrid.setEntityNumber(entityType.getName());
        filterGrid.setFilterColumns(filterColumns);
        this.getView().updateView("rule");
    }

    private void selectEntryRow(int selectedRowIndex) {
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.entryRowClick(Integer.valueOf(selectedRowIndex));
        entryentity.selectRows(selectedRowIndex);
    }

    public void click(EventObject evt) {
        String key;
        Object source = evt.getSource();
        if (source instanceof Button && "bar_save".equals(key = ((Button)source).getKey())) {
            List<Map<String, String>> conditionList = this.getConditionCache();
            String lastEntryRowIndex = this.getPageCache().get(LAST_ENTRY_ROW_INDEX);
            if (StringUtils.isNotBlank((CharSequence)lastEntryRowIndex)) {
                int entryRowIndex = Integer.parseInt(lastEntryRowIndex);
                this.updateConditionCache(conditionList, entryRowIndex);
            }
            this.getView().returnDataToParent(conditionList);
            this.getView().close();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "btn_add": {
                this.showEntityObjectF7();
                break;
            }
            case "btn_delete": {
                break;
            }
        }
    }

    private void showEntityObjectF7() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)BOS_ENTITYOBJECT, (boolean)true);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        if (Utils.isListNotEmpty((List)entryentity)) {
            ArrayList<Object> selectedList = new ArrayList<Object>(entryentity.size());
            for (DynamicObject bizObj : entryentity) {
                DynamicObject obj = bizObj.getDynamicObject("name");
                if (obj == null) continue;
                selectedList.add(obj.getPkValue());
            }
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            QFilter idFilter = new QFilter("id", "not in", selectedList);
            filterList.add(idFilter);
            lsp.setListFilterParameter(new ListFilterParameter(filterList, null));
        }
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BOS_ENTITYOBJECT));
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)e.getReturnData();
        if (Utils.isListEmpty((List)selectedRows)) {
            return;
        }
        switch (actionId) {
            case "bos_entityobject": {
                int index = 0;
                List<Map<String, String>> conditionList = this.getConditionCache();
                for (ListSelectedRow row : selectedRows) {
                    String bizObjectId = row.getPrimaryKeyValue().toString();
                    index = this.getModel().createNewEntryRow("entryentity");
                    this.getModel().setValue("name", (Object)bizObjectId, index);
                    HashMap<String, String> conditionMap = new HashMap<String, String>(1);
                    conditionMap.put(bizObjectId, "");
                    conditionList.add(conditionMap);
                }
                this.getPageCache().put(CONDITION_CACHE, SerializationUtils.toJsonString(conditionList));
                int newRows = selectedRows.size();
                int selectedRowIndex = 0;
                if (index > newRows) {
                    selectedRowIndex = index + 1 - newRows;
                }
                this.selectEntryRow(selectedRowIndex);
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        List<Map<String, String>> conditionList = this.getConditionCache();
        if (conditionList.isEmpty()) {
            return;
        }
        block0: for (int rowIndex : e.getRowIndexs()) {
            DynamicObject bizObj;
            DynamicObject entryentityObj = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            if (entryentityObj == null || (bizObj = entryentityObj.getDynamicObject("name")) == null) continue;
            String bizObjectId = bizObj.getString("id");
            Iterator<Map<String, String>> iterator = conditionList.iterator();
            while (iterator.hasNext()) {
                Map<String, String> conditionMap = iterator.next();
                if (!conditionMap.containsKey(bizObjectId)) continue;
                iterator.remove();
                continue block0;
            }
        }
        this.getPageCache().put(CONDITION_CACHE, SerializationUtils.toJsonString(conditionList));
    }

    public void entryRowClick(RowClickEvent evt) {
        int entryRowIndex;
        int rowIndex = evt.getRow();
        List<Map<String, String>> conditionList = this.getConditionCache();
        String lastEntryRowIndex = this.getPageCache().get(LAST_ENTRY_ROW_INDEX);
        if (StringUtils.isNotBlank((CharSequence)lastEntryRowIndex) && (entryRowIndex = Integer.parseInt(lastEntryRowIndex)) != rowIndex) {
            this.updateConditionCache(conditionList, entryRowIndex);
        }
        this.changeBizObject(conditionList, rowIndex);
        this.getPageCache().put(LAST_ENTRY_ROW_INDEX, Integer.toString(rowIndex));
    }

    private void updateConditionCache(List<Map<String, String>> conditionList, int entryRowIndex) {
        DynamicObject entryentityObj = this.getModel().getEntryRowEntity("entryentity", entryRowIndex);
        if (entryentityObj == null) {
            return;
        }
        DynamicObject bizObject = entryentityObj.getDynamicObject("name");
        if (bizObject == null) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl("rule");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        String filterConditionJson = SerializationUtils.toJsonString((Object)filterCondition);
        String bizObjectId = bizObject.getString("id");
        boolean isUpdateToCache = false;
        for (Map<String, String> conditionMap : conditionList) {
            if (!conditionMap.containsKey(bizObjectId)) continue;
            conditionMap.put(bizObjectId, filterConditionJson);
            isUpdateToCache = true;
            break;
        }
        if (!isUpdateToCache) {
            HashMap<String, String> conditionMap = new HashMap<String, String>(1);
            conditionMap.put(bizObjectId, filterConditionJson);
            conditionList.add(conditionMap);
        }
        this.getPageCache().put(CONDITION_CACHE, SerializationUtils.toJsonString(conditionList));
    }

    private void changeBizObject(List<Map<String, String>> conditionList, int entryRowIndex) {
        DynamicObject entryentityObj = this.getModel().getEntryRowEntity("entryentity", entryRowIndex);
        if (entryentityObj == null) {
            return;
        }
        DynamicObject bizObj = entryentityObj.getDynamicObject("name");
        if (bizObj == null) {
            return;
        }
        String bizObjectId = bizObj.getString("id");
        if (StringUtils.isBlank((CharSequence)bizObjectId)) {
            return;
        }
        for (Map<String, String> conditionMap : conditionList) {
            String condition = conditionMap.get(bizObjectId);
            if (condition == null) continue;
            this.updateFilterGrid(bizObjectId, condition);
            break;
        }
    }
}

